<?php

/**
 * Class DatabaseModel
 *
 * @property CI_DB db
 */
class DatabaseModel extends CI_Model
{
    public function validateLogin($username, $password)
    {
        $this->db->where('email', $username);
        $query = $this->db->get('users');
        if ($query->num_rows() == 1) {
            $result = $query->result();
            if (password_verify($password, $result[0]->password)) {
                $this->db->where('status', '1');
                $this->db->where('deleted', '0');
                $this->db->where('is_suspended', '0');
                if ($result[0]->status == 1 && $result[0]->deleted == 0 && $result[0]->is_suspend == 0) {
                    return array('status' => true, 'message' => 'success', 'data' => $result[0]);
                } elseif ($result[0]->is_suspend == 1) {
                    return array('status' => false, 'message' => ($result[0]->suspend_reason == '') ? 'Email or password is incorrect' : $result[0]->is_suspended, 'data' => 0);
                } elseif ($result[0]->status == 0) {
                    return array('status' => false, 'message' => 'Your Account is Deactivated. Please contact support', 'data' => 0);
                } else {
                    return array('status' => false, 'message' => 'Email or password is incorrect', 'data' => 0);
                }
            } else {
                return array('status' => false, 'message' => 'Email or password is incorrect', 'data' => 0);
            }
        } else {
            return array('status' => false, 'message' => 'Email or password is incorrect', 'data' => 0);
        }

    }

    public function fetchTableData($tableName, $condition = array(), $where_type = false)
    {
        if (is_array($condition) && !empty($condition)) {
            if (isset($where_type) && $where_type == 'OR') {
                $this->db->or_where($condition);
            } else {
                $this->db->where($condition);
            }

        }
        $result = $this->db->get($tableName);
        $this->db->order_by("id", "desc");
        if ($result->num_rows() >= 1) {
            $ret = array();
            foreach ($result->result() as $row) {
                $ret[] = $row;
            }
            return $ret;
        } else {
            return [];
        }

    }

    public function countTableData($tableName, $condition, $where_type = false)
    {
        $this->db->select('id');
        $this->db->from($tableName);
        if (isset($where_type) && $where_type == 'OR') {
            $this->db->or_where($condition);
        } else {
            $this->db->where($condition);
        }

        $result = $this->db->get();
        $this->db->order_by("id", "desc");
        if ($result->num_rows() >= 1) {
            return $result->num_rows();
        } else {
            return 0;
        }

    }

    public function searchTableData($tableName, $condition, $like)
    {
        $this->db->where($condition);
        $this->db->like($like);
        $result = $this->db->get($tableName);
        $this->db->order_by("id", "desc");
        if ($result->num_rows() >= 1) {
            $ret = array();
            foreach ($result->result() as $row) {
                $ret[] = $row;
            }
            return $ret;
        } else {
            return false;
        }

    }

    public function insertData($tableName, $insertData = array())
    {
        $result = $this->db->insert($tableName, $insertData);
        if ($result) {
            return $this->db->insert_id();
        } else {
            return false;
        }

    }

    public function updateTable($tableName, $updateData = array(), $condition = false)
    {

        $this->db->where($condition);
        $this->db->update($tableName, $updateData);
        $affectedRows = $this->db->affected_rows();
        if ($affectedRows > 0) {
            return true;
        } else {
            return false;
        }

    }

    //  sum of column
    public function sum_column_values($table, $column, $condition)
    {
        $this->db->select_sum($column);
        $this->db->where($condition);
        $query = $this->db->get($table);
        return $query->result();
    }
    public function deleteRows($tableName, $array)
    {
        $this->db->delete($tableName, $array);
        $check_delete = $this->db->affected_rows();
        // dd($check_delete);
        if ($check_delete) {
            return true;
        } else {
            return false;
        }

    }

    /**
     * @param $table, table name
     * @param $data, parameters on which you want to check existence of record(s)
     * @return bool
     */
    public function exists($table, $data = array())
    {
        $query = $this->db->get_where($table, $data);
        $num_rows = ($query->num_rows());

        if ($num_rows >= 1) {
            return true;
        } else {
            return false;

        }

    }
    public function checkexists($table, $email)
    {
        $this->db->where('email', $email);
        $this->db->where('deleted', 1);
        $query = $this->db->get($table);

        $num_rows = ($query->num_rows());
        if ($num_rows == 1) {
            return true;
        }
        return false;
    }

    /**
     * @param $first_date, Start Time
     * @param $second_date, End Time
     * @param  $table, Table Name
     *
     * @return array
     */
    public function getFilterDate($first_date, $second_date, $table)
    {
        $this->db->select('*');
        $this->db->from($table);
        $this->db->where('created >=', date('Y-m-d H:m:s', strtotime($first_date)));
        $this->db->where('created <=', date('Y-m-d H:m:s', strtotime($second_date)));
        $query = $this->db->get();

        return $query->result_array();
    }

    public function getField($field, $table, $col, $value)
    {
        $this->db->select($field);
        $this->db->from($table);
        $this->db->where($col, $value);
        return $this->db->get()->row($field);
    }

    public function activeUserLast($table)
    {
        $this->db->where("login_at >= DATE_SUB(NOW(),INTERVAL 72 HOUR)", null, false);
        $result = $this->db->get($table);
        if ($result->num_rows() >= 1) {
            foreach ($result->result() as $row) {
                $completerow[] = $row;
            }

            return $completerow;
        } else {
            return array();
        }

    }

    public function fetchdataGroupBy($tableName, $condition = array(), $where_type = false, $groupby = array())
    {

        if (is_array($condition) && !empty($condition)) {
            if (isset($where_type) && $where_type == 'OR') {
                $this->db->or_where($condition);
            } else {
                $this->db->where($condition);
            }

        }

        $this->db->group_by($groupby);
        $result = $this->db->get($tableName);

        if ($result->num_rows() >= 1) {
            $ret = array();
            foreach ($result->result() as $row) {
                $ret[] = $row;
            }
            return $ret;
        } else {
            return false;
        }

    }
}