<?php
/**
 * Created by PhpStorm.
 * User: anuj
 * Date: 25/1/18
 * Time: 11:14 AM
 */


class YoutubeUpload
{
    private $access_token;
    private $GOOGLE_CLIENT_ID;
    private $GOOGLE_CLIENT_SECRET;

    /**
     * YoutubeUpload constructor.
     * @param $access_token : initializes user's access token
     */
    public function connect($access_token)
    {
        $this->access_token = $access_token;
        $this->GOOGLE_CLIENT_ID = GOOGLE_CLIENT_ID;
        $this->GOOGLE_CLIENT_SECRET = GOOGLE_CLIENT_SECRET;
    }



    /**
     * @param $file
     * @param $title
     * @param $description
     * @return mixed
     */
    public function upload($file, $title, $description)
    {

        $videoPath = $file;

        /**
         * if video file does not exists, return
         */
        if (!file_exists($videoPath)) {
            $response['status'] = false;
            $response['message'] = 'Video File does not exists.';

            return $response;
        }


        $client = new Google_Client();
        $client->setClientId($this->GOOGLE_CLIENT_ID);
        $client->setClientSecret($this->GOOGLE_CLIENT_SECRET);
        $client->setAccessToken($this->access_token);

        $youtube = new Google_Service_YouTube($client);

        try{
            // REPLACE this value with the path to the file you are uploading.
            $videoPath = $file;

            // Create a snippet with title, description, tags and category ID
            // Create an asset resource and set its snippet metadata and type.
            // This example sets the video's title, description, keyword tags, and
            // video category.
            $snippet = new Google_Service_YouTube_VideoSnippet();
            $snippet->setTitle($title);
            $snippet->setDescription($description);
            //$snippet->setTags(array("tag1", "tag2"));

            // Numeric video category. See
            // https://developers.google.com/youtube/v3/docs/videoCategories/list
            $snippet->setCategoryId("22");

            // Set the video's status to "public". Valid statuses are "public",
            // "private" and "unlisted".
            $status = new Google_Service_YouTube_VideoStatus();
            $status->privacyStatus = "public";

            // Associate the snippet and status objects with a new video resource.
            $video = new Google_Service_YouTube_Video();
            $video->setSnippet($snippet);
            $video->setStatus($status);

            // Specify the size of each chunk of data, in bytes. Set a higher value for
            // reliable connection as fewer chunks lead to faster uploads. Set a lower
            // value for better recovery on less reliable connections.
            $chunkSizeBytes = 1 * 1024 * 1024;

            // Setting the defer flag to true tells the client to return a request which can be called
            // with ->execute(); instead of making the API call immediately.
            $client->setDefer(true);

            // Create a request for the API's videos.insert method to create and upload the video.
            $insertRequest = $youtube->videos->insert("status,snippet", $video);

            // Create a MediaFileUpload object for resumable uploads.
            $media = new Google_Http_MediaFileUpload(
                $client,
                $insertRequest,
                'video/*',
                null,
                true,
                $chunkSizeBytes
            );
            $media->setFileSize(filesize($videoPath));


            // Read the media file and upload it chunk by chunk.
            $status = false;
            $handle = fopen($videoPath, "rb");
            while (!$status && !feof($handle)) {
                $chunk = fread($handle, $chunkSizeBytes);
                $status = $media->nextChunk($chunk);
            }

            fclose($handle);

            // If you want to make other calls after the file upload, set setDefer back to false
            $client->setDefer(false);

            $response['status'] = true;
            $response['title'] = $status['snippet']['title'];
            $response['video_id'] = $status['id'];
            $response['data'] = $status;

        } catch (Google_Service_Exception $e) {
            $response['status'] = false;
            $response_message = json_decode($e->getMessage());
            //debug($response_message);
            $response['message'] = $response_message->error->errors[0]->message;
        } catch (Google_Exception $e) {
            $response['status'] = false;
            $response_message = json_decode($e->getMessage());
            $response['message'] = $response_message->error->errors[0]->message;
        }
        return $response;
    }
}
