<?php

class Stripe
{
    private $CI;

    public function __construct()
    {
        $this->CI = &get_instance();
    }

    public function createOrder($name,$amount,$email,$paymentId){
        $getDetails = $this->CI->DatabaseModel->fetchtableData('integration',array('id' => $paymentId));
        if($getDetails)
        {
            $privateKey = '';
            $stripe = new \Stripe\StripeClient($privateKey);
            $data = $stripe->checkout->sessions->create(
                [
                    'line_items' => [
                        [
                            'price_data' => [
                                'currency' => 'inr',
                                'product_data' => ['name' => $name],
                                'unit_amount' => $amount * 100,
                            ],
                            'quantity' => 1,

                        ],
                    ],
                    'mode' => 'payment',
                    'customer_email' => $email,
                    'success_url' => base_url().'stripe-success',
                    'cancel_url' =>  base_url().'stripe-error',
                ]
            );

            $response = array('status' => true, 'data' => $data);
        }
        else{
            $response = array('status' => false, 'data' => 'Not able to get the payment details');
        }
        return $response;

    }
}