<?php
class Paypal
{
    private $CI;

    public function __construct()
    {
        $this->CI = &get_instance();
    }

    public function createOrderPaypal($buyerName, $buyerEmail, $productId, $paymentId, $paymentMode, $price, $baseCurrency)
    {
        $paypalInfo = $this->CI->DatabaseModel->fetchTableData('integration', array('id' => $paymentId));
        $paypalInfoDecoded = json_decode($paypalInfo[0]->data);
        if ($paymentMode === 'sandbox') {
            $postUrl = 'https://www.sandbox.paypal.com';
            $clientID = $paypalInfoDecoded->client_id;
            $secretId = $paypalInfoDecoded->secret_id;
        } else {
            $postUrl = 'https://www.paypal.com';
            $clientID = $paypalInfoDecoded->live_client_id;
            $secretId = $paypalInfoDecoded->live_secret_id;
        }
        if (($paypalInfo != false)) {
            
            $url =  $postUrl . '/v2/checkout/orders';
            $data = array(
                'intent' => 'CAPTURE',
                'purchase_units'=> array(
                    0 => array(
                        'amount' => array(
                            'currency_code' => $baseCurrency,
                            'value' => $price,
                            'breakdown' => array(
                                'item_total' => array(
                                    'currency_code' => $baseCurrency,
                                    'value' => $price
                                ) // item ends
                            ) // breakDownEnds
                        ) // Amount ends
                    ) // First element of purchase units
                ),  // purchase units ends
                'redirect_urls' => array(
                    'return_url' => base_url().'paypal-success',
                    'cancel_url' => base_url().'paypal-error',
                )
            );
            $res = $this->CI->adi->curl_post_request_json($url,$data,$clientID,$secretId);
       if (!empty($res) && isset($res->id)) {

               $insert['paymentId'] = $paymentId;
               $insert['orderId'] = $res->id;
               $insert['paymentType'] = 'PayPal';
               $insert['pId'] = $productId;
               $insert['bId'] = $paypalInfo[0]->bid;
               $insert['payer_id'] = '';
               $insert['userId'] = $paypalInfo[0]->userId;
               $insert['buyerEmail'] = $buyerEmail;
               $insert['buyerName'] = $buyerName;
               $insert['currency'] = $baseCurrency;
               $insert['price'] = $price;
               $insert['paymentUrl'] = $res->links[1]->href;
               $insert['paymentMode'] = $paymentMode;
               $insert['status'] = 1;
               $insert['isDeleted'] = 0;
              

            if ($res->status == 'CREATED') {
               
                   $checkInsert = $this->CI->DatabaseModel->insertData('orders', $insert);
            if ($checkInsert) {
                   $orderArr = array(
                       "id" => $checkInsert,
                       "product_id" => $productId,
                       "order_id" => $res->id,
                       "order_token" => '',
                       "payment_url" => $res->links[1]->href,
                   );
                   return array('status' => true, 'message' => 'Successfully created order', 'data' => $orderArr);
               
                       } else {
                        return array('status' => false, 'message' => 'Something went wrong! try again');
                    }

                  } else {
                    return array('status' => false, 'message' => 'Something went wrong! try again');
                }

              } else {
                 return array('status' => false, 'message' => $res);
             }
        } else {
            return array('status' => false, 'message' => 'Something went wrong!');
        }
    }




    public function successPaypalPayment()
    {
        $token = $_GET['token'];
        $PayerID = $_GET['PayerID'];

        if (!empty($token)) {
            $orderInfo = $this->CI->DatabaseModel->fetchTableData('orders', array('orderId' => $token));
             $paymentId = $orderInfo[0]->paymentId;
            $orderid = $orderInfo[0]->id;
            $orderstatus = $orderInfo[0]->status;
            $paymentMode = $orderInfo[0]->paymentMode;
            $paypalInfo = $this->CI->DatabaseModel->fetchTableData('integration', array('id' => $paymentId));
            $paypalInfoDecoded = json_decode($paypalInfo[0]->data);
            if ($paymentMode === 'sandbox') {
              
                $postUrl = 'https://www.sandbox.paypal.com';
                $mode = true;
                $apiUrl = 'https://api.sandbox.paypal.com';
                $clientID = $paypalInfoDecoded->client_id;
                $secretId = $paypalInfoDecoded->secret_id;
            } else {
                
                $postUrl = 'https://www.paypal.com';
                $mode = false;
                $apiUrl = 'https://api.paypal.com';
                $clientID = $paypalInfoDecoded->live_client_id;
                $secretId = $paypalInfoDecoded->live_secret_id;
                }
            if (!empty($paypalInfo)) {

                $date = date('Y-m-d H:i:s');
                $curl = curl_init();

                curl_setopt_array($curl, array(
                    CURLOPT_URL => $postUrl . '/v2/checkout/orders/' . $token,
                    CURLOPT_RETURNTRANSFER => true,
                    CURLOPT_USERPWD => $clientID . ":" . $secretId,
                    CURLOPT_ENCODING => '',
                    CURLOPT_MAXREDIRS => 10,
                    CURLOPT_TIMEOUT => 0,
                    CURLOPT_FOLLOWLOCATION => true,
                    CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                    CURLOPT_CUSTOMREQUEST => 'GET',
                    CURLOPT_HTTPHEADER => array(
                        'Content-Type: application/json',
                        //'Cookie: cookie_check=yes; d_id=361998d8a98d409189f15189ce4027ae1657536156911; enforce_policy=ccpa; ts=vreXpYrS%3D1752230556%26vteXpYrS%3D1657537956%26vr%3Dec8baa841810a6022c95375cfa28502b%26vt%3Decd841381810a602060bf5f9fa22a520%26vtyp%3Dreturn; ts_c=vr%3Dec8baa841810a6022c95375cfa28502b%26vt%3Decd841381810a602060bf5f9fa22a520; tsrce=unifiedloginnodeweb; x-csrf-jwt=eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJ0b2tlbiI6IjhObDVwQWV1RWphREJnX05BUHEzN3ZtdFlnZ3M1VGl3YnROVTFheEtQNkR3U1o4NFhxR3daTERGaE9sZldVUktZRzVMeU9fajZ1NE8yQXRaNFhIOTZFOHpsYnp0Q1Raa2RPdVJkbHBOVHBuaVhPb3o0emtITjVNSmswYklZUWplcjJIbFp2dHR6OFBmeEFVZFFVc05LbFQ2VG5QTXhSVXNuaGhRQVNQMWtJb2FYSFUzQ0tzVHI5cndoYXUiLCJpYXQiOjE2NTc1MzA5OTksImV4cCI6MTY1NzUzNDU5OX0.ekEHOWvZx1S2R0QX_l2OKUivNnd9GEx3MYkP0TzB1v4',
                    ),
                ));

                $response = curl_exec($curl);  
                curl_close($curl);
                $res = json_decode($response);
                if (isset($res->id) && isset($res->status)) {
                   $insert['status'] = $res->status;
                   $insert['payer_id'] = $PayerID;
                    $insert['modified'] = $date;
                    $updateinfo = $this->CI->DatabaseModel->updateTable('orders', $insert, array('id' => $orderid));
                 if ($updateinfo) {
                   
                 if ($res->status == 'APPROVED') {
                    
                                $curl = curl_init();

                                curl_setopt_array($curl, array(
                                    CURLOPT_URL => $apiUrl . '/v2/checkout/orders/' . $token . '/capture',
                                    CURLOPT_RETURNTRANSFER => true,
                                    CURLOPT_USERPWD => $clientID . ":" . $secretId,
                                    CURLOPT_ENCODING => '',
                                    CURLOPT_MAXREDIRS => 10,
                                    CURLOPT_TIMEOUT => 0,
                                    CURLOPT_FOLLOWLOCATION => true,
                                    CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                                    CURLOPT_CUSTOMREQUEST => 'POST',
                                    CURLOPT_HTTPHEADER => array(
                                        'Content-Type: application/json',
                                      //'Cookie: cookie_check=yes; d_id=361998d8a98d409189f15189ce4027ae1657536156911; enforce_policy=ccpa; ts=vreXpYrS%3D1752230556%26vteXpYrS%3D1657537956%26vr%3Dec8baa841810a6022c95375cfa28502b%26vt%3Decd841381810a602060bf5f9fa22a520%26vtyp%3Dreturn; ts_c=vr%3Dec8baa841810a6022c95375cfa28502b%26vt%3Decd841381810a602060bf5f9fa22a520; tsrce=unifiedloginnodeweb; x-csrf-jwt=eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJ0b2tlbiI6IjhObDVwQWV1RWphREJnX05BUHEzN3ZtdFlnZ3M1VGl3YnROVTFheEtQNkR3U1o4NFhxR3daTERGaE9sZldVUktZRzVMeU9fajZ1NE8yQXRaNFhIOTZFOHpsYnp0Q1Raa2RPdVJkbHBOVHBuaVhPb3o0emtITjVNSmswYklZUWplcjJIbFp2dHR6OFBmeEFVZFFVc05LbFQ2VG5QTXhSVXNuaGhRQVNQMWtJb2FYSFUzQ0tzVHI5cndoYXUiLCJpYXQiOjE2NTc1MzA5OTksImV4cCI6MTY1NzUzNDU5OX0.ekEHOWvZx1S2R0QX_l2OKUivNnd9GEx3MYkP0TzB1v4',
                                    ),
                                ));

                                $response = curl_exec($curl);
                                 print_r($response);
                                
                                curl_close($curl);
                                $capture = json_decode($response);
                                if (isset($capture->id) && isset($capture->status)) {
                                    $update['status'] = $capture->status;
                                    $update['updated'] = $date;
                                    $updateinfocapture = $this->CI->DatabaseModel->updateTable('orders', $update, array('id' => $orderid));

                                }

                            } else {
                                if (isset($res->id) && isset($res->status) && $res->status == 'COMPLETED') {
                                    if ($orderstatus != 'COMPLETED') {
                                        $update['status'] = $res->status;
                                        $update['is_status'] = 4;
                                        $update['updated'] = $date;
                                        $updateinfocapture = $this->CI->DatabaseModel->updateTable('orders', $update, array('id' => $orderid));
                                        $productOrderDataGet = $this->CI->DatabaseModel->fetchTableData('orders', array('id' => $orderid));
                                        if (!empty($productOrderDataGet)) {
                                            $producID = $productOrderDataGet[0]->pId;
                                            $productDataGet = $this->CI->DatabaseModel->fetchTableData('products', array('id' => $producID));
                                            if (!empty($productDataGet) && !empty($productDataGet[0]->ipn)) {
                                                $ipnData = json_decode($productDataGet[0]->ipn);
                                                if ($ipnData->enable === true && $ipnData->url != '') {
                                                    $postArr = array('name' => $productOrderDataGet[0]->buyer_name, 'email' => $productOrderDataGet[0]->buyer_email, 'product_id' => $productDataGet[0]->numberOfPayment);
                                                    $this->ipnCall($ipnData->url, $postArr);
                                                }
                                            }
                                        }
                                   
                                        $currency = $this->CI->DatabaseModel->fetchTableData('addon_domain', array('userId' => $productDataGet[0]->userId));
                                        $business_info = $this->CI->DatabaseModel->fetchTableData('business', array('userId' => $productDataGet[0]->userId));
                                        $d = array('Invoice' => $orderid, 'created' => $productOrderDataGet[0]->created, 'price' => $productOrderDataGet[0]->price, 'title' => $productDataGet[0]->name, 'description' => $productDataGet[0]->description, 'bussinessName' => $business_info[0]->name, 'bussinessEmail' => $business_info[0]->email, 'bussinessphone' => $business_info[0]->phone, 'bussinesslink' => $business_info[0]->url, 'bussinessimage' => $business_info[0]->logo);
                                        //$body = $this->load->view('invoice', $d, true);
                                        $this->mailer->send_mail($productOrderDataGet[0]->buyerEmail, 'Invoice | ' . APP_NAME, 'payment comnpleted');
                                        $data['thankyouPage'] = ($productDataGet[0]->thankuPage) ? $productDataGet[0]->thankuPage : '';
                                       // $productSetting = $this->CI->DatabaseModel->fetchTableData('product_setting', array('product_id' => $productOrderDataGet[0]->pId));
                                       // $data['firepixel'] = ($productSetting) ? $productSetting[0] : '';
                                        if (!empty($productDataGet[0]->autoresponder)) {
                                            $this->addAutoResponder($productOrderDataGet[0]->buyerName, $productOrderDataGet[0]->buyerEmail, $productDataGet[0]->autoresponder);
                                        }
                                        $response = array('status' => true, 'message' => 'success');
                                       // $this->load->view('pages/success', $data);
                                    } else {
                                        echo 'Allready process complete';exit;
                                    }
                                } else {
                                   // $this->load->view('pages/cancel');
                                    //echo $res->status;exit;
                                }
                            }

                    } else {
                     $response = array('status' => false, 'message' => 'Something went wrong! try again');
                    }
                }
            }

        }

    }

    public function cancelPaypalPayment()
    {
        $token = $_GET['token'];
        if (!empty($token)) {
            $orderInfo = $this->CI->DatabaseModel->fetchTableData('orders', array('uniqe_order_id' => $token));
            $integration_id = $orderInfo[0]->paymentId;
            $orderid = $orderInfo[0]->id;
            $orderstatus = $orderInfo[0]->status;
            $paymentMode = $orderInfo[0]->paymentMode;
            $paypalInfo = $this->CI->DatabaseModel->fetchTableData('integration', array('id' => $paymentId));
            $paypalInfoDecoded = json_decode($paypalInfo[0]->data);
            if ($paymentMode === 'sandbox') {
              
                $postUrl = 'https://www.sandbox.paypal.com';
                $mode = true;
                $apiUrl = 'https://api.sandbox.paypal.com';
                $clientID = $paypalInfoDecoded->client_id;
                $secretId = $paypalInfoDecoded->secret_id;
            } else {
                
                $postUrl = 'https://www.paypal.com';
                $mode = false;
                $apiUrl = 'https://api.paypal.com';
                $clientID = $paypalInfoDecoded->live_client_id;
                $secretId = $paypalInfoDecoded->live_secret_id;
                }
            if (!empty($paypalInfo)) {

                $date = date('Y-m-d H:i:s');
                $curl = curl_init();

                curl_setopt_array($curl, array(
                    CURLOPT_URL => $postUrl . '/v2/checkout/orders/' . $token,
                    CURLOPT_RETURNTRANSFER => true,
                    CURLOPT_USERPWD => $clientID . ":" . $secretId,
                    CURLOPT_ENCODING => '',
                    CURLOPT_MAXREDIRS => 10,
                    CURLOPT_TIMEOUT => 0,
                    CURLOPT_FOLLOWLOCATION => true,
                    CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                    CURLOPT_CUSTOMREQUEST => 'GET',
                    CURLOPT_HTTPHEADER => array(
                        'Content-Type: application/json',
                        //'Cookie: cookie_check=yes; d_id=361998d8a98d409189f15189ce4027ae1657536156911; enforce_policy=ccpa; ts=vreXpYrS%3D1752230556%26vteXpYrS%3D1657537956%26vr%3Dec8baa841810a6022c95375cfa28502b%26vt%3Decd841381810a602060bf5f9fa22a520%26vtyp%3Dreturn; ts_c=vr%3Dec8baa841810a6022c95375cfa28502b%26vt%3Decd841381810a602060bf5f9fa22a520; tsrce=unifiedloginnodeweb; x-csrf-jwt=eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJ0b2tlbiI6IjhObDVwQWV1RWphREJnX05BUHEzN3ZtdFlnZ3M1VGl3YnROVTFheEtQNkR3U1o4NFhxR3daTERGaE9sZldVUktZRzVMeU9fajZ1NE8yQXRaNFhIOTZFOHpsYnp0Q1Raa2RPdVJkbHBOVHBuaVhPb3o0emtITjVNSmswYklZUWplcjJIbFp2dHR6OFBmeEFVZFFVc05LbFQ2VG5QTXhSVXNuaGhRQVNQMWtJb2FYSFUzQ0tzVHI5cndoYXUiLCJpYXQiOjE2NTc1MzA5OTksImV4cCI6MTY1NzUzNDU5OX0.ekEHOWvZx1S2R0QX_l2OKUivNnd9GEx3MYkP0TzB1v4',
                    ),
                ));

                $response = curl_exec($curl);
                curl_close($curl);
                $res = json_decode($response);
                if (isset($res->id) && isset($res->status)) {
                    $insert['status'] = $res->status;
                    $insert['is_status'] = 7;
                    $insert['updated'] = $date;
                    $updateinfo = $this->CI->DatabaseModel->updateTable('orders', $insert, array('id' => $orderid));
                    //$this->load->view('pages/cancel');
                    if ($updateinfo) {
                    } else {
                        $response = array('status' => false, 'message' => 'Something went wrong! try again');
                    }
                }
            }

        }

    }



}