<?php

/**
 * @property CI_Controller $CI
 */
class Openai
{

    public function __construct()
    {
        $this->CI = &get_instance();
    }

    private function getHeader(){
        $fetchToken = $this->CI->DatabaseModel->fetchTableData('token_ai', array('status' => 1));
        if(is_array($fetchToken) && count($fetchToken) >= 1){
            return array(
                'Content-Type: application/json',
                'Authorization: Bearer '.$fetchToken[0]->token
            );
        }

    }

    private function content_moderation($text)
    {
        $url = 'https://api.openai.com/v1/moderations';
        $headers = $this->getHeader();
        //$object = '{"input": "' . json_encode($text) . '"}';
        $object = array('input' => $text);
        $response = $this->CI->adi->curl_post_request($url,json_encode($object),'yes',$headers);
        if(is_array($response)){
            foreach($response as $key => $value){
                if($value->flagged == true){
                    return true;
                }
                else{
                    continue;
                }
            }
        }
    }

    public function searchAi($text,$userId,$contentType){
        $data = array(
            'status' => false,
            'message' => 'Some Error occurred',
        );
        $url = 'https://api.openai.com/v1/completions';
        $headers = $this->getHeader();
        $object = '{
                    "model": "text-davinci-002",
                    "prompt": "' . $text . '",
                    "temperature": 0.7,
                    "max_tokens": 256,
                    "top_p": 1,
                    "frequency_penalty": 0,
                    "presence_penalty": 0,
                    "user": "user_'.$userId.'"
                    }';
        $response = $this->CI->adi->curl_post_request($url,$object,'yes',$headers);
        if (isset($response->error)) {
            $data = array(
                'status' => false,
                'message' => 'Something went wrong.',
            );
        }
        if (!empty($response) && $response->id) {
            $textGet = $response->choices[0]->text;
            $textGetArray = preg_split("/\r\n|\n|\r/", $textGet);
            $newText = array();
            if ($contentType == 'list') {
                if (!empty($textGetArray)) {
                    $r = 1;
                    foreach ($textGetArray as $str) {
                        if (!empty($str) && $str != ':') {
                            $str = str_replace($r . '.', '', $str);
                            $newText[] = $str;

                        }
                        $r++;
                    }
                }
            }
            else{
                $newText[] = $textGet;
            }


            $check = $this->content_moderation($newText);
            if($check)
            {
                $data = array(
                    'status' => false,
                    'message' => 'Input provided is against our content policy. Please try again',
                );
            }
            else{

                $data = array(
                    'status' => true,
                    'message' => 'Success',
                    'data' => $newText,
                );
            }
        }

        return $data;
    }

    public function keyword($text){
        $object = array(
            'prompt' => $text.'  Keywords:',
            'max_tokens' => 60,
            "temperature" => 0.3,
            "top_p" => 1,
            "frequency_penalty" => 0.8,
            "presence_penalty" => 0.0,
            "stop" => "\n"
        );
        $url = 'https://api.openai.com/v1/engines/davinci/completions';
        $headers = $this->getHeader();
        $response = $this->CI->adi->curl_post_request($url,json_encode($object),'yes',$headers);
        if(isset($response->error)) {
            return array('status'=>false, 'message'=>$response->error->message);
        } else {
            $keywords = $response->choices[0]->text;
            $keywords = explode(',',$keywords);
            return array('status'=>true,'keywords'=>$keywords);
        }
    }


}