<?php
class Media
{
    private $CI;
    private $token;
    private $base;

    public function __construct()
    {
        $this->CI = &get_instance();
        $this->token = MEDIA_API_TOKEN;
        $this->base = MEDIA_API_URL;
    }

    public function searchImages($keyword, $page = null)
    {
        $url = $this->base . 'get-photo/search?keyword=' . urlencode($keyword) . '&page=' . $page;
        $result = $this->CI->adi->curl_get_authorization($url, $this->token);
        if ($result->status == true && $result->data != null) {
            $return['status'] = true;
            $return['message'] = $result->data;
        } else {
            $return['status'] = false;
            $return['message'] = 'Sorry, no results found for that query. Please a different keyword.';
        }
        return $return;
    }

    public function searchMusic($page = null)
    {
        $url = $this->base . 'get-music-random/search?page=' . $page . '&limit=40';
        $result = $this->CI->adi->curl_get_authorization($url, $this->token);
        $list_final = array();
        if (isset($result->status) && $result->status == 1 && !empty($result->data)) {
            $list_final[] = $result->data;
            $send_data['status'] = true;
            $send_data['message'] = $list_final[0];
        } else {
            $send_data['status'] = false;
            $send_data['message'] = 'It seems that we do not have any more music';
        }
        return $send_data;
    }

    /**
     *  Search video through keyword.
     * @param $keyword , string to find results
     * @param int $page , page no
     * @return bool
     */
    public function searchVideo($keyword, $page = 1)
    {
        $url = $this->base . 'get-videos/search?keyword=' . urlencode($keyword) . '&page=' . $page;
        $result = $this->CI->adi->curl_get_authorization($url, $this->token);
        if ($result->status == true && $result->data != null) {
            $return['status'] = true;
            $return['message'] = $result->data;
        } else {
            $return['status'] = false;
            $return['message'] = 'Sorry, no results found for that query. Please a different keyword.';
        }
        return $return;
    }

}