<?php defined('BASEPATH') or exit('No direct script access allowed');
require "vendor/autoload.php";
use PHPMailer\PHPMailer\PHPMailer;

/**
 * @property string fromEmail
 * @property string fromName
 * @property string brand
 * @property string brandUrl
 * @property string host
 * @property string username
 * @property string password
 * @property int port
 * @property PHPMailer mail
 * 
 */
class Mailer
{

    public function __construct()
    {
        $this->CI = &get_instance();
        $this->CI->load->model('DatabaseModel');
        $this->fromEmail = 'abhi@abhineos.com';
        $this->fromName = 'Abhi Dwivedi';
        $this->brand = 'FastPaid';
        $this->brandUrl = 'https://fe.fastpaid.io/';

         $smtp_details = $this->CI->DatabaseModel->fetchTableData('smtp');
  
           $this->mail = new PHPMailer;
            $this->mail->isSMTP();
            $this->mail->Host = $smtp_details[0]->smtp_host ?? '';
            $this->mail->SMTPAuth = true;
            $this->mail->Username = $smtp_details[0]->smtp_user ?? '';
            $this->mail->Password = $smtp_details[0]->smtp_pass ?? '';
            $this->mail->Port = $smtp_details[0]->smtp_port ?? '';
            $this->mail->setFrom($this->fromEmail, $this->fromName);		
             $this->mail->isHTML(true);	
        
          }

    public function send_password_rest_mail($email, $link)
    {
       
        $body = "Hey,<br /><br />

		You had requested to reset your password. Please Click the <a href='$link'>Reset Password</a> to reset your password. <br /><br />

		You can also copy and paste this link in your browser to reset your password $link

		<br /><br />
		Reach out to us if you have any support queries: <a href='http://support.vineasx.com'>http://support.vineasx.com</a> <br />
		<br /><br />
		Cheers,<br />
		Abhi Dwivedi<br />
		" . $this->brand . " Team";

        $this->mail->addAddress($email, '');
        $this->mail->Subject = $this->brand . ' Password Reset';
        $this->mail->Body = $body;
       
            if($this->mail->send()){
            return true;
        } else {
          return false;
        }
    }

    public function delete_client_send_mail($email,$name)
    {
       
        $body = "Dear ".$name.",<br /><br />

		
        We would like to inform you that your client account has been successfully deleted .<br /><br />  
        If you encounter any issues or have any questions regarding your client account deletion, please do not hesitate to contact our support team at <a href='http://support.vineasx.com'>http://support.vineasx.com</a>. Our team will be happy to assist you and address any concerns you may have.
        <br /><br />
        We would like to take this opportunity to thank you for using our app as a client. We value your support and your feedback, and we are constantly working to improve our app to meet the needs of our users.
		<br /><br />
        Thank you again for using our app.<br /><br />
       
		Sincerely,<br /><br />
		" . $this->brand . " Team";

        $this->mail->addAddress($email, '');
        $this->mail->Subject = $this->brand . ' Client Account Deleted';
        $this->mail->Body = $body;
       
            if($this->mail->send()){
            return true;
        } else {
          return false;
        }
    }

    public function delete_account_send_mail($email,$name)
    {
       
        $body = "Dear ".$name.",<br /><br />

		
        We would like to inform you that your account has been successfully deleted from our app. We apologize for any inconvenience this may have caused you.Please note that deleting your account means that all of your data and information have been permanently removed from our system. If you encounter any issues or have any questions regarding your account deletion, please do not hesitate to contact our support team at <a href='http://support.vineasx.com'>http://support.vineasx.com</a>. Our team will be happy to assist you and address any concerns you may have.";

        $this->mail->addAddress($email, '');
        $this->mail->Subject = $this->brand . ' User Deleted';
        $this->mail->Body = $body;
       
            if($this->mail->send()){
            return true;
        } else {
          return false;
        }
    }

    public function disable_account_send_mail($email,$name)
    {
       
        $body = "Dear ".$name.",<br /><br />

		
        We would like to inform you that your account has been successfully disabled from our app.<br /><br />  
        Please note that disabling your account means that your account is no longer accessible to other users, but your data and information are still stored in our system. 
        <br /><br />
        If you encounter any issues or have any questions regarding your account disabling, please do not hesitate to contact our support team at <a href='http://support.vineasx.com'>http://support.vineasx.com</a>. Our team will be happy to assist you and address any concerns you may have.
		<br /><br />
        We value your support and your feedback, and we are constantly working to improve our app to meet the needs of our users.<br /><br />
        Thank you again for using our app.<br /><br />
		Sincerely,<br /><br />
		" . $this->brand . " Team";

        $this->mail->addAddress($email, '');
        $this->mail->Subject = $this->brand . ' Account Disabled';
        $this->mail->Body = $body;
       
            if($this->mail->send()){
            return true;
        } else {
          return false;
        }
    }

    public function send_update_mail($email,$name)
    {
       
        $body = "Hey ".$name.",<br /><br />

		This is to inform you that your email address associated with your account has been updated successfully.
        We have recently received a request to update the email address in our system, and we have verified the request and updated your account accordingly. <br /><br />

		Please note that all future communications and notifications related to your account will be sent to your new email address. It is important that you keep your contact information up to date so that we can keep you informed about any changes or updates related to your account.

		<br /><br />
		If you did not initiate this update request, please contact us immediately at: <a href='http://support.vineasx.com'>http://support.vineasx.com</a> so that we can investigate the matter and ensure the security of your account. <br />
		<br /><br />
        Thank you for choosing our services. If you have any further questions or concerns, please do not hesitate to contact us.
		<br /><br />
		Best regards,<br /><br />
		" . $this->brand . " Team";

        $this->mail->addAddress($email, '');
        $this->mail->Subject = $this->brand . ' Your Email Address Updated';
        $this->mail->Body = $body;
       
            if($this->mail->send()){
            return true;
        } else {
          return false;
        }
    }

    public function password_update($email,$password)
    {
 $body = "
        Hey,<br /><br />

        Your password for $brand has been changed. Your new password is $password. Please logout and login with the new password.

        <br /><br />
        Reach out to us if you have any support queries: <a href='http://support.vega6.com'>http://support.vega6.com</a> <br />
        <br /><br />
        Cheers,<br />
        Abhi Dwivedi<br />
        " . $this->brand . " Team

        ";

        $alt_body = "Hey,
        Your password for $brand has been changed. Your new password is $password. Please logout and login with the new password.

        Reach out to us if you have any support queries: http://support.vineasx.com

        Cheers,
        Abhi Dwivedi
        " . $this->brand . " Team";
        $this->mail->addAddress($email, ''); // add a recipient
        $this->mail->Subject = $this->brand . ' Account Password Changed';
        $this->mail->Body = $body;
        $this->mail->AltBody = $alt_body;

        $check = $this->mail->send();
         if (!$check) {
           echo $mail->ErrorInfo;
         } else {
            return true;
        }
    }

    public function send_mail($email, $subject, $body)
    {
//         $body = '<table width="100%" cellpadding="0" cellspacing="0" border="0" data-mobile="true" dir="ltr" data-width="600" align="center" style="font-size: 16px; background-color: rgb(255, 255, 255);">
// 	<tbody><tr>
// 		<td align="center" valign="top" style="padding:0;margin:0;"><div class="WRAPPER" style="max-width: 600px; margin: auto;"><table align="center" bgcolor="#ffffff" border="0" cellspacing="0" cellpadding="0" width="600" class="wrapper" style="width: 600px;">
// 				<tbody>
// 				<tr><td align="center" valign="top" style="margin: 0px; padding: 0px;" class="responsive-cell"><table cellpadding="0" cellspacing="0" align="center" data-editable="image" data-mobile-stretch="1" width="100%" style="max-width: 100% !important;"><tbody><tr><td valign="top" align="center" style="display: inline-block; padding: 10px 0px; margin: 0px;" class="tdBlock responsive-cell"><img createnew="true" src="./[IMPORTANT] Your Login Details for StoryReel_files/697898604.png" width="600" data-src="https://m.gr-cdn-3.com/getresponse-Shhp/photos/697898604.png|600|180|600|180|0|0|1" data-origsrc="https://m.gr-cdn-3.com/getresponse-Shhp/photos/692080604.png?_ga=2.69695696.1990658622.1533476252-514448715.1499576570" class="mobile-image-stretch-enabled" style="border-width: 0px; border-style: none; border-color: transparent; font-size: 12px; display: block;"></td></tr></tbody></table></td></tr><tr>
// 					<td align="left" valign="top" style="margin:0;padding:0;" class="responsive-cell">

// 						<table width="100%" border="0" cellpadding="0" cellspacing="0" align="center" data-editable="text" class="text-block">
// 							<tbody><tr>
// 								<td align="left" valign="top" class="lh-2" style="padding: 0px; margin: 0px; font-family: Arial, Helvetica, sans-serif; color: rgb(38, 38, 38); line-height: 1.25; font-size: 16px;"><div style="text-align: center;"><span style="font-weight: bold; background-color: rgb(230, 251, 87);"><br></span></div><div style="text-align: center;"><span style="font-weight: bold; background-color: rgb(230, 251, 87); text-decoration: underline;"><font style="font-size: 22px;" size="22">Congratulations on your purchase of StoryReel</font></span></div><br>You made the right decision and we\'re super excited to have you onboard and help your supercharge your social stories video marketing.<br><br><span style="font-weight: bold; text-decoration: underline;">Here\'s your Access details for StoryReel Dashboard:</span><span style="background-color: transparent;">&nbsp;</span><div><div><br><span style="font-weight: bold;">Members Area:</span> <a href="https://app.storyreel.io/" target="_blank" title="">https://app.StoryReel.io</a><br><span style="font-weight: bold;">Username</span>: ' . $email . '<br><span style="font-weight: bold;">Password</span>: ' . $password . '<br><br><div style="text-align: center;"><span style="background-color: transparent; font-weight: bold;">Please feel free to reach out to our support</span></div><div style="text-align: center;"><span style="background-color: transparent; font-weight: bold;">team if you have any troubles logging in.</span></div><br><div style="text-align: center;"><span style="font-weight: bold;"><a href="http://support.vineasx.com/" target="_blank" title="" style="background-color: transparent;">VineaSX Help Desk</a><span style="background-color: transparent;">&nbsp;or email us at support@vineasx.com</span></span></div><br><span style="font-weight: bold; text-decoration: underline;">[Training] StoryReel BONUS Traininig:</span>&nbsp;</div><div>In this exclusive training webinar <br>you will discover a lot of cool new<br>ways to leverage StoryReel to make<br>money.<br></div><div><br></div><div><a href="https://www.storyreel.io/training" target="_blank" title="">https://www.StoryReel.io/training</a><br><br><span style="font-weight: bold;">Help Desk:</span> support@vineasx.com<br><br>If you need any help, feel free to get in touch.<br><br>We are here 24/7 to help you.<br><br><span style="font-weight: bold;">Please hit the reply button and let us know you\'re in. <br>We\'d love to send you free bonuses as a thank you! :)</span></div><div><br></div></div></td>
// 							</tr>
// 						</tbody></table>
// 					</td>
// 				</tr><tr><td align="center" valign="top" style="margin: 0px; padding: 0px;" class="responsive-cell"><table cellpadding="0" cellspacing="0" align="center" data-editable="image" data-mobile-stretch="1" width="100%" style="max-width: 100% !important;"><tbody><tr><td valign="top" align="center" style="display: inline-block; padding: 10px 0px; margin: 0px;" class="tdBlock responsive-cell"><img src="./[IMPORTANT] Your Login Details for StoryReel_files/697898904.png" width="600" data-src="https://m.gr-cdn-3.com/getresponse-Shhp/photos/697898904.png|600|101|278|94|0|0|1" createnew="true" data-origsrc="https://m.gr-cdn-3.com/getresponse-Shhp/photos/692082904.png?_ga=2.69695696.1990658622.1533476252-514448715.1499576570" class="mobile-image-stretch-enabled" style="border-width: 0px; border-style: none; border-color: transparent; font-size: 12px; display: block;"></td></tr></tbody></table></td></tr><tr><td align="center" valign="top" style="margin: 0px; padding: 0px;" class="responsive-cell"><table width="100%" border="0" cellpadding="0" cellspacing="0" align="center" data-editable="text" class="text-block"><tbody><tr><td align="left" valign="top" class="lh-1" style="padding: 10px; font-size: 16px; font-family: &#39;Times New Roman&#39;, Times, serif; line-height: 1.15;"><span style="font-weight: bold; text-decoration: underline;">Navigation:</span> <a href="https://marketplace.vineasx.com/" target="_blank" title="">VineaSX Marketplace</a> | <a href="https://www.abhineos.com/" target="_blank" title="Abhi Dwivedi">The Blog</a> | <a href="https://www.twitter.com/lazyabhi" target="_blank" title="">Twitter</a> | <a href="http://support.vineasx.com/" target="_blank" title="">Support</a>&nbsp;<br><div>&nbsp;</div><div>&nbsp;</div><div><br></div><div>&nbsp;</div><div>&nbsp;</div></td></tr></tbody></table></td></tr>
// 			</tbody></table></div>


// 		</td>
// 	</tr>
// </tbody><tfoot><tr><td align="center" style="margin: 0px; padding: 0px;"><div class="WRAPPER" style="max-width: 600px; margin: auto;"><table cellspacing="0" cellpadding="0" align="center" border="0" class="wrapper" width="600" style="width: 600px; max-width: 600px;"><tbody><tr><td valign="top" align="center" style="background-color: rgb(255, 255, 255);"><table width="100%" cellpadding="0" cellspacing="0" align="center" border="0">
//     <tbody><tr data-columns="yes" data-table-columns="yes" style="text-align: center;">
//         <td style="text-align: 0; font-size: 0;">
//             <table cellpadding="0" cellspacing="0" border="0" width="100%"><tbody><tr><td align="center" valign="top" width="auto">
//             <div class="column" style="display: inline-block; width: 74%; min-width: 320px !important; max-width: 100%; vertical-align: top;">
//                 <table border="0" align="center" cellpadding="0" cellspacing="0" width="100%">
//                     <tbody><tr>
//                         <td align="left" valign="middle" style="margin: 0; padding:0; padding-left:10px;padding-top:10px">
//                             <span style="font-family: Arial, Helvetica, sans-serif;color: #939598;font-size: 10px;">
//                                 Vega6 Webware Pvt Ltd., C240 Sector 63, 201301, Noida, India
//                             </span>
//                         </td>
//                     </tr>
//                     <tr>
//                         <td align="left" valign="middle" style="margin: 0; padding: 0; padding-left:10px;padding-top:10px">
//                             <span style="font-family: Arial, Helvetica, sans-serif; color: #939598; font-size: 10px;">
//                                 You may <a href="https://app.getresponse.com/unsubscribe.html?x=a62b&amp;m=kJ18Z&amp;mc=Ji&amp;s=E&amp;u=Shhp&amp;y=f&amp;z=EtVaB5p&amp;pt=unsubscribe" style="color: #0985f5; text-decoration: underline;">unsubscribe</a> or <a href="https://app.getresponse.com/change_details.html?x=a62b&amp;m=kJ18Z&amp;s=E&amp;u=Shhp&amp;y=I&amp;z=EEtaywB&amp;pt=change_details" style="color:#0985f5; text-decoration: underline;">change your contact details</a> at any time.
//                             </span>
//                         </td>
//                     </tr>
//                 </tbody></table>
//             </div>
//             </td><td align="center" valign="top" width="155">
//             <div class="column" style="display: inline-block; width: 155px; min-width: 155px !important; max-width: 100%; vertical-align: top;">
//                 <table border="0" align="center" cellpadding="0" cellspacing="0" width="100%">
//                     <tbody><tr>
//                         <td align="right" valign="top" style="margin: 0; padding: 0;padding-right:10px;">
//                             <a href="https://app.getresponse.com/referral.html?x=a62b&amp;c=yxE0Q&amp;u=Shhp&amp;y=q&amp;z=E9AsSX3&amp;">

//                             </a>
//                         </td>
//                     </tr>
//                 </tbody></table>
//             </div>
//             </td></tr></tbody></table>
//         </td>
//     </tr>
// </tbody></table></td></tr></tbody></table></div></td></tr></tfoot></table>';
        $this->mail->addAddress($email, '');
        $this->mail->Subject = $this->brand .' '. $subject;
        $this->mail->Body = $body;
        $check = $this->mail->send();

        if (!$check) {
            //echo $mail->ErrorInfo;
            return false;
        } else {
            return true;
        }
    }

    public function sub_accounts($email, $password, $type)
    {
        $body = "
		Hey,<br /><br />

		You had been invited to use the $type account of " . $this->brandUrl . ";

		THESE ARE YOUR " . strtoupper($this->brand) . " ACCESS INSTRUCTIONS <br />
		Your User ID: $email <br />
		Your Password: $password <br />
		Login at: <a href='" . $this->brandUrl . "'>" . $this->brandUrl . "</a><br /><br />


		Use these access details to log in to the <a href='" . $this->brandUrl . "'>" . $this->brand . "</a> dashboard. Once you login to the dashboard, you will get access to the training and more inside.

		<br /><br />

		Please go through this two important training video to get started with " . $this->brand . " <br /><br />
		" . $this->brand . " Explainer Video: <a href='https://youtu.be/1Dhwr9ZBUJ'>https://youtu.be/1Dhwr9ZBUJ</a> <br />
		" . $this->brand . " Facebook Explainer Video: <a href='https://youtu.be/jNG3c3qzacs'>https://youtu.be/jNG3c3qzacs</a>
		<br /><br />
		Reach out to us if you have any support queries: <a href='http://support.vega6.com'>http://support.vega6.com</a> <br />
		<br /><br />
		Cheers,<br />
		Abhi Dwivedi<br />
		" . $this->brand . " Team
		";

        $alt_body = "Hey,

		Thank-you for your smart decision to invest in <a href='" . $this->brandUrl . "'>" . $this->brand . " $type</a>. We are so pumped to have you onboard as our VIP customer.

		THESE ARE YOUR " . strtoupper($this->brand) . " ACCESS INSTRUCTIONS
		Your User ID: $email
		Your Password: $password
		Login at: " . $this->brandUrl . "


		Use these access details to log in to the " . $this->brand . " dashboard. Once you login to the dashboard, you will get access to the training and more inside.


		Reach out to us if you have any support queries: http://support.vineasx.com

		Cheers,
		Abhi Dwivedi
		" . $this->brand . " Team";

        $this->mail->addAddress($email, '');
        $this->mail->Subject = $this->brand . ' Access Information';
        $this->mail->Body = $body;
        $this->mail->AltBody = $alt_body;

        $check = $this->mail->send();

        // $mailingAr['to'] = $email;
        // $mailingAr['subject'] = $this->brand.' Password Reset';
        // $mailingAr['html'] = $body;
        // $check = $mg->sendMessage($domain, $mailingAr);

        if (!$check) {
            //echo $mail->ErrorInfo;
            return false;
        } else {
            return true;
        }
    }

    public function upgrademail($email, $type)
    {
        $body = "
				Hey,<br /><br />

		We have Upgraded your " . $this->brand . " account to " . $this->brand . " $type.<br />
		You now have access to tons of new cutting edge features that you can access from inside your " . $this->brand . " dashboard.
		<br /><br />
		Please logout and login again to your " . $this->brand . " account here: <a href='" . $this->brandUrl . "'>" . $this->brandUrl . "</a>
		<br />

		Thank-you for your smart decision to invest in " . $this->brand . ". We are so pumped to have you onboard as our VIP customer.
		<br />
		If you face any issues accessing your purchase or account, please reach out to us at http://support.vega6.com
		<br /><br />

		Cheers,<br />
		Abhi Dwivedi<br />
		" . $this->brand . " Team

		";

        $alt_body = "		Hey,

		We have Upgraded your " . $this->brand . " account to " . $this->brand . " $type.
		You now have access to tons of new cutting edge features that you can access from inside your " . $this->brand . " dashboard.

		Please logout and login again to your " . $this->brand . " account here: <a href='" . $this->brandUrl . "'>" . $this->brandUrl . "</a>

		Thank-you for your smart decision to invest in " . $this->brand . ". We are so pumped to have you onboard as our VIP customer.

		If you face any issues accessing your purchase or account, please reach out to us at http://support.vineasx.com


		Cheers,
		Abhi Dwivedi
		" . $this->brand . " Team";

        $this->mail->addAddress($email, ''); // add a recipient

        $this->mail->Subject = $this->brand . ' UPGRADED';
        $this->mail->Body = $body;
        $this->mail->AltBody = $alt_body;

        $check = $this->mail->send();

        // $mailingAr['to'] = $email;
        // $mailingAr['subject'] = $this->brand.' Password Reset';
        // $mailingAr['html'] = $body;
        // $check = $mg->sendMessage($domain, $mailingAr);

        if (!$check) {
            //echo $mail->ErrorInfo;
            return false;
        } else {
            return true;
        }
    }

}