<?php
use Firebase\JWT\JWT;
use Firebase\JWT\Key;

class Jwt_verify
{
    /**
     * @var CI_Controller
     */
    private $CI;

    public function __construct()
    {
        $this->CI = &get_instance();
    }

    public function verify_token_2()
    {
        if ($this->CI->input->request_headers()) {
            $headers = $this->CI->input->request_headers();
            if (isset($headers['Authorization']) && $headers['Authorization'] != '') {
                $token = $headers['Authorization'];
            } else {
                die('Token not found');
            }

            if ($token) {
                // $actual_token = sscanf($token, 'Bearer %s');
                if (is_array($headers) && !empty($token)) {
                    try {
                        // Search DB with that token
                        $check_actual_token = $this->CI->DatabaseModel->fetchTableData('tokens', array('token' => $token, 'deleted' => 0));
                        if ($check_actual_token == false || (is_array($check_actual_token) && count($check_actual_token) > 1)) {
                            $return['status'] = false;
                            $return['message'] = 'Unauthorized Token';
                        } else {
                            JWT::decode($token, new Key($check_actual_token[0]->secret_key, 'HS512'));
                            // JWT::decode($token, $check_actual_token[0]->secret_key, array('HS512'));
                            $fetch_user_details = $this->CI->DatabaseModel->fetchTableData('users', array('id' => $check_actual_token[0]->user_id));

                            $virtual_account = false;
                            if ($fetch_user_details[0]->is_team) {
                                $virtual_account = $fetch_user_details;
                                $fetch_user_details = $this->CI->DatabaseModel->fetchTableData('users', array('id' => $fetch_user_details[0]->parent));

                            }

                            if ($fetch_user_details != false) {

                                $user_details = array(
                                    'user_id' => $fetch_user_details[0]->id,
                                    'status' => $fetch_user_details[0]->status,

                                );

                                if ($fetch_user_details[0]->is_client_account) {
                                    $user_details['is_client'] = true;
                                }
                                if ($virtual_account) {
                                    unset($virtual_account[0]->created);
                                    $user_details['virtual'] = $virtual_account[0];
                                    $user_details['is_team'] = true;
                                }

                                $return['status'] = true;
                                $return['token'] = $token;
                                $return['data'] = $user_details;
                            } else {
                                $return['status'] = false;
                                $return['message'] = 'Invalid user token';
                            }
                        }
                    } catch (Exception $e) {
                        $return['status'] = false;
                        $return['message'] = $e->getMessage();
                    }
                } else {
                    $return['status'] = false;
                    $return['message'] = 'Incorrect Token';
                }
            } else {
                $return['status'] = false;
                $return['message'] = 'No Token';
            }
        } else {
            $return['status'] = false;
            $return['message'] = 'Method not allowed';
        }
        return $return;
    }
}