<?php
use \Firebase\JWT\JWT;

class Jwt_client
{
    /**
     * @var CI_Controller
     */
    private $CI;
    private $user_id;

    public function __construct()
    {
        $this->CI = &get_instance();
    }
    private function random_key()
    {
        return base64_encode(openssl_random_pseudo_bytes(64));
    }
    public function create_token($user_id, $email, $ip)
    {
        $secret_key = $this->random_key();
        $insert['user_id'] = $user_id;
        $insert['token'] = $this->generate_token($email, $secret_key, $user_id);
        $insert['ip'] = $ip;
        $insert['location'] = '';
        $insert['secret_key'] = $secret_key;
        $insert['created'] = date('Y-m-d H:i:s');
        $insert['modified'] = date('Y-m-d H:i:s');
        $check_insert = $this->CI->DatabaseModel->insertData('tokens', $insert);
        if ($check_insert) {
            $data['token_type'] = 'Authorization';
            $data['token'] = $insert['token'];
        } else {
            $data['status'] = false;
            $data['message'] = 'Oops, Something went wrong. Please try again. Error: C001';
        }
        return $data;
    }

    private function generate_token($email, $secret_key, $user_id)
    {
        $payload = array(
            'iat' => time(),
            'jti' => $this->CI->adi->randomPassword(),
            'iss' => base_url(),
            'nbf' => time(),
            'data' => array(
                'user_id' => $user_id,
                'user_email' => $email,
            ),
        );
        return JWT::encode(
            $payload, //Data to be encoded in the JWT
            $secret_key, // The signing key
            'HS512' // Algorithm used to sign the token,
        );
    }
}