<?php

// use Google\Cloud\Translate\TranslateClient;

use Google\Cloud\Translate\V2\TranslateClient;

/**
 * Created by PhpStorm.
 * User: javed
 * Date: 11/10/18
 * Time: 1:50 PM
 */

class GoogleTranslate
{
    private $google;

    /**
     * This makes object to connect google
     * @param $file_name
     */
    public function connect($file_name, $project_id)
    {
        $path = 'assets/google_credentials/' . $file_name;
        $env = 'GOOGLE_APPLICATION_CREDENTIALS=' . $path;
        putenv($env);

        $this->google = new TranslateClient(array(
            'projectId' => $project_id,
        ));

    }

    /**
     * This function takes two arguments and return array of translated language.
     * @param $target_language , language in which you want to translate your test
     * @param $text , input text which you want to translate
     * @return mixed, return array of translated text
     * @throws Exception
     */
    public function getTranslation($target_language, $text)
    {

        try {

            $result = $this->google->translate($text, array(
                'target' => $target_language,
                'format' => 'text',
            ));
            return $result;
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }

    }
}