<?php
/**
 * Created by PhpStorm.
 * User: aditya
 * Date: 8/21/2019
 * Time: 4:02 PM
 * @property CI_Controller CI
 */

class Gdpr
{
    private $user_id;

    function __construct() {
        $this->CI =& get_instance();
        if(isset($this->CI->session->userdata['user_details']['user_id']))
            $this->user_id = $this->CI->session->userdata['user_details']['user_id'];

    }

    public function change_email()
    {
        $newEmail = $this->CI->input->post('newEmail');
        $fetch_user_details = $this->CI->DatabaseModel->fetchtabledataone('users','id',$this->user_id);
        if($fetch_user_details !== 0)
        {
            // Store the New Email
            $insert['userid'] = $this->user_id;
            $insert['oldEmail'] = $fetch_user_details[0]->email;
            $insert['newEmail'] = $newEmail;
            $insert['created'] = date('Y-m-d H:i:s');
            $insert['modified'] = date('Y-m-d H:i:s');

            $save_email_reference = $this->CI->DatabaseModel->insertData('change_email',$insert);
            if($save_email_reference != 0)
            {
                // Update the users table with the new Email
                $update['email'] = $newEmail;
                $update['modified'] = date('Y-m-d H:i:s');

                $check_update = $this->CI->DatabaseModel->updatetable('users',$update,array('id'=>$this->user_id));
                if($check_update === $this->user_id)
                {
                    $return['status'] = true;
                    $return['message'] = 'New Email Address Has Been Updated';
                }
                else
                {
                    $return['status'] = false;
                    $return['message'] = 'Not able to update the new Email Address.';
                }
            }
            else
            {
                $return['status'] = false;
                $return['message'] = 'Something went wrong. Please try again';
            }
        }
        else
        {
            $return['status'] = false;
            $return['message'] = 'User is not logged in';
        }

        // Echoing directly back to the browser instead of returning to the Controller
        echo json_encode($return);die();
    }

    public function stopProcessingData()
    {
        $isStopProcessingData = $this->CI->input->post('stopProcessingData');
        if($isStopProcessingData === 'yes')
        {
            // Add the user into the gdpr table
            $insert['userid'] = $this->user_id;
            $insert['stopProcessingData'] = true;

            $check_insert = $this->CI->DatabaseModel->insertData('gdpr',$insert);
            if($check_insert != 0)
            {
                // Update the user status to 0 from the users table so that the user cannot use the Application and also forcefully logout the user
                $update['status'] = 0;
                $update['modified'] = date('Y-m-d H:i:s');
                
                $clients = $this->CI->DatabaseModel->fetchtabledataone('client_account','userid',$this->user_id);
                
                if($clients != 0)
                {
                    foreach($clients as $client) 
                    {
                      $this->CI->DatabaseModel->updatetable('client_account',$update,array('id'=>$client->id));
                    }
                }
                
                
                $team_members = $this->CI->DatabaseModel->fetchtabledataone('virtual_account','userid',$this->user_id);
                
                if($team_members != 0)
                {
                   foreach($team_members as $team_member) 
                   {
                      $this->CI->DatabaseModel->updatetable('virtual_account',$update,array('id'=>$team_member->id));
                   }
                }
                
                $update_user['status'] = 0;
                $update_user['modified'] = date('Y-m-d H:i:s');
                $update_user['reason'] = '';
                $update_user['deactivate_by'] = $this->user_id;

                $check_update = $this->CI->DatabaseModel->updatetable('users',$update_user,array('id'=>$this->user_id));
                if($check_update === $this->user_id)
                {
                    $return['status'] = true;
                    $return['message'] = 'Processing of your Data has been stopped. If you want to restart your data processing please contact customer support';
                }
                else
                {
                    $return['status'] = false;
                    $return['message'] = 'Something went wrong. Not able to Stop your data from Processing. Please contact support Desk';
                }
            }
            else
            {
                $return['status'] = false;
                $return['message'] = 'Not able to create an instance of your request';
            }
        }
        else
        {
            $return['status'] = false;
            $return['message'] = 'You are asking to processing your default, which is ON by default';
        }
        // Echoing directly back to the browser instead of returning to the Controller
        echo json_encode($return);die();
    }

    public function download_my_data()
    {
        $isDownloadData = $this->CI->input->post('isDownloadData');
        if($isDownloadData === 'yes')
        {
            $insert['userid'] = $this->user_id;
            $insert['downloadData'] = 1;

            $check_insert = $this->CI->DatabaseModel->insertData('gdpr',$insert);
            if($check_insert != 0)
            {
                if (!file_exists('uploads/downloads/'.$this->user_id.'/')) {
                    mkdir('uploads/downloads/'.$this->user_id.'/', 0777, true);
                }

                // Start Fetching data from the Users Table
                $user_data = 'Personal Data \n';
                $user_details = $this->CI->DatabaseModel->fetchtabledataone('users','id',$this->user_id);
                if($user_details != 0)
                    $user_data .= 'Name: '.$user_details[0]->name . '\n Email: '.$user_details[0]->email . '\n Last Login: '.$user_details[0]->last_login. ' \n Created: '.$user_details[0]->created.'\n Last Modified: '.$user_details[0]->modified . '\n';

                // Fetch Data from the Auto responder data
                $user_data .='\n\n\n\n\n Autoresponders Data \n';
                $ar_data = $this->CI->DatabaseModel->fetchtabledataone('auto_responders','userid',$this->user_id);
                if($ar_data != 0)
                {
                    foreach ($ar_data as $key => $ar)
                    {
                        $user_data .= 'Name: '.$ar->auto_responder_name.'\n List ID: '.$ar->list_id.' \n List Name: '.$ar->list_name.' \n Created: '.$ar->created.' \n Last Modified: '.$ar->modified . '\n';
                    }
                }

                // Fetch Client Account Data
                $user_data .= '\n\n\n\n\n Client Account Data \n';
                $client_data = $this->CI->DatabaseModel->fetchtabledataone('client_account','userid',$this->user_id);
                if($client_data != 0)
                {
                    foreach ($client_data as $key => $client)
                    {
                        $user_data .= 'Client Name: '.$client->name.' \n Client Email: '.$client->email.' \n Created: '.$client->created.' \n Last Modified: '.$client->modified.' \n';
                    }
                }

                // Fetch Virtual Account Data
                $user_data .= '\n\n\n\n\n Virtual Account Data \n';
                $virtual_data = $this->CI->DatabaseModel->fetchtabledataone('virtual_account','userid',$this->user_id);
                if($virtual_data != 0)
                {
                    foreach ($virtual_data as $key => $virtual)
                    {
                        $user_data .= 'Virtual Name: '.$virtual->name.' \n Virtual Email: '.$virtual->email.' \n Created: '.$virtual->created.' \n Last Modified: '.$virtual->modified .'\n';
                    }
                }

                // Write Every Data to a Txt File
                file_put_contents('uploads/downloads/'.$this->user_id.'/records.txt', $user_data);


                //Copy Logo to the Logo folder to download
                if (!file_exists('uploads/downloads/'.$this->user_id.'/logo')) {
                    mkdir('uploads/downloads/'.$this->user_id.'/logo', 0777, true);
                }
                $this->CI->adi->recurse_copy('files/'.$this->user_id.'/logo', 'uploads/downloads/'.$this->user_id.'/logo');

                // Copy the thumbnail to the thumbnail folder to download
                if (!file_exists('uploads/downloads/'.$this->user_id.'/thumbnail')) {
                    mkdir('uploads/downloads/'.$this->user_id.'/thumbnail', 0777, true);
                }
                $this->CI->adi->recurse_copy('files/'.$this->user_id.'/thumbnails', 'uploads/downloads/'.$this->user_id.'/thumbnail');


                // Zip compress the $this->user_id folder, so that it can be downloaded
                unlink('uploads/downloads/'.$this->user_id.'/user_data_playerNeos.zip');
                $check = $this->CI->adi->zip_the_file('uploads/downloads/'.$this->user_id.'/','uploads/downloads/'.$this->user_id.'/user_data_playerNeos.zip');
                if($check == true)
                {
                    $return['status'] = true;
                    $return['message'] = 'All the data has been lined up. Please download the data';
                    $return['url'] = base_url().'uploads/downloads/'.$this->user_id.'/user_data_playerNeos.zip';
                }
                else
                {
                    $return['status'] = false;
                    $return['message'] = 'Not able to lined up & Compress your data';
                }
            }
            else
            {
                $return['status'] = false;
                $return['message'] = 'You are asking to processing your default, which is ON by default';
            }
        }
        else
        {
            $return['status'] = false;
            $return['message'] = 'You are asking to processing your default, which is ON by default';
        }
        echo json_encode($return);die();
    }

    public function delete_my_data()
    {
        $isDeleteData = $this->CI->input->post('isDeleteData');
        if($isDeleteData === 'yes')
        {
            $insert['userid'] = $this->user_id;
            $insert['deleteAccount'] = $isDeleteData;

            $check_insert = $this->CI->DatabaseModel->insertData('gdpr',$insert);
            if($check_insert != 0)
            {
                // Delete All the logo and thumbnail uploaded by the user
                if(is_dir('files/'.$this->user_id.'/'))
                    $this->CI->adi->deleteDir('files/'.$this->user_id.'/');

                // Delete the Table Records
                $del_array = array('userid' => $this->user_id);
                $this->CI->DatabaseModel->deleterows('auto_responders',$del_array);
                $this->CI->DatabaseModel->deleterows('client_account',$del_array);
                $this->CI->DatabaseModel->deleterows('notification',$del_array);
                $this->CI->DatabaseModel->deleterows('player_details',$del_array);
                $this->CI->DatabaseModel->deleterows('virtual_account',$del_array);

                // Delete the user
                $del_user_array = array('id' => $this->user_id);
                $this->CI->DatabaseModel->deleterows('users',$del_user_array);

                $return['status'] = true;
                $return['message'] = 'Account Deleted';
                $return['logout'] = 'logout';
            }
            else
            {
                $return['status'] = false;
                $return['message'] = 'Not able to create an instance of your delete request';
            }
        }
        else
        {
            $return['status'] = false;
            $return['message'] = 'You are asking NOT to Delete your default, which is there by default';
        }
        echo json_encode($return);die();
    }

}