<?php

use Facebook\Exceptions\FacebookSDKException;
use Facebook\Facebook;

/**
 * Class FacebookUpload
 * uploads files to facebook social network
 */
class FacebookUpload
{
    private $access_token = '';
    private $fb_app_id;
    private $fb_secret_key;
    private $type;
    private $user_key;

    /**
     * FacebookUpload constructor.
     * @param $access_token : initializes user's access token
     * @param $type
     * @param $user_key
     */

    public function connect($access_token, $type, $user_key)
    {
        $this->access_token = $access_token;
        $this->fb_app_id = FACEBOOK_APP_ID;
        $this->fb_secret_key = FACEBOOK_APP_SECRET;
        $this->type = $type;
        $this->user_key = $user_key;
    }

    public function upload($file, $title, $description)
    {

        $video_file = $file;

//        print $video_file;

        /**
         * if video file does not exists, return
         */
        if (!file_exists($video_file)) {
            print_r('Video file does not exists.');
            $response['status'] = false;
            $response['message'] = 'Video File does not exists';

            return $response;
        }

        if (!is_file($video_file)) {

            $response['status'] = false;
            $response['message'] = 'Video file does not exists.';

            return $response;
        }

//        print 'File Exists';

        $fb = new Facebook(array(
            'app_id' => $this->fb_app_id,
            'app_secret' => $this->fb_secret_key,
            'default_graph_version' => 'v2.2',
        ));

//        print_r($fb);

        $data = array(
            'title' => $title,
            'description' => $description,
            'source' => $fb->videoToUpload($video_file),
        );

//        print_r($data);

        if ($this->type === 'group') {

            $fburl = 'https://graph.facebook.com/' . $this->user_key . '/videos';

            $attachment = array(
                'access_token' => $this->access_token,
                'title' => $title,
                'description' => $description,
                'file_url' => urlencode(site_url() . $file),
            );

            $result = $this->curl_post_request($fburl, $attachment);
            dd($result);

            if ($result->id) {

                $response['status'] = true;
                $response['response'] = json_encode($result);
                $response['video_id'] = $result->id;
                return $response;
            } else {
                $response['status'] = false;
                $response['message'] = 'Error uploading file : ' . urlencode(site_url() . $file);
                $response['data'] = json_encode($data);
                return $response;
            }

            /*
         * upload to facebook group
         *
        try {
        // Returns a 'Facebook\FacebookResponse' Object
        $result = $fb->post(
        '/'.$this->user_key.'/videos',
        [
        'source' => WWW_ROOT . '../' . $path . $file,
        ],
        $this->access_token
        );
        } catch (FacebookResponseException $e) {
        $response['status'] = false;
        $response['message'] = 'Graph returned an error: ' . $e->getMessage();
        $response['data'] = json_encode($data);
        return $response;
        } catch (FacebookSDKException $e) {
        $response['status'] = false;
        $response['message'] = 'Facebook SDK returned an error: ' . $e->getMessage();
        $response['data'] = json_encode($data);
        return $response;
        }

        $response['status'] = true;
        $response['response'] = json_encode($result);
        $response['graph_node'] = $result->getGraphNode();
        $response['video_id'] = $result->getGraphNode(['id']);
        $response['data'] = $data;
        return $response;
         */
        } elseif ($this->type === 'personal') {

            $fburl = 'https://graph.facebook.com/' . $this->user_key . '/videos';

            $attachment = array(
                'access_token' => $this->access_token,
                'title' => $title,
                'description' => $description,
                'file_url' => urlencode(site_url() . $file),
            );
            $result = $this->curl_post_request($fburl, $attachment);

            if ($result->id) {

                $response['status'] = true;
                $response['response'] = json_encode($result);
                $response['video_id'] = $result->id;
                return $response;
            } else {
                $response['status'] = false;
                $response['message'] = 'Error uploading file : ' . urlencode(site_url() . $file);
                $response['data'] = json_encode($data);
                return $response;
            }

            /*
         * post to personal profile
         *
        try {
        // Returns a `Facebook\FacebookResponse` object
        $result = $fb->post(
        '/me'.'/videos',
        [
        'file_url' => 'http://app.syvid.io/webroot/files/PostVideos/video_file/1510315688.5385/WhatsApp%20Video%202017-11-08%20at%2010.55.17%20AM.mp4',
        ],
        $this->access_token
        );
        } catch(FacebookResponseException $e) {
        $response['status'] = false;
        $response['message'] = urlencode('https://app.syvid.io/' . $path . $file) . ': '.'Graph returned an error ('.$e->getErrorType().'): ' . $e->getMessage();
        $response['data'] = json_encode($data);
        return $response;
        } catch (FacebookSDKException $e) {
        $response['status'] = false;
        $response['message'] = urlencode('https://app.syvid.io/' . $path . $file) . ':  '.'Facebook SDK returned an error ('.$e->getErrorType().'): ' . $e->getMessage();
        $response['data'] = json_encode($data);
        return $response;

        }
         */

        } else {

//            print 'Upload to page';
            /**
             * upload to page
             */
            try {
//                print '||| Try block';
//                print_r($data);
//                print_r($this->access_token);

                $result = $fb->post('/me/videos', $data, $this->access_token);

//                print_r($result);
//                print '||| Try success';
            } catch (FacebookSDKException $e) {
//                print '|||| Catch 2 block';
                $response['status'] = false;
                $response['message'] = 'Facebook SDK returned an error: ' . $e->getMessage();
                $response['data'] = $data;
//                print_r($response);
                return $response;
            } catch (\Exception$e) {
                $response['status'] = false;
                $response['message'] = $e->getMessage();
                return $response;
            }
//               catch (FacebookResponseException $e) {
//                print '|||| Catch Block';
//                $response['status'] = false;
//                $response['message'] = 'Graph Returned an error: ' . $e->getMessage();
//                $response['data'] = $data;
//                print_r($response);
//                return $response;
//            }
//
//            print 'Helllllllllo';
//            print_r($result);

            $response['status'] = true;
            $response['response'] = json_encode($result);
            $response['graph_node'] = $result->getGraphNode();
            $response['video_id'] = $result->getGraphNode()['id'];
            $response['data'] = $data;
            return $response;
        }

    }

    public function curl_post_request($url, $fields)
    {
        $post = '';
        foreach ($fields as $key => $value) {$post .= $key . '=' . $value . '&';}
        $post = rtrim($post, '&');

        $curl = curl_init();
        curl_setopt($curl, CURLOPT_URL, $url);
        curl_setopt($curl, CURLOPT_POST, count($fields));
        curl_setopt($curl, CURLOPT_POSTFIELDS, $post);
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
        $result = curl_exec($curl);
        curl_close($curl);

        $response = json_decode($result);
        return $response;
    }

}