<?php
use Aws\TranscribeService\TranscribeServiceClient;

class Amazon_transcribe
{

    /**
     * @var string
     */
    private $key;
    /**
     * @var string
     */
    private $secret;
    private $region;

    public function __construct()
    {
        $this->key = 'AKIA5PZOW6OUCL7YZLOS'; //AKIA5PZOW6OUA4RJNRF3
        $this->secret = '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'; //K7b1eiUKNsYVj7stTvtssHgKR0vG4VTvrY5cX+Yq
        $this->region = 'us-east-1'; //us-west-2
        $this->CI = &get_instance();

    }

    /**
     * @param $s3_uri , s3 url of your file
     * @param $job_name , unique string to start your job i.e transcribe job name
     * @param $language_code
     * @param $ext
     * @param null $credentials
     * @return mixed
     * @throws Exception
     */
    public function startTranscriptionJob($s3_uri, $job_name, $language_code, $ext, $credentials = null)
    {
        if ($credentials != null && isset($credentials['access_key'])) {
            $this->region = $credentials['region'];
            $this->key = $credentials['access_key'];
            $this->secret = $credentials['secret_key'];
        }
        try {

            $client = new TranscribeServiceClient(array(
                'version' => 'latest',
                'region' => $this->region,
                'credentials' => array(
                    'key' => $this->key,
                    'secret' => $this->secret,
                ),
            ));
            return $client->startTranscriptionJob(array(
                'LanguageCode' => $language_code, // REQUIRED
                'Media' => array(
                    'MediaFileUri' => $s3_uri,
                ),
                'MediaFormat' => $ext, // REQUIRED
                'TranscriptionJobName' => $job_name, // REQUIRED
            ));
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }

    /**
     * This function is used to get status of your transcribe job
     * @param $job_name , job name to identify your job.
     * @param null $credentials
     * @return mixed
     * @throws Exception
     */
    public function getTranscriptionJob($job_name, $credentials = null)
    {
        if ($credentials != null && isset($credentials['access_key'])) {
            $this->region = $credentials['region'];
            $this->key = $credentials['access_key'];
            $this->secret = $credentials['secret_key'];
            // echo "hello welcome";
            // die();
        }
        try {
            $client = new TranscribeServiceClient(array(
                'version' => 'latest',
                'region' => $this->region,
                'credentials' => array(
                    'key' => $this->key,
                    'secret' => $this->secret,
                ),
            ));
            return $client->getTranscriptionJob(array(
                'TranscriptionJobName' => $job_name,
            ));
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }

    public function getTranscribeLanguages()
    {
        $languages = $this->CI->DatabaseModel->fetchTableData('transcribe_languages');
        if (!empty($languages)) {
            $response = array(
                'status' => true,
                'data' => array('languages' => $languages),
            );
        } else {
            $response = array(
                'status' => false,
                'message' => 'No language found',
            );
        }

        echo json_encode($response);
        die;
    }
}