<?php
use Aws\TranscribeService\TranscribeServiceClient;
use TBETool\AwsPolly;
use TBETool\S3Service;

class Amazon_manager
{
    private $client_id = AWS_ACCESS_KEY;
    private $client_secret = AWS_SECRET;
    private $bucket = S3_BUCKET;
    private $region = AWS_REGION;

    private $client;
    private $polly;

    /**
     * This function make an object of to connect to amazon transcribe service
     * @param $region , region
     * @param $access_key , access key
     * @param $secret_key , secret key
     * @throws Exception
     */
    public function __construct()
    {

        $this->client = new TranscribeServiceClient(array(
            'version' => 'latest',
            'region' => AWS_REGION,
            'credentials' => array(
                'key' => AWS_ACCESS_KEY,
                'secret' => AWS_SECRET,
            ),
        ));

        $this->polly = new AwsPolly(AWS_ACCESS_KEY, AWS_SECRET, AWS_REGION);

    }

    /**
     * @param $s3_uri , s3 url of your file
     * @param $job_name , unique string to start your job i.e transcribe job name
     * @param $language_code
     * @param $ext
     * @return mixed
     * @throws Exception
     */
    public function startTranscriptionJob($s3_uri, $job_name, $language_code, $ext)
    {
        try {
            $ar = array(
                'LanguageCode' => $language_code, // REQUIRED
                'Media' => array(
                    'MediaFileUri' => $s3_uri,
                ),
                'MediaFormat' => $ext, // REQUIRED
                'TranscriptionJobName' => $job_name, // REQUIRED
            );
            //print_r($ar);die('asd');
            return $this->client->startTranscriptionJob($ar);
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }

    /**
     * This function is used to get status of your transcribe job
     * @param $job_name , job name to identify your job.
     * @return mixed
     * @throws Exception
     */
    public function getTranscriptionJob($job_name)
    {
        try {
            $result = $this->client->getTranscriptionJob(array(
                'TranscriptionJobName' => $job_name,
            ));
            return $result;
        } catch (Exception $e) {
            return 'Error executing';
            //throw new Exception($e->getMessage());
        }
    }

    /**
     * This function upload a file to amazon s3 bucket, if credentials are valid
     * it will return url of uploaded file else throw exception
     * @param $path , absolute path of your file
     * @param string $client_id
     * @param string $client_secret
     * @param string $bucket
     * @param string $region
     * @return string
     * @throws Exception
     */
    public function s3Upload($path, $file_name, $bucket = S3_BUCKET)
    {
        //$file_extension = $this->_getFileExtension($path);
        $s3Service = new S3Service(AWS_ACCESS_KEY, AWS_SECRET, $bucket);
        $s3Service->setS3Region(AWS_REGION);
        $s3Service->setS3Version('latest');
        $s3Service->setS3HttpVerify(false);
        try {
            $local_file = $path;
            return $s3Service->moveToS3($local_file, $file_name, array('public-read'));
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }

    }

    public function polly($language, $voice_id, $text)
    {
        $path = FCPATH . 'assets/amazon/polly/';

        $this->polly->setOutputPath($path);

        $file = $this->polly->textToVoice(
            $text,
            array('language' => $language,
                'voice' => $voice_id)
        );

        return str_replace(FCPATH, '', $file);
    }

    /**
     * Return extension of the file
     * @param $path
     * @return mixed
     */
    private function _getFileExtension($path)
    {
        $explode = explode('.', $path);
        $ext = end($explode);
        return $ext;
    }
}