<?php

/**
 * @property false $userId
 * @property CI_Controller $CI
 * @property false $campaignId
 * @property false $videoSetId
 * @property false $keyword
 * @property false $templateId
 * @property false $dimension
 */
class Ai
{

    public function __construct()
    {
        $this->CI = &get_instance();
        $this->userId = false;
        $this->campaignId = false;
        $this->videoSetId = false;
        $this->keyword = false;
        $this->templateId = false;
        $this->dimension = false;
    }

    private function fetchTopic()
    {
        $topics_array = $this->CI->DatabaseModel->fetchTableData('topics_get', array('status' => 1));
        if (is_array($topics_array)) {
            $randomIndex = rand(0, count($topics_array) - 1);
            return $topics_array[$randomIndex]->text;
        } else {
            return false;
        }

    }

    private function fetchScript()
    {
        $script_array = $this->CI->DatabaseModel->fetchTableData('script_get', array('status' => 1));
        if (is_array($script_array)) {
            $randomIndex = rand(0, count($script_array) - 1);
            return $script_array[$randomIndex]->text;
        } else {
            return false;
        }

    }

    private function callApi($query,$userId,$type){
        return $this->CI->openai->searchAi(trim($query),$userId,$type);
    }
    private function callApiKeyword($query){
        return $this->CI->openai->keyword(trim($query));
    }



    private function logoWatermarkGeneration($type)
    {
        $result = array(
            'enable' => false,
            'type' => $type,
            'src' => '',
            'positionX' => "",
            'positionY' => "",
            'width' => "",
            'height' => "",
        );
        return json_encode($result);
    }

    private function introOutroGeneration($type)
    {
        $result = array(
            'enable' => false,
            'type' => $type,
            'src' => '',
            'width' => "",
            'height' => "",
            'duration' => 0,
            'isAudio' => false
        );
        return json_encode($result);
    }

    private function backgroundAudioGeneration($type)
    {
        $result = array(
            'enable' => false,
            'type' => $type,
            'src' => "",
            'duration' => 0,
            'isLoop' => false,
            'volume' => 50
        );
        return json_encode($result);
    }

    private function audioGeneration($type)
    {
        $result = array(
            'enable' => false,
            'type' => $type,
            'src' => "",
            'duration' => 0,
            'isLoop' => false,
            'volume' => 100,
            'meta' => array(
                'text' => '',
                'languageId' => 0,
                'voiceId' => 0,
                'translateText' => '',
                'duration' => 0,
            ),
        );
        return json_encode($result);
    }

    private function randomAssignTemplate()
    {
        $allTemplates = $this->CI->DatabaseModel->fetchTableData('templates', array('status' => 1,'id' => 4));
        if($allTemplates && is_array($allTemplates)){
            //return $allTemplates[rand(0,count($allTemplates)-1)]->id;
            return $allTemplates[0]->id;
        }
        else{
            return false;
        }
    }

    public function randomAssignTransition()
    {
        $allTransitions = $this->CI->DatabaseModel->fetchTableData('transition', array('status' => 1));
        if($allTransitions && is_array($allTransitions)){
            //return $allTemplates[rand(0,count($allTemplates)-1)]->id;
            return $allTransitions[0]->name;
        }
        else{
            return false;
        }
    }

    private function randomAssignVariation($templateId,$dimension=false)
    {
        if(!$dimension){
            $dimension = $this->dimension;
        }
        $allTemplateVariation = $this->CI->DatabaseModel->fetchTableData('variation', array('templateId' => $templateId,'status' => 1,'dimension' => $dimension));
        if($allTemplateVariation && is_array($allTemplateVariation)){
            return $allTemplateVariation[rand(0,count($allTemplateVariation)-1)];
        }
        else{
            return false;
        }
    }

    private function fetchMedia($keyword)
    {
        $res = $this->CI->media->searchVideo($keyword);
        if ($res['status']) {
            $random_key = array_rand($res['message']);
            $random_video = $res['message'][$random_key];
            //unset($random_video['name']);
            $random_videos['type'] = 'video';
            $random_videos['src'] = $random_video->url;
            $random_videos['thumbnail'] = $random_video->thumbnail;
            //unset($random_video['image']);
            return $random_videos;
        }

        //$keyword = $this->randomKeyword();
        $res = $this->CI->media->searchImages($keyword);
        if ($res['status']) {
            $random_key = array_rand($res['message']);
            $random_image = $res['message'][$random_key];
            //unset($random_image->name);
            $random_images['type'] = 'image';
            $random_images['src'] = $random_image->url;
            $random_images['thumbnail'] = $random_image->thumbnail;
            //unset($random_image->image);

            return $random_images;
        }

        return array(
            'url' => '#a72f2f',
            'thumbnail' => '#a72f2f',
            'type' => 'color',
        );

    }


    private function createSlide($transition,$videoId,$script, $keyword, $isSelected)
    {
        $videoDetails = $this->CI->DatabaseModel->fetchTableData('videos', array('id' => $videoId));
        if(!empty($videoDetails))
        {
            $returnResponse = array('status' => false);
            $media = $this->fetchMedia($keyword[0]);
            $templateVariation = $this->randomAssignVariation($videoDetails[0]->templateId,$videoDetails[0]->dimension);
            if($templateVariation){
                // build the layer array
                $variationLayer = json_decode($templateVariation->newData);
                foreach($variationLayer->layers as $key => $layer){
                    if($layer->type == 'text' && $layer->src != ''){
                        $layer->src = trim($script);
                    }
                    if($layer->type == 'video'){
                        $layer->src = $media['src'];
                        $layer->thumbnail = $media['thumbnail'];
                    }
                }


                $insertData = array(
                    'userId' => $videoDetails[0]->userId,
                    'campaignId' => $videoDetails[0]->campaignId,
                    'videoSetId' => $videoDetails[0]->videoSetId,
                    'videoId' => $videoId,
                    'variationId' => $templateVariation->id,
                    'background' => json_encode($variationLayer->background),
                    'videoTiles' => json_encode($media),
                    'originalScript' => $script,
                    'isSelected' => $isSelected,
                    'audio' => $this->audioGeneration('tts'),
                    'duration' => 10,
                    'layers' => json_encode($variationLayer->layers),
                    'transitionName' => $transition,
                    'status' => 1,
                    'isDeleted' => 0
                );
                $insertSlide = $this->CI->DatabaseModel->insertData('slides', $insertData);
                if($insertSlide){
                    $returnResponse['status'] = true;
                    $returnResponse['message'] = 'Slide created successfully';
                    $returnResponse['slideId'] = $insertSlide;
                }
                else{
                    $returnResponse['message'] = 'Slide not created';
                }
            }
            else{
                $returnResponse['message'] = 'Variation not found';
            }
        }
        else
        {
            $returnResponse['message'] = 'Video not found';
        }

        return $returnResponse;

    }


    public function createSlideExtraa($transition,$videoId,$script, $keyword, $userId,$campaignId, $videoSetId)
    {
        $returnResponse = array('status' => false);

        $videoSetDetails = $this->CI->DatabaseModel->fetchTableData('video_sets', array('id' => $videoSetId));
        $videoDetails = $this->CI->DatabaseModel->fetchTableData('videos', array('id' => $videoId));
        if(!empty($videoSetDetails) && !empty($videoDetails)){
            $media = $this->fetchMedia($keyword[0]);

            $templateVariation = $this->randomAssignVariation($videoDetails[0]->templateId, $videoSetDetails[0]->dimension);
            if($templateVariation){

                // build the layer array
                $variationLayer = json_decode($templateVariation->newData);
                foreach($variationLayer->layers as $key => $layer){
                    if($layer->type == 'text'){
                        $layer->text = trim($script);
                    }
                    if($layer->type == 'video'){
                        $layer->src = $media['src'];
                        $layer->thumbnail = $media['thumbnail'];
                    }
                }


                $insertData = array(
                    'userId' => $userId,
                    'campaignId' => $campaignId,
                    'videoSetId' => $videoSetId,
                    'videoId' => $videoId,
                    'variationId' => $templateVariation->id,
                    'background' => json_encode($variationLayer->background),
                    'videoTiles' => json_encode($media),
                    'originalScript' => $script,
                    'isSelected' => false,
                    'audio' => $this->audioGeneration('tts'),
                    'duration' => 10,
                    'layers' => json_encode($variationLayer->layers),
                    'transitionName' => $transition,
                    'status' => 1,
                    'isDeleted' => 0
                );
                $insertSlide = $this->CI->DatabaseModel->insertData('slides', $insertData);
                if($insertSlide){
                    $returnResponse['status'] = true;
                    $returnResponse['message'] = 'Slide created successfully';
                    $returnResponse['slideId'] = $insertSlide;
                }
                else{
                    $returnResponse['message'] = 'Slide not created';
                }
            }
            else{
                $returnResponse['message'] = 'Variation not found';
            }
        }
        else{
            $returnResponse['message'] = 'Video set not found';
        }



        return $returnResponse;

    }

    public function createVideo($videoId,$script){

        $sentenceArray = explode(".",$script);
        $slideRank = array();
        foreach($sentenceArray as $sentenceKey => $sentence){
            if($sentence != ''){
                $keywordExtractedArray = $this->callApiKeyword($sentence);
                if($keywordExtractedArray['status']){
                    // get Transition
                    $transition = $this->randomAssignTransition();
                    $checkSlideCreation = $this->createSlide($transition,$videoId,$sentence, $keywordExtractedArray['keywords'], $sentenceKey == 0);
                    //print_r($checkSlideCreation);
                    $slideRank[] = $checkSlideCreation['slideId'];
                }
                else{
                    //$returnResponse['message'] = 'Not able to extract Keyword';
                }
            }
        }

        $updateVideo['status'] = 4;
        $updateVideo['slideRank'] = json_encode($slideRank);
        $updateVideo['modified'] = date('Y-m-d H:i:s');

        $updateVideoCheck = $this->CI->DatabaseModel->updateTable('videos', $updateVideo,array('id' => $videoId));
        if($updateVideoCheck)
        {
            $returnResponse['status'] = true;
            $returnResponse['message'] = 'Video created successfully';
        }
        else{
            $returnResponse['message'] = 'Video not created';
        }
        return $returnResponse;
    }



    public function startProcess($id)
    {
        $returnResponse = array('status' => false,'message' => 'Something went wrong');
        $video_sets_data = $this->CI->DatabaseModel->fetchTableData('video_sets', array('id' => $id, 'isDeleted' => 0));
        if($video_sets_data && is_array($video_sets_data)){
            $this->userId = $video_sets_data[0]->userId;
            $this->campaignId = $video_sets_data[0]->campaignId;
            $this->videoSetId = $video_sets_data[0]->id;
            $this->keyword = $video_sets_data[0]->keyword;
            $this->templateId = $this->randomAssignTemplate();
            $this->dimension = $video_sets_data[0]->dimension;


            $topic_data = $this->fetchTopic(); // random fetch topic name for replace keyword

            $query_str_key = str_replace("[KEYWORD]", $this->keyword, $topic_data);
            $query_str = str_replace("[LIMIT]", $video_sets_data[0]->videoLimit, $query_str_key);

            $response = $this->callApi($query_str, $this->userId,'list');
            if($response['status'])
            {
                $topicArray = $response['data'];
                if(is_array($topicArray) && count($topicArray) > 1)
                {
                    foreach($topicArray as $key => $topic)
                    {
                        $filterTopic = preg_replace('/\d+./', '', $topic, 1);
                        $scriptQuery = $this->fetchScript();
                        $scriptQuery = str_replace("[TOPIC]", $filterTopic, $scriptQuery);
                        $responseScript = $this->callApi($scriptQuery, $this->userId,'article');
                        if($responseScript['status'])
                        {
                            $scriptArray = $responseScript['data'];
                            $script = $scriptArray[0];

                            $sNo = $key+ 1;
                            $insert['userId'] = $this->userId;
                            $insert['campaignId'] = $this->campaignId;
                            $insert['videoSetId'] = $this->videoSetId;
                            $insert['name'] = $this->keyword . '_'. $sNo;
                            $insert['thumbnail'] = '';
                            $insert['videoUrl'] = '';
                            $insert['keyword'] = $this->keyword;
                            $insert['originalScript'] = $script;
                            $insert['backgroundAudio'] = $this->backgroundAudioGeneration('backgroundAudio');
                            $insert['templateId'] = $this->templateId;
                            $insert['dimension'] = $this->dimension;
                            $insert['logo'] = $this->logoWatermarkGeneration('logo');
                            $insert['watermark'] = $this->logoWatermarkGeneration('watermark');;
                            $insert['intro'] = $this->introOutroGeneration('intro');
                            $insert['outro'] = $this->introOutroGeneration('outro');;
                            $insert['status'] = 0;
                            $insert['renderProgress'] = 0;
                            $insert['isDeleted'] = 0;
                            $checkInsert = $this->CI->DatabaseModel->insertData('videos',$insert);
                            if($checkInsert){
//                                $sentenceArray = explode(".",$script);
//                                foreach($sentenceArray as $sentenceKey => $sentence){
//                                    if($sentence != ''){
//                                        $keywordExtractedArray = $this->callApiKeyword($sentence);
//                                        if($keywordExtractedArray['status'] == true){
//                                            $checkSlideCreation = $this->createSlide($checkInsert,$sentence, $keywordExtractedArray['keywords'], $sentenceKey == 0);
//                                            $returnResponse['message'] = $checkSlideCreation['message'];
//                                        }
//                                        else{
//                                            $returnResponse['message'] = 'Not able to extract Keyword';
//                                        }
//                                    }
//                                }
                            }
                            else{
                                $returnResponse['message'] = 'Not able to create videos';
                            }
                        }
                        else{
                            $returnResponse['message'] = 'Not able to generate script';
                        }
                    } // Topic Script loop end


                    $updateVideoSets['status'] = 1;
                    $updateVideoSets['modified'] = date('Y-m-d H:i:s');

                    $updateVideoSetsCheck = $this->CI->DatabaseModel->updateTable('video_sets', $updateVideoSets,array('id' => $this->videoSetId));
                    if($updateVideoSetsCheck){
                        $returnResponse['status'] = true;
                        $returnResponse['message'] = 'Video set created successfully';
                    }
                    else{
                        $returnResponse['message'] = 'Video set not created';
                    }
                }
                else{
                    $returnResponse['message'] = 'Topics are less than 1';
                }

            }
            else{
                $returnResponse['message'] = $response->message;
            }
        }
        else{
            $returnResponse['message'] = 'Video set ID is not found';
        }

        return $returnResponse;
    }





}