<?php defined('BASEPATH') or exit('No direct script access allowed');

class Adi
{

    private $CI;

    public function __construct()
    {

        $this->CI = &get_instance();
    }

    public function curl_file_get_contents($url)
    {
        $curl = curl_init();
        $userAgent = 'Mozilla/6.0 (compatible; MSIE 6.0; Windows NT 5.1; .NET CLR 1.1.4322)';

        curl_setopt($curl, CURLOPT_URL, $url); //The URL to fetch. This can also be set when initializing a session with curl_init().
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true); //TRUE to return the transfer as a string of the return value of curl_exec() instead of outputting it out directly.
        curl_setopt($curl, CURLOPT_CONNECTTIMEOUT, 5); //The number of seconds to wait while trying to connect.
        curl_setopt($curl, CURLOPT_IPRESOLVE, CURL_IPRESOLVE_V4);
        curl_setopt($curl, CURLOPT_USERAGENT, $userAgent); //The contents of the "User-Agent: " header to be used in a HTTP request.
        curl_setopt($curl, CURLOPT_FOLLOWLOCATION, true); //To follow any "Location: " header that the server sends as part of the HTTP header.
        curl_setopt($curl, CURLOPT_AUTOREFERER, true); //To automatically set the Referer: field in requests where it follows a Location: redirect.
        curl_setopt($curl, CURLOPT_TIMEOUT, 100); //The maximum number of seconds to allow cURL functions to execute.
        curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false); //To stop cURL from verifying the peer's certificate.
        $contents = curl_exec($curl);
        return json_decode($contents);
    }

    public function curl_get_authorization($url, $access_token)
    {
        $curl = curl_init();
        $userAgent = 'Mozilla/6.0 (compatible; MSIE 6.0; Windows NT 5.1; .NET CLR 1.1.4322)';

        curl_setopt($curl, CURLOPT_URL, $url); //The URL to fetch. This can also be set when initializing a session with curl_init().
        curl_setopt($curl, CURLOPT_HTTPHEADER, array(
            'Content-Type: application/json',
            'Authorization: Bearer ' . $access_token,
        ));
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true); //TRUE to return the transfer as a string of the return value of curl_exec() instead of outputting it out directly.
        curl_setopt($curl, CURLOPT_CONNECTTIMEOUT, 5); //The number of seconds to wait while trying to connect.
        curl_setopt($curl, CURLOPT_IPRESOLVE, CURL_IPRESOLVE_V4);
        curl_setopt($curl, CURLOPT_USERAGENT, $userAgent); //The contents of the "User-Agent: " header to be used in a HTTP request.
        curl_setopt($curl, CURLOPT_FOLLOWLOCATION, true); //To follow any "Location: " header that the server sends as part of the HTTP header.
        curl_setopt($curl, CURLOPT_AUTOREFERER, true); //To automatically set the Referer: field in requests where it follows a Location: redirect.
        curl_setopt($curl, CURLOPT_TIMEOUT, 100); //The maximum number of seconds to allow cURL functions to execute.
        curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false); //To stop cURL from verifying the peer's certificate.
        $contents = curl_exec($curl);
        return json_decode($contents);
    }

    public function curl_post_request($url, $fields, $type = 'no', $headers = null)
    {

        if ($type == 'no') {
            $post = '';
            foreach ($fields as $key => $value) {$post .= $key . '=' . $value . '&';}
            $post = rtrim($post, '&');
        } else {
            $post = $fields;
        }
        $curl = curl_init();
        curl_setopt($curl, CURLOPT_URL, $url);
        if ($headers == null) {

        } else {
            curl_setopt($curl, CURLOPT_HTTPHEADER, $headers);
        }
        //curl_setopt($curl, CURLOPT_POST, count($fields));
        curl_setopt($curl, CURLOPT_POSTFIELDS, $fields);
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, true);

        curl_setopt($curl, CURLOPT_ENCODING, '');
        curl_setopt($curl, CURLOPT_MAXREDIRS, 10);
        curl_setopt($curl, CURLOPT_TIMEOUT, 0);
        curl_setopt($curl, CURLOPT_FOLLOWLOCATION, true);
        curl_setopt($curl, CURLOPT_HTTP_VERSION, 'CURL_HTTP_VERSION_1_1');
        curl_setopt($curl, CURLOPT_CUSTOMREQUEST, 'POST');

        $result = curl_exec($curl);
        curl_close($curl);
        return json_decode($result);
    }

    public function curl_post_request_json($url, $data,$clientID,$secretId)
    {
        $ch = curl_init();
        $data = json_encode($data);
        curl_setopt($ch, CURLOPT_HTTPHEADER, array(
            'Content-Type: application/json'
            //'Authorization: Bearer ' . $token,
        ));

        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch,  CURLOPT_USERPWD, $clientID . ":" . $secretId,);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        $server_output = curl_exec($ch);
        curl_close($ch);

        return json_decode($server_output);

    }

    public function curl_post_request_google($url, $access_token)
    {
        $fields = array();
        $post = json_encode($fields);
        $curl = curl_init();
        curl_setopt($curl, CURLOPT_HTTPHEADER, array(
            'Content-Type: application/json',
            'Authorization: Bearer ' . $access_token,
        ));
        curl_setopt($curl, CURLOPT_URL, $url);
        curl_setopt($curl, CURLOPT_POST, count($fields));
        curl_setopt($curl, CURLOPT_POSTFIELDS, $post);
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
        $result = curl_exec($curl);
        curl_close($curl);
        return json_decode($result);
    }

    public function curl_post_x_auth($url, $key, $post)
    {
        $ch = curl_init();
        curl_setopt_array($ch, array(
            CURLOPT_URL => $url,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_POST => true,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 30,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => "POST",
            CURLOPT_POSTFIELDS => $post,
            CURLOPT_HTTPHEADER => array(
                'X-Auth-Token: api-key ' . $key,
                'Content-Type: application/json',
                'cache-control: no-cache',
            ),
        ));
        $result = curl_exec($ch);
        curl_close($ch);

        return json_decode($result);
    }

    public function render_request($field, $url)
    {
        $curl = curl_init();
        curl_setopt_array($curl, array(
            CURLOPT_URL => $url,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'GET',
            CURLOPT_POSTFIELDS => $field,
            CURLOPT_HTTPHEADER => array(
                'Content-Type: application/json',
            ),
        ));

        $response = curl_exec($curl);
        curl_close($curl);
    }

    public function curl_delete_request($url, $fields = array())
    {
        $post = '';
        foreach ($fields as $key => $value) {$post .= $key . '=' . $value . '&';}
        $post = rtrim($post, '&');
        $curl = curl_init();
        curl_setopt($curl, CURLOPT_URL, $url);
        curl_setopt($curl, CURLOPT_CUSTOMREQUEST, "DELETE");
        curl_setopt($curl, CURLOPT_POSTFIELDS, $post);
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
        $result = curl_exec($curl);
        curl_close($curl);
        return json_decode($result);
    }

    public function createFolders($user_id, $project_id = 0)
    {
        if (!file_exists('uploads/' . $user_id . '/')) {
            mkdir('uploads/' . $user_id . '/', 0777, true);
        }

        if (!file_exists('uploads/' . $user_id . '/logs/' . $project_id . '/')) {
            mkdir('uploads/' . $user_id . '/logs/' . $project_id, 0777, true);
        }
        if (!file_exists('uploads/' . $user_id . '/csv')) {
            mkdir('uploads/' . $user_id . '/csv', 0777, true);
        }

        if (!file_exists('uploads/' . $user_id . '/background')) {
            mkdir('uploads/' . $user_id . '/background', 0777, true);
        }

        if (!file_exists('uploads/' . $user_id . '/videos')) {
            mkdir('uploads/' . $user_id . '/videos', 0777, true);
        }

        if (!file_exists('uploads/' . $user_id . '/images')) {
            mkdir('uploads/' . $user_id . '/images', 0777, true);
        }

        if (!file_exists('uploads/' . $user_id . '/logo')) {
            mkdir('uploads/' . $user_id . '/logo', 0777, true);
        }

        if (!file_exists('uploads/' . $user_id . '/watermark')) {
            mkdir('uploads/' . $user_id . '/watermark', 0777, true);
        }

        if (!file_exists('uploads/' . $user_id . '/profile')) {
            mkdir('uploads/' . $user_id . '/profile', 0777, true);
        }

        if (!file_exists('uploads/' . $user_id . '/music')) {
            mkdir('uploads/' . $user_id . '/music', 0777, true);
        }

        if (!file_exists('uploads/' . $user_id . '/voiceover')) {
            mkdir('uploads/' . $user_id . '/voiceover', 0777, true);
        }

        if (!file_exists('uploads/' . $user_id . '/recording')) {
            mkdir('uploads/' . $user_id . '/recording', 0777, true);
        }

        if (!file_exists('uploads/' . $user_id . '/tts')) {
            mkdir('uploads/' . $user_id . '/tts', 0777, true);
        }

        if (!file_exists('uploads/' . $user_id . '/polly')) {
            mkdir('uploads/' . $user_id . '/polly', 0777, true);
        }

        if (!file_exists('uploads/' . $user_id . '/intro')) {
            mkdir('uploads/' . $user_id . '/intro', 0777, true);
        }

        if (!file_exists('uploads/' . $user_id . '/outro')) {
            mkdir('uploads/' . $user_id . '/outro', 0777, true);
        }
    }

    private function random_color_part()
    {
        return str_pad(dechex(mt_rand(0, 255)), 2, '0', STR_PAD_LEFT);
    }

    public function random_color()
    {
        return '#' . $this->random_color_part() . $this->random_color_part() . $this->random_color_part();
    }

    public function is_logged_in()
    {
        if (isset($this->CI->session->userdata['user_details']['email'])) {
            $user_id = $this->CI->session->userdata['user_details']['user_id'];
            $row = $this->CI->DatabaseModel->fetchTableData('users', array('id' => $user_id));
            if ($row[0]->status == 1) {
                return true;
            } else {
                return false;
            }

        } else {
            return false;
        }
    }

    public function randomPassword()
    {
        $alphabet = 'abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789';
        $pass = array(); //remember to declare $pass as an array
        $alphaLength = strlen($alphabet) - 1; //put the length -1 in cache
        for ($i = 0; $i < 22; $i++) {
            $n = rand(0, $alphaLength);
            $pass[] = $alphabet[$n];
        }
        return implode($pass); //turn the array into a string
    }

    public function isValidJSON($str)
    {
        if (json_decode($str) !== null && strlen($str) > 0) {
            return json_decode($str);
        } else {
            return false;
        }
    }

    /**
     * @param $src $src path of the file  source
     * @param $dst $dst path of the file  destination
     * @return bool
     */
    public function recurse_copy($src, $dst)
    {
        $dir = opendir($src);
        if ($dir) {
            @mkdir($dst);
            while (false !== ($file = readdir($dir))) {
                if (($file != '.') && ($file != '..')) {
                    if (is_dir($src . '/' . $file)) {
                        $this->recurse_copy($src . '/' . $file, $dst . '/' . $file);
                    } else {
                        copy($src . '/' . $file, $dst . '/' . $file);
                    }
                }
            }
            closedir($dir);
            return true;
        } else {
            return false;
        }
    }

    /**
     * @param $source $source path of the file to be zipped
     * @param $destination $destination path of the file to be zipped
     * @return bool
     */
    public function zip_the_file($source, $destination)
    {
        if (!extension_loaded('zip') || !file_exists($source)) {
            return false;
        }
        $zip = new ZipArchive();
        if (!$zip->open($destination, ZIPARCHIVE::CREATE)) {
            return false;
        }
        $source = str_replace('\\', '/', realpath($source));
        if (is_dir($source) === true) {
            $files = new RecursiveIteratorIterator(new RecursiveDirectoryIterator($source), RecursiveIteratorIterator::SELF_FIRST);
            foreach ($files as $file) {
                $file = str_replace('\\', '/', $file);
                // Ignore "." and ".." folders
                if (in_array(substr($file, strrpos($file, '/') + 1), array('.', '..'))) {
                    continue;
                }

                $file = realpath($file);
                if (is_dir($file) === true) {
                    $zip->addEmptyDir(str_replace($source . '/', '', $file . '/'));
                } else if (is_file($file) === true) {
                    $zip->addFromString(str_replace($source . '/', '', $file), file_get_contents($file));
                }
            }
        } else if (is_file($source) === true) {
            $zip->addFromString(basename($source), file_get_contents($source));
        }
        return $zip->close();
    }

    /**
     * @param $dirPath $dirPath path of the directory to be deleted
     */
    public function deleteDir($dirPath)
    {
        if (!is_dir($dirPath)) {
            throw new InvalidArgumentException("$dirPath must be a directory");
        }
        if (substr($dirPath, strlen($dirPath) - 1, 1) != '/') {
            $dirPath .= '/';
        }
        $files = glob($dirPath . '*', GLOB_MARK);
        foreach ($files as $file) {
            if (is_dir($file)) {
                $this->deleteDir($file);
            } else {
                unlink($file);
            }
        }
        rmdir($dirPath);
    }

    /* Custom to this project */
    public function fetch_user_details()
    {
        $user_id = $this->CI->session->userdata['user_details']['user_id'];
        $row = $this->CI->DatabaseModel->fetchTableData('users', array('id' => $user_id));
        if ($row != false) {
            $ret['status'] = true;
            $ret['message'] = $row[0];
            return $ret;
        } else {
            return false;
        }
    }

    // public function urlCheck($table, $condition)
    // {
    //     $res = $this->CI->DatabaseModel->exists($table, $condition);
    //     if (!empty($res)) {
    //         return true;
    //     } else {
    //         return false;
    //     }

    // }

    public function delete_files($path)
    {
        $path = realpath($path);
        $now = time(); // now time

        $objects = new RecursiveIteratorIterator(new RecursiveDirectoryIterator($path));
        $i = 1;
        $deleted = false;
        foreach ($objects as $name => $object) {
            if (!is_file($name)) {
                continue;
            }

            // check file info and delete
            if (is_file($name)) {
                //if ($now - filemtime($name) >= 60  60  24 * 2) {  // files older than 7 day

                unlink($name);
                $deleted = true;
                //echo 'deleted ------->' . $name . "<br />";
                //}
            }

        }
        if ($deleted) {
            return true;
        } else {
            return false;
        }
    }

    public function _loginLogs($email)
    {
        $id = $this->CI->DatabaseModel->insertData('user_logs', array(
            'userid' => $this->CI->DatabaseModel->getField('id', 'users', 'email', $email),
            'email' => $email,
            'login_at' => date("Y-m-d h:i:sa"),
            'ip_address' => $this->CI->input->ip_address(),
            'location' => $this->CI->agent->platform()));

        if ($id) {
            return true;
        }
        return false;
    }

    public static function downloadDistantFile($url, $dest)
    {
        $options = array(
            CURLOPT_FILE => is_resource($dest) ? $dest : fopen($dest, 'w'),
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_URL => $url,
            CURLOPT_FAILONERROR => true, // HTTP code > 400 will throw curl error
        );

        $ch = curl_init();
        curl_setopt_array($ch, $options);
        $return = curl_exec($ch);
        fclose($dest);
        if ($return === false) {
            return curl_error($ch);
        } else {
            return true;
        }
    }
    public function _mail($to, $subject, $body)
    {

        $res = $this->CI->DatabaseModel->fetchTableData('smtp');
        $config = array(

            'protocol' => $res[0]->protocol,
            'smtp_host' => $res[0]->smtp_host,
            'smtp_port' => $res[0]->smtp_port,
            'smtp_user' => $res[0]->smtp_user,
            'smtp_pass' => $res[0]->smtp_pass,
            'smtp_crypto' => $res[0]->smtp_crypto,
            'smtp_timeout' => $res[0]->smtp_timeout,
            'mailtype' => $res[0]->mailtype,
            'charset' => $res[0]->charset,
        );

        $this->CI->load->library('email', $config);
        $this->CI->email->set_newline("\r\n");
        $this->CI->email->from('abhi@abhineos.com', APP_NAME);
        $this->CI->email->to($to); // replace it with receiver mail id
        $this->CI->email->subject($subject); // replace it with relevant subject
        $this->CI->email->message($body);
        $this->CI->email->send();

    }

    private function _logs($user_id)
    {
        $data = array(
            'user_id' => $user_id,
            'controller' => $this->CI->router->fetch_class(),
            'function' => $this->CI->router->fetch_method(),
            'url' => current_url(),
            'ip' => $this->CI->input->ip_address(),
            'request_type' => $this->CI->input->method(),
            'browser' => $this->CI->agent->browser(),
            'platform' => $this->CI->agent->platform(),
        );
        $this->CI->DatabaseModel->insertData('user_activities', $data);
    }

    public function _response($response, $user_id = false, $status_code = 200)
    {
        if ($user_id) {
            $this->_logs($user_id);
        }

        header("Access-Control-Allow-Headers: *");
        header("Access-Control-Allow-Methods: GET, POST, OPTIONS, PUT, DELETE");
        header("HTTP/1.1 200 OK");
        header("Content-type:application/json");
        header('Content-Type: text/plain');
        echo json_encode($response, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES);
        exit;
    }
}
