<?php

/**
 * @property CI_Output output
 * @property CI_Input input
 * @property DatabaseModel DatabaseModel
 * @property CI_Email email
 * @property CI_Router router
 * @property  CI_Encryption encryption
 * @property CI_User_agent agent
 */

class App_Controller extends CI_Controller
{

    protected $user_id;
    public function __construct()
    {
        parent::__construct();

        $this->load->library('encryption');
        $this->load->library('user_agent');
        $this->load->library('passwordencryption');
        $this->_auth();
        $this->_logs();
    }

    private function _auth()
    {
        $response = array('status' => false, 'message' => 'Unauthorized access, missing authorization token.');

        $headers = $this->input->request_headers();

        if (isset($headers['Authorization'])) {
            $token = $headers['Authorization'];

            try {
                $data = AUTHORIZATION::validateToken($token);

                $user_id = $data['data']['user_id'];
                if ($data['status'] === false) {

                    $response['message'] = 'Unauthorized access.';
                } else {
                    if ($this->DatabaseModel->exists('tokens', array('token' => $token, 'deleted' => 0))) {
                        $this->user_id = $user_id;
                        return true;
                    } else {
                        $response = array('status' => false, 'message' => 'Unauthorized access, Please login again.');
                    }
                }
            } catch (Exception $e) {
                $response['message'] = $e->getMessage();
            }
        }
        $this->_response($response, 401);
        die;
    }

    private function _logs()
    {
        $data = array(
            'user_id' => $this->user_id,
            'controller' => $this->router->fetch_class(),
            'function' => $this->router->fetch_method(),
            'url' => current_url(),
            'ip' => $this->input->ip_address(),
            'request_type' => $this->input->method(),
            'browser' => $this->agent->browser(),
            'platform' => $this->agent->platform(),
        );
        $this->DatabaseModel->insertData('user_activities', $data);
    }

    protected function _response($response, $status_code = 200)
    {
        $this->output
            ->set_status_header($status_code)
            ->set_header('HTTP/1.0 200 OK')
            ->set_content_type('application/json', 'utf-8')
            ->set_output(json_encode($response, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES))
            ->_display();
        exit;
    }

    public function isValidJson($str)
    {
        if (json_decode($str) !== null && strlen($str) > 0) {
            return json_decode($str);
        } else {
            return false;
        }
    }

    protected function _mail($to, $subject, $body)
    {

        $config = array(
            'protocol' => 'smtp',
            'smtp_host' => 'mail.smtp.com',
            'smtp_port' => 80,
            'smtp_user' => 'abhi-sender@vega6.com',
            'smtp_pass' => 'tH9(t*N4yMAnk9XV',
            'smtp_timeout' => '4',
            'mailtype' => 'html',
            'charset' => 'iso-8859-1',
        );

        $this->load->library('email', $config);
        $this->email->set_newline("\r\n");
        $this->email->from('abhi@abhineos.com', APP_NAME);
        $this->email->to($to); // replace it with receiver mail id
        $this->email->subject($subject); // replace it with relevant subject
        $this->email->message($body);
        $this->email->send();

    }

    protected function _encrypt($data)
    {
        $this->encryption->initialize(
            array(
                'cipher' => 'aes-256',
                'mode' => 'ctr',
                'key' => 'STREEM4FE5(Q&XKALFK1FTtPOHp4G8REEL',
            )
        );
        return $this->encryption->encrypt($data);
    }

    protected function _decrypt($data)
    {
        $this->load->library('encryption');
        $this->encryption->initialize(
            array(
                'cipher' => 'aes-256',
                'mode' => 'ctr',
                'key' => 'STREEM4FE5(Q&XKALFK1FTtPOHp4G8REEL',
            )
        );
        return $this->encryption->decrypt($data);
    }

    protected function _videoDownloader($youtube_url)
    {
        $path = FCPATH . 'assets/video/';
        if (!is_dir($path)) {
            mkdir($path, 0777, true);
        }
        $name = time() . '_' . str_shuffle(time()) . '.mp4';

        try {
            $content = file_get_contents($youtube_url);

            file_put_contents($path . $name, $content);
            // print_r(str_replace(FCPATH,'',$path.$name));exit;

            return $path . $name;

        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }

    }

}