<?php
class HomeController extends CI_Controller
{
    private $user_id;
    public function __construct()
    {
        parent::__construct();
        $this->load->library(array('stripe','paypal'));
    }

    public function loadBusiness($id){
        $data['data'] = $this->DatabaseModel->fetchTableData('business', array('id' => $id, 'isDeleted' => 0));
        if ($data) {
            $this->load->view('web_publishing/business/index.php', $data);
        } else {
            $this->load->view('web_publishing/404page/index.php');
        }
    }

    public function loadProduct($id){
        $data['pro'] = $this->DatabaseModel->fetchTableData('product', array('id' => $id, 'isDeleted' => 0));
        if (!empty($data['pro'])) {
            $productBid = $data['pro'][0]->bid;
            $data['data'] = $this->DatabaseModel->fetchTableData('business', array('id' => $productBid, 'isDeleted' => 0));
            $this->load->view('web_publishing/product_page/index.php', $data);
        } else {
            $this->load->view('web_publishing/404page/index.php');
        }
    }

    public function verifyCouponCheckOut()
    {
        $jsonData = file_get_contents("php://input");
        if ($postData = $this->adi->isValidJson($jsonData)) {
            $couponCode = $postData->couponCode;
            $productId = $postData->productId;

            if (isset($couponCode) && !empty($productId)) {

                $productsDetails = $this->DatabaseModel->fetchTableData('coupon_product_assign', array('pid' => $productId));

                if (!empty($productsDetails)) {
                    $couponID = $productsDetails[0]->cid;
                    $couponDetails = $this->DatabaseModel->fetchTableData('coupon', array('id' => $couponID, 'couponCode' => $couponCode));
                    if (!empty($couponDetails)) {
                        $couponStart = $couponDetails[0]->couponStart;
                        $couponTo = $couponDetails[0]->couponTo;
                        $couponAmount = $couponDetails[0]->couponAmount;
                        $couponType = $couponDetails[0]->couponType;
                        $coupopnId = $couponDetails[0]->id;
                        $cid = $productsDetails[0]->cid;
                        if ($coupopnId == $cid) {
                            $currentDate = date('Y-m-d H:i:s');
                            if (strtotime($couponStart) <= strtotime($currentDate)) {
                                if (strtotime($couponTo) >= strtotime($currentDate)) {
                                    $dataArr = array(
                                        "discountAmount" => $couponAmount,
                                        "discountType" => $couponType,
                                    );
                                    $response = array('status' => true, 'message' => 'Successfully apply coupon', 'data' => $dataArr);
                                    echo json_encode($response);die();
                                } else {
                                    $response = array('status' => false, 'message' => 'This Coupon is expired');
                                    echo json_encode($response);die();
                                }

                            } else {
                                $response = array('status' => false, 'message' => 'Invalid Coupon');
                                echo json_encode($response);die();
                            }

                        } else {
                            $response = array('status' => false, 'message' => 'Invalid Coupon');
                            echo json_encode($response);die();
                        }
                    } else {
                        $response = array('status' => false, 'message' => 'Invalid Coupon');
                        echo json_encode($response);die();
                    }

                } else {
                    $response = array('status' => false, 'message' => 'Invalid Coupon');
                    echo json_encode($response);die();
                }

            } else {
                $response = array('status' => false, 'message' => 'Please enter coupon code');
                echo json_encode($response);die();
            }
        }

    }


    public function orderCreate()
    {
        $jsonData = file_get_contents("php://input");
        if ($postData = $this->adi->isValidJson($jsonData)){
            $buyerName = $postData->buyerName;
            $buyerEmail = $postData->buyerEmail;
            $productId = $postData->productId;
            $paymentId = $postData->paymentId;
            $paymentType = $postData->paymentType;
            $paymentMode = $postData->paymentMode;
            $price = $postData->price;
            $baseCurrency = $postData->baseCurrency;
                 
            if ($price <= 0) {
                $url = base_url() . 'success-order/' . $productId;
                $newArr = array('status' => true, 'message' => '', 'url' => $url);
                echo json_encode($newArr);die();
            }


            if ($buyerName != '' || $buyerEmail != '' || $productId != '' || $paymentId != '' || $price != '' || $baseCurrency != '') {
                if ($paymentType == 'paypal') {
                   
                    $paypalData = $this->paypal->createOrderPaypal($buyerName, $buyerEmail, $productId, $paymentId, $paymentMode, $price, $baseCurrency);
                    if (!empty($paypalData) && $paypalData['status'] == true) {
                        echo json_encode($paypalData);die();
                    } else {
                        $newArr = array('status' => false, 'message' => 'Something went wrong!');
                        echo json_encode($newArr);die();
                    }
                }
                if ($paymentType == 'stripe') {
                    $stripeData = $this->stripe->createOrder($buyerName,$price,$buyerEmail,$paymentId);
                }
            } else {
                $newArr = array('status' => false, 'message' => 'Messing Required Parameter!');
                echo json_encode($newArr);die();
            }

        }
        else {
            $newArr = array('status' => false, 'message' => 'Something went wrong!');
            echo json_encode($newArr);die();
        }
    }


    public function paypalSuccess(){
        $res=$this->paypal->successPaypalPayment();
             if($res){
                print_r($res);

             }
    }

    public function paypalError(){
        $this->paypal->cancelPaypalPayment();
    }





}
