<?php
use TBETool\GenerateVideoScreenshots;

class UsersUpload extends CI_Controller
{
    /**
     * @var void
     */
    private $verify_token;
    private $region;
    private $access_key;
    private $secret_key;

    public function __construct()
    {
        parent::__construct();
        $this->load->library(array('user_agent', 'amazon_manager'));
        $verify_token = $this->jwt_verify->verify_token_2();
        if ($verify_token['status'] != false) {
            $this->user_id = $verify_token['data']['user_id'];
        } else {
            $this->adi->_response($verify_token);
            die();
        }

    }

    public function upload_csv()
    {
        $this->adi->createFolders($this->user_id);

        if (isset($_FILES['file']['tmp_name'])) {

            $file = $_FILES['file']['tmp_name'];
            $file_type = $_FILES['file']['type'];
            if ($file_type == "text/csv") {

                $config['allowed_types'] = 'csv';
                $config['upload_path'] = './uploads/' . $this->user_id . '/csv';
                $this->load->library('upload', $config);
                $this->upload->initialize($config);

                if (!$this->upload->do_upload('file')) {
                    $response['message'] = strip_tags($this->upload->display_errors());
                    $response['status'] = false;
                } else {

                    $file = $this->upload->data();
                    $file_path = base_url() . 'uploads/' . $this->user_id . '/csv/' . $file['file_name'];
                    $file = fopen($file_path, "r");

                    $columns = fgetcsv($file);

                    $data = [];

                    while ($row = fgetcsv($file)) {

                        $data[] = array_combine($columns, $row);
                    }
                    foreach ($data as $key => $val) {
                        $data = array(
                            'userId' => $this->user_id,
                            'name' => $val['Name'],
                            'productName' => $val['Product'],
                            'paidby' => $val['Paid By'],
                            'status' => $val['Status'],

                        );
                        $this->DatabaseModel->insertData('customers', $data);
                    }

                    $response['message'] = "File Uploaded Successfully";
                    $response['status'] = true;

                }
                $this->adi->_response($response);
            }

        }

    }

    public function file_upload()
    {
        $user_id = $this->user_id;

        $this->adi->createFolders($user_id);

        $upload_type = $this->input->post('upload_type');
        $file_type = $this->input->post('file_type');
        $paths = FCPATH . '/uploads/' . $user_id . '/' . $upload_type . '/';
        if ($upload_type == 'video') {
            $config['upload_path'] = './uploads/' . $user_id . '/videos/';
            $config['allowed_types'] = 'mp4|wmv|mov|avi|webm';
            $config['file_name'] = strtotime("now") . '_' . $this->adi->randomPassword() . 'fast-paid' . $user_id;
        }
        if ($upload_type == 'intro') {
            $config['upload_path'] = './uploads/' . $user_id . '/intro/';
            $config['allowed_types'] = 'mp4|wmv|mov|avi|webm';
            $config['file_name'] = strtotime("now") . '_' . $this->adi->randomPassword() . 'fast-paid' . $user_id;
        }

        if ($upload_type == 'outro') {
            $config['upload_path'] = './uploads/' . $user_id . '/outro/';
            $config['allowed_types'] = 'mp4|wmv|mov|avi|webm';
            $config['file_name'] = strtotime("now") . '_' . $this->adi->randomPassword() . 'fast-paid' . $user_id;
        }

        if ($upload_type == 'images') {
            $config['upload_path'] = './uploads/' . $user_id . '/images/';
            $config['allowed_types'] = 'png|jpg|jpeg';
            $config['file_name'] = strtotime("now") . '_' . $this->adi->randomPassword() . 'fast-paid' . $user_id;
        }
        if ($upload_type == 'profile') {
            $config['upload_path'] = './uploads/' . $user_id . '/profile/';
            $config['allowed_types'] = 'png|jpg|jpeg';
            $config['file_name'] = strtotime("now") . '_' . $this->adi->randomPassword() . 'fast-paid' . $user_id;
        }
        if ($upload_type == 'logo') {
            $config['upload_path'] = './uploads/' . $user_id . '/logo/';
            $config['allowed_types'] = 'png|jpg|jpeg';
            $config['file_name'] = strtotime("now") . '_' . $this->adi->randomPassword() . 'fast-paid' . $user_id;
        }
        if ($upload_type == 'watermark') {
            $config['upload_path'] = './uploads/' . $user_id . '/watermark/';
            $config['allowed_types'] = 'png|jpg|jpeg';
            $config['file_name'] = strtotime("now") . '_' . $this->adi->randomPassword() . 'fast-paid' . $user_id;
        }
        if ($upload_type == 'voiceover') {
            $config['upload_path'] = './uploads/' . $user_id . '/voiceover/';
            $config['allowed_types'] = 'mp3|wav';
            if ($file_type == 'recording') {
                $config['file_name'] = strtotime("now") . '_' . $this->adi->randomPassword() . 'fast-paid' . $user_id . '.mp3';
            } else {
                $config['file_name'] = strtotime("now") . '_' . $this->adi->randomPassword() . 'fast-paid' . $user_id;
            }
        }
        if ($upload_type == 'recording') {
            $config['upload_path'] = './uploads/' . $user_id . '/recording/';
            $config['allowed_types'] = '*';
            $config['file_name'] = strtotime("now") . '_' . $this->adi->randomPassword() . 'fast-paid' . $user_id . '.mp3';

        }

        if ($upload_type == 'music') {
            $config['upload_path'] = './uploads/' . $user_id . '/music/';
            $config['allowed_types'] = '*';
            if ($file_type == 'recording') {
                $config['file_name'] = strtotime("now") . '_' . $this->adi->randomPassword() . 'fast-paid' . $user_id . '.mp3';
            } else {
                $config['file_name'] = strtotime("now") . '_' . $this->adi->randomPassword() . 'fast-paid' . $user_id;
            }
        }
        $config['max_size'] = 200 * 1024; // 200 MB
        $this->load->library('upload', $config);
        $this->upload->initialize($config);
        if (!$this->upload->do_upload('file')) {
            $data['message'] = strip_tags($this->upload->display_errors());
            $data['status'] = false;
        } else {
            $file = $this->upload->data();

            if ($upload_type == 'profile') {
                $update['image'] = $user_id . '/' . 'profile/' . $file['file_name'];
                $update['modified'] = date('Y-m-d H:i:s');
                $this->DatabaseModel->updateTable('users', $update, array('id', $user_id));
            }
            if ($upload_type == 'images') {
                $file['remote_path'] = base_url() . 'uploads/' . $user_id . '/images/' . $file['file_name'];
                $message = 'Image uploaded';
            }
            if ($upload_type == 'voiceover') {
                $file['remote_path'] = base_url() . 'uploads/' . $user_id . '/voiceover/' . $file['file_name'];

            }

            if ($upload_type == 'video') {
                $file['remote_path'] = base_url() . 'uploads/' . $user_id . '/videos/' . $file['file_name'];

            }

            if ($upload_type == 'intro') {
                $file['remote_path'] = base_url() . 'uploads/' . $user_id . '/intro/' . $file['file_name'];

            }

            if ($upload_type == 'outro') {
                $file['remote_path'] = base_url() . 'uploads/' . $user_id . '/outro/' . $file['file_name'];

            }
            if ($upload_type == 'logo') {
                $file['remote_path'] = base_url() . 'uploads/' . $user_id . '/logo/' . $file['file_name'];

            }
            if ($upload_type == 'watermark') {
                $file['remote_path'] = base_url() . 'uploads/' . $user_id . '/watermark/' . $file['file_name'];

            }

            if ($upload_type == 'transcribe') {
                $file['remote_path'] = base_url() . 'uploads/' . $user_id . '/transcribe/' . $file['file_name'];

            }
            if ($upload_type == 'music') {
                $file['remote_path'] = base_url() . 'uploads/' . $user_id . '/music/' . $file['file_name'];

            }

            if ($upload_type == 'recording') {
                $file['remote_path'] = base_url() . 'uploads/' . $user_id . '/recording/' . $file['file_name'];

            }

            $name = $_FILES['file']['name'];
            $explode = explode('.', $name);
            $ext = strtolower(end($explode));

            $upload_array = array('images', 'video', 'audio', 'music', 'logo', 'watermark', 'intro', 'outro', 'voiceover', 'recording');

            if (in_array($upload_type, $upload_array)) {
                // upload in Amazon s3

                $path = str_replace(base_url(), '', $file['remote_path']);

                $durationGet = 0;
                $duration_type = array('audio', 'music', 'voiceover', 'recording');
                if (in_array($upload_type, $duration_type)) {
                    $durationGet = $this->durationGet(site_url($path . $file['file_name']));
                }

                if ($upload_type == 'video' || 'intro' || 'outro') {
                    $viurl = FCPATH . $path;
                    $thumbnail = '';
                    $obj = new GenerateVideoScreenshots(FFMPEG_PATH);
                    $obj->setOutputPath($paths . 'video_screenshots/');
                    $s3Poster = '';
                    try {
                        $thumbnail = $obj->generateScreenshot($viurl);

                        $s3Poster = $this->amazon_manager->s3Upload($thumbnail, 'fast-paid/' . $user_id . '/screenshot' . time() . '.jpg');
                    } catch (Exception $e) {
                    }
                }

                try {

                    $s3url = $this->amazon_manager->s3Upload($path, 'fast-paid/' . $user_id . '/' . $file['file_name']);
                    $insert['file'] = $s3url;
                    $insert['user_id'] = $user_id;
                    $insert['video_screenshot'] = $s3Poster;
                    $insert['created'] = date('Y-m-d H:i:s');
                    $insert['updated'] = date('Y-m-d H:i:s');
                    $insert['status'] = 1;
                    $insert['name'] = $explode[0];
                    $insert['file_type'] = $ext;
                    $insert['duration'] = $durationGet;
                    $insert['type'] = $upload_type;
                    $insertId = $this->DatabaseModel->insertData('user_library', $insert);
                    if ($insertId > 0) {
                        $responseData = array(
                            'path' => $s3url,
                            'name' => $file['file_name'],
                            'thumbnail' => $s3Poster,
                            'type' => $upload_type,
                            'duration' => $durationGet,
                        );
                        $data = array(
                            'status' => true,
                            'data' => $responseData,
                        );

                    } else {
                        $data = array(
                            'status' => false,
                            'message' => 'Something went wrong please try again!',
                        );
                    }
                } catch (Exception $e) {
                    $data['message'] = $e->getMessage();
                    $data['status'] = false;
                }

            } else {
                $data['status'] = true;
                $data['message'] = $file;
            }

        }
        echo json_encode($data, $this->user_id);die();
    }
    public function durationGet($url)
    {

        $filename = FCPATH . 'uploads/' . time() . '.mp3';
        if (file_put_contents($filename, file_get_contents($url, false, null, 0, 30000000))) {
            if (require_once ('vendor/james-heinrich/getid3/getid3/getid3.php')) {
                $getID3 = new getID3;
                $ThisFileInfo = $getID3->analyze($filename);
                if (!empty($ThisFileInfo['playtime_seconds']) && isset($ThisFileInfo['playtime_seconds'])) {
                    return round($ThisFileInfo['playtime_seconds']) + 3;
                } else {
                    return 0;
                }
            }
            unlink($filename);

        }

    }

    public function fetchAllImages()
    {
        $res = $this->DatabaseModel->fetchTableData('images', array('userId' => $this->user_id));
        if ($res) {
            $response = array('status' => true, 'data' => $res);
        } else {
            $response = array('status' => false, 'message' => 'Data not found');

        }
        $this->adi->_response($response);
    }
    public function deletedImages()
    {
        $jsonData = file_get_contents("php://input");
        if ($postData = $this->adi->isValidJson($jsonData)) {
            $res = $this->DatabaseModel->deleteRows('images', array('id' => $id, 'userId' => $this->user_id));
            if ($res) {
                $response = array('status' => true, 'message' => 'Image delete successfully.');
            } else {
                $response = array('status' => false, 'message' => 'Image not delete');

            }

        } else {
            $response = array('status' => false, 'message' => 'Invalid json');
        }

        $this->adi->_response($response);
    }

    public function uploadImage()
    {
        if (isset($_FILES['file']['tmp_name'])) {

            $file = $_FILES['file']['tmp_name'];
            $file_type = $_FILES['file']['type'];
            $config['allowed_types'] = '*';
            $config['upload_path'] = './uploads/images';
            $this->load->library('upload', $config);

            $this->upload->initialize($config);

            if (!$this->upload->do_upload('file')) {
                $response['message'] = strip_tags($this->upload->display_errors());
                $response['status'] = false;
            } else {
                $file = $this->upload->data();
                $path = 'uploads/images/' . $file['file_name'];

                $s3url = $this->amazon_manager->s3Upload($path, 'fast-paid/' . $this->user_id . '/' . $file['file_name']);
                $insert['image'] = $s3url;
                $insert['userId'] = $this->user_id;
                $insert['isDeleted'] = 0;
                $insert['created'] = date('Y-m-d H:i:s');
                $insert['status'] = 1;
                $insertId = $this->DatabaseModel->insertData('images', $insert);
                if ($insertId) {
                    $response = array('status' => true, 'message' => 'Image upload successfully.');
                } else {
                    $response = array('status' => false, 'message' => 'Image not upload ');

                }

            }
            $this->adi->_response($response);

        }

    }

    public function changeProfileImage()
    {
        if ($this->input->server('REQUEST_METHOD') == 'POST') {
            $id = $this->user_id;
            $current_profile = $this->DatabaseModel->getField('image', 'users', 'id', $id);
            $name = $_FILES['file']['name'];
            if (!empty($name)) {
                $explode = explode('.', $name);
                $ext = end($explode);
                $tmp_name = $_FILES['file']['tmp_name'];
                $path = 'assets/images/profiles/' . $id . '/';
                $file_name = time() . '.' . $ext;

                if ($ext != 'png' && $ext != 'jpg' && $ext != 'jpeg') {
                    $res = array(
                        'status' => 0,
                        'path' => site_url() . $path . $file_name,
                        'message' => 'Please select valid image',
                    );
                    $this->adi->_response($res, $this->user_id);
                    // echo json_encode($res);
                    die;
                }
                if (!is_dir($path)) {
                    mkdir($path, 0777, true);
                }

                if (move_uploaded_file($tmp_name, $path . $file_name)) {
                    if (file_exists($path . $current_profile) and !empty($current_profile)) {
                        unlink($path . $current_profile);
                    }
                }

                if ($this->DatabaseModel->updateTable('users', array('image' => site_url() . $path . $file_name), array('id' => $id))) {
                    $res = array(
                        'status' => true,
                        'data' => site_url() . $path . $file_name,
                        'message' => 'Profile image updated successfully',
                    );
                    $this->adi->_response($res, $this->user_id);
                }
            }
        }
    }
    public function deleteImages()
    {
        $jsonData = file_get_contents('php://input');
        if ($postData = $this->adi->isValidJson($jsonData)) {
            $id = $postData->id;
            $res = $this->DatabaseModel->deleteRows('images', array('id' => $id, 'userId' => $this->user_id));
            if ($res) {
                $response = array('status' => true, 'message' => ' deleted  successfully.');

            } else {
            }
        } else {
            $response = array('status' => false, 'message' => 'Invalid json.');
        }

        $this->adi->_response($response);
    }
    public function extensionUpload()
    {
        $user_id = $this->input->post('user_id');
        $path = FCPATH . './uploads/' . $user_id . '/videos/';

        if (!is_dir($path)) {
            mkdir($path, 0777, true);
        }
        $filePath = $path . strtotime("now") . '_' . $this->adi->randomPassword() . 'Webstoryreel' . $user_id . time() . '.mp4';

        // path to ~/tmp directory
        $tempName = $_FILES['video-blob']['tmp_name'];

        // move file from ~/tmp to "uploads" directory
        if (!move_uploaded_file($tempName, $filePath)) {
            // failure report
            echo 'Problem saving file: ' . $tempName;
            die();
        }

        $res = array('status' => true, 'message' => 'Video uploaded successfully');
        echo json_encode($res);
    }

}
