<?php

/**
 * @property  passwordencryption passwordencryption
 * @property CI_Upload upload
 */

class UsersController extends CI_Controller
{

    public function __construct()
    {
        parent::__construct();
        $verify_token = $this->jwt_verify->verify_token_2();
        if ($verify_token['status'] != false) {
            $this->user_id = $verify_token['data']['user_id'];
        } else {
            $this->adi->_response($verify_token);
            die();
        }

    }

    public function profile()
    {

        $response = array('status' => false, 'message' => 'Invalid jason');
        $json_data = file_get_contents("php://input");

        if ($post_data = $this->adi->isValidJSON($json_data)) {
            /** change name */
            if (isset($post_data->name)) {
                $data = array(
                    'name' => $post_data->name,
                );

                if ($this->DatabaseModel->updateTable('users', $data, array('id' => $this->user_id))) {
                    $response = array(
                        'status' => true,
                        'code' => 200,
                        'message' => 'Name updated successfully.',
                    );

                }
            } elseif (isset($post_data->password) && isset($post_data->confirm_password)) {

                $old_password = $this->DatabaseModel->getField('password', 'users', 'id', $this->user_id);
                if ($post_data->new_password == $post_data->confirm_password) {
                    $verify_pass = password_verify($post_data->password, $old_password);

                    if ($verify_pass) {
                        $hashed_password = password_hash($post_data->new_password, PASSWORD_DEFAULT);

                        if ($this->DatabaseModel->updateTable('users', array('password' => $hashed_password), array('id' => $this->user_id))) {
                            $response = array(
                                'status' => true,
                                'code' => 200,
                                'message' => 'Password updated successfully.',
                            );
                            $this->DatabaseModel->updateTable('tokens', array('deleted' => 0), array('user_id' => $this->user_id));
                            $email = $this->DatabaseModel->getField('email', 'users', 'id', $this->user_id);
                            $body = $this->load->view('change_password_mail', array(), true);
                            $this->adi->_mail($email, 'Account Password updated |', $body);
                        }
                    } else {
                        $response = array(
                            'status' => false,
                            'message' => 'Your password is invalid',
                        );
                    }

                } else {
                    $response = array(
                        'status' => false,
                        'message' => 'Password did not match',
                    );
                }
            }

        } else {
            $response = array(
                'status' => false,
                'message' => 'Invalid json',
            );

        }
        $this->adi->_response($response, $this->user_id);
    }

    public function changeEmail()
    {
        $response = array('status' => false, 'message' => 'Invalid jason');
        $json_data = file_get_contents("php://input");

        if ($post_data = $this->adi->isValidJSON($json_data)) {
            $email = $post_data->email;
            if ($this->DatabaseModel->exists('users', array('email' => $email))) {
                $response['message'] = 'This user already exists';
                $this->adi->_response($response, $this->user_id);
                die;
            }

            $this->DatabaseModel->insertData('obsolete_email', array(
                'user_id' => $this->user_id,
                'email' => $this->DatabaseModel->getField('email', 'users', 'id', $this->user_id),
            ));
            if (isset($post_data->email) && !empty($post_data->email)) {
                $this->DatabaseModel->updateTable('users', array('email' => $post_data->email), array('id' => $this->user_id));
                $response = array(
                    'status' => true,
                    'message' => 'Email updated successfully',
                );
            } else {
                $response['message'] = 'Please enter valid email address.';
            }

        } else {
            $response = array('status' => false, 'message' => 'Invalid json');
        }
        $this->adi->_response($response, $this->user_id);

    }

    public function disableAccount()
    {

        $this->DatabaseModel->updateTable('users', array('status' => 0), array('id' => $this->user_id));
        $this->DatabaseModel->updateTable('tokens', array('deleted' => 0), array('user_id' => $this->user_id));
        $response = (array('status' => true, 'message' => 'Account disabled successfully'));

        $this->adi->_response($response, $this->user_id);

    }

    public function fetchClientAccount()
    {
        $response = array(
            'status' => true,
            'data' => array(
                'clients' => $this->DatabaseModel->fetchTableData('users', array(
                    'parent' => $this->user_id,
                    'is_client_account' => 1,
                    'deleted' => 0,
                )),
                'team_members' => $this->DatabaseModel->fetchTableData('users', array(
                    'parent' => $this->user_id,
                    'is_virtual_account' => 1,
                    'deleted' => 0,
                )),
                'resellers' => $this->DatabaseModel->fetchTableData('users', array(
                    'parent' => $this->user_id,
                    'is_reseller_account' => 1,
                    'deleted' => 0,
                )),
            ),
        );

        $this->adi->_response($response, $this->user_id);

    }

    public function clientAccount()
    {
        $response = array('status' => false, 'message' => 'Invalid jason');
        $json_data = file_get_contents("php://input");
        if ($post_data = $this->adi->isValidJSON($json_data)) {
            $id = $this->user_id;
            if ($post_data->type == 'client') {
                $no_of_clients = $this->DatabaseModel->countTableData('users', array('parent' => $id, 'is_client_account' => 1));

            } else {
                $no_of_clients = $this->DatabaseModel->countTableData('users', array('parent' => $id, 'is_virtual_account' => 1));
            }
            if ($no_of_clients >= 10) {
                $response['message'] = 'Only 10 accounts are allowed to create';
                $this->adi->_response($response, $this->user_id);

                die();
            }

            if ($this->DatabaseModel->exists('users', array('email' => $post_data->email))) {
                $response['message'] = 'This email already exists';
                $this->adi->_response($response, $this->user_id);

                die();

            }
            $hash = password_hash($post_data->password, PASSWORD_DEFAULT);

            $data = array(
                'name' => $post_data->name,
                'email' => $post_data->email,
                'password' => $hash,
                'registered_by' => $id,
                'image' => base_url() . 'assets/images/profile.png',
                'status' => 1,

            );

            if (isset($post_data->id) && !empty($post_data->id)) {
                $this->DatabaseModel->updateTable('users', $data, array('id' => $post_data->id));
                $response = array(
                    'status' => true,
                    'message' => 'Account added successfully.',
                    'data' => $this->DatabaseModel->countTableData('users', array('parent' => $this->user_id), 'DESC'),
                );
            } else {
                $data['parent'] = $this->user_id;

                if ($post_data->type == 'client') {
                    $parentuserUser = $this->DatabaseModel->fetchTableData('users', array('id' => $this->user_id), 'DESC');

                    $email_data = array(
                        'parent_name' => $parentuserUser[0]->name,
                        'client_name' => $post_data->name,
                        'parent_email' => $parentuserUser[0]->email,
                        'client_email' => $post_data->email,
                        'password' => $post_data->password,
                    );
                    $body = $this->load->view('client_mail', $email_data, true);
                    $bodyParent = $this->load->view('client_parent_mail', $email_data, true);
                    $subject = ' Client Account Credentials';
                    $data['is_client_account'] = 1;
                } else {
                    $data['is_virtual_account'] = 1;
                    $parentuserUser = $this->DatabaseModel->fetchTableData('users', array('id' => $this->user_id), 'DESC');

                    $email_data = array(
                        'parent_name' => $parentuserUser[0]->name,
                        'team_member_name' => $post_data->name,
                        'parent_email' => $parentuserUser[0]->email,
                        'team_member_email' => $post_data->email,
                        'password' => $post_data->password,
                    );
                    $body = $this->load->view('team_member_mail', $email_data, true);
                    $bodyParent = $this->load->view('team_member_parent_mail', $email_data, true);
                    $subject = ' Team Account Credentials';
                }
                $this->DatabaseModel->insertData('users', $data);

                $this->adi->_mail($data['email'], 'welcome', $body);
                $this->adi->_mail($parentuserUser[0]->email, $subject, $bodyParent);

                $response = array(
                    'status' => true,
                    'message' => 'Account added successfully.',
                    'data' => $this->DatabaseModel->countTableData('users', array('parent' => $this->user_id), 'DESC'),
                );
            }
        }
        $this->adi->_response($response, $this->user_id);

        die();

    }

    public function fetchUser()
    {

        $user = $this->DatabaseModel->fetchTableData('users', array('id' => $this->user_id));

        if (!empty($user[0]->membership)) {
            $user = $user;
        } else {
            $parent_user = $this->DatabaseModel->fetchTableData('users', array('id' => $user[0]->parent));

            $user[0]->membership = $parent_user[0]->membership;
            $user[0]->baseCurrency = $parent_user[0]->baseCurrency;

        }
        $user = $user[0];
        unset($user->password);
        unset($user->hash);
        unset($user->password_token);
        $response['status'] = true;
        $response['data'] = $user;
        $this->adi->_response($response, $this->user_id);

    }

    public function editClientAccount()
    {
        $response = array('status' => false, 'message' => 'Invalid jason');
        $json_data = file_get_contents("php://input");
        if ($post_data = $this->adi->isValidJSON($json_data)) {
            $id = $post_data->id;
            $name = $post_data->name;

            if (!empty($id) and !empty($name)) {

                $data = array(
                    'name' => $post_data->name,
                );

                if (isset($post_data->password) and !empty($post_data->password)) {
                    $data['password'] = password_hash($post_data->password, PASSWORD_DEFAULT);

                }

                if ($this->DatabaseModel->updateTable('users', $data, array('id' => $id))) {

                    $response = array(
                        'status' => true,
                        'message' => 'Account updated Successfully',
                    );

                } else {
                    $response['message'] = 'Something went wrong, Please try again';
                }

            } else {
                $response['message'] = 'Missing Required Parameters';
            }

        }
        $this->adi->_response($response, $this->user_id);

        die();
    }

    public function deleteRowsClient()
    {
        $response = array('status' => false, 'message' => 'Invalid jason');
        $json_data = file_get_contents("php://input");
        if ($post_data = $this->adi->isValidJSON($json_data)) {
            $data = $this->DatabaseModel->updateTable('users', array('is_client_account' => 0), array('id' => $post_data->client_id));
            $response = array('status' => true, 'message' => 'Account deleted successfully');
        }
        $this->adi->_response($response, $this->user_id);

    }

    public function downloadAllData()
    {
        $base_url = base_url();
        if (file_exists(FCPATH . 'assets/media/' . $this->user_id . '/download_data/user_data_bizbookpay.zip')) {
            unlink(FCPATH . 'assets/media/' . $this->user_id . '/download_data/user_data_bizbookpay.zip');
        }
        if (!file_exists('assets/media/' . $this->user_id . '/download_data')) {
            mkdir('assets/media/' . $this->user_id . '/download_data', 0777, true);
        }

        $user_details = $this->DatabaseModel->fetchTableData('users', array('id' => $this->user_id));

        $user_CSV[0] = array('Personal Data');
        $user_CSV[1] = array('Name', 'Email', 'Created');
        if ($user_details != 0) {
            $user_CSV[2] = array($user_details[0]->name, $user_details[0]->email, $user_details[0]->created);
        }

        $fp = fopen(FCPATH . 'assets/media/' . $this->user_id . '/download_data/records.csv', 'w');
        foreach ($user_CSV as $line) {
            fputcsv($fp, $line, ',');
        }
        fclose($fp);

        // Client Account
        $client_details = $this->DatabaseModel->fetchTableData('users', array('status' => 1, 'deleted' => 0, 'is_client_account' => 1, 'parent' => $this->user_id));

        if (!empty($client_details)) {
            $client_CSV[0] = array('client Data');
            $client_CSV[1] = array('Name', 'Email', 'Created');
            $c = 2;
            foreach ($client_details as $clientAccount) {
                $client_CSV[$c] = array($clientAccount->name, $clientAccount->email, $clientAccount->created);
                $c++;
            }
            $fp = fopen(FCPATH . 'assets/media/' . $this->user_id . '/download_data/client.csv', 'w');
            foreach ($client_CSV as $line) {
                fputcsv($fp, $line, ',');
            }
            fclose($fp);
        }
        //print_r($client_details);exit;
        // Team Account
        $team_details = $this->DatabaseModel->fetchTableData('users', array('status' => 1, 'deleted' => 0, 'is_virtual_account' => 1, 'parent' => $this->user_id));
        $team_CSV = array();

        if (!empty($team_details)) {

            $team_CSV[0] = array('Team Data');
            $team_CSV[1] = array('Name', 'Email', 'Created');
            $t = 2;
            foreach ($team_details as $teamAccount) {
                $team_CSV[$t] = array($teamAccount->name, $teamAccount->email, $teamAccount->created);
                $t++;
            }
            $fp = fopen(FCPATH . 'assets/media/' . $this->user_id . '/download_data/team.csv', 'w');
            foreach ($team_CSV as $line) {
                fputcsv($fp, $line, ',');
            }
            fclose($fp);
        }

        // reseller Account
        $reseller_details = $this->DatabaseModel->fetchTableData('users', array('status' => 1, 'deleted' => 0, 'is_reseller_account' => 1, 'parent' => $this->user_id));

        if (!empty($reseller_details)) {
            $reseller_CSV[0] = array('Reseller Data');
            $reseller_CSV[1] = array('Name', 'Email', 'Created');
            $r = 2;
            foreach ($reseller_details as $resellerAccount) {
                $reseller_CSV[$r] = array($resellerAccount->name, $resellerAccount->email, $resellerAccount->created);
                $r++;
            }
            $fp = fopen(FCPATH . 'assets/media/' . $this->user_id . '/download_data/reseller.csv', 'w');
            foreach ($team_CSV as $line) {
                fputcsv($fp, $line, ',');
            }
            fclose($fp);
        }

        //$user_story = $this->DatabaseModel->countTableData('videos', array('user_id' =>$this->user_id));
        $user_story = array();
        $story_CSV[0] = array('Title', 'Url', 'size', 'Status', 'Created', 'Modified');
        if (!empty($user_story)) {
            $i = 1;
            foreach ($user_story as $storyGet) {
                $story_CSV[$i] = array($storyGet['name'], $storyGet['url'], $storyGet['size'], $storyGet['status'], $storyGet['created'], $storyGet['modified']);
                $i++;
            }
            $fp = fopen(FCPATH . 'assets/media/' . $this->user_id . '/download_data/clipesreel.csv', 'w');
            foreach ($story_CSV as $line) {
                fputcsv($fp, $line, ',');
            }
            fclose($fp);

        }

        // Social Account
        // $social_details = $this->DatabaseModel->fetchTableData('social_accounts', array('user_id' => $this->user_id));

        // $social[0] = array('Title', 'Type', 'Category', 'Created');
        // if (!empty($social_details)) {
        //     $i = 1;
        //     foreach ($social_details as $socialGet) {
        //         $social[$i] = array($socialGet->title, $socialGet->type, $socialGet->category, $socialGet->created);
        //         $i++;
        //     }
        //     $fp = fopen(FCPATH . 'assets/media/' . $this->user_id . '/download_data/social_account.csv', 'w');
        //     foreach ($social as $line) {
        //         fputcsv($fp, $line, ',');
        //     }
        //     fclose($fp);

        // }

        // Integration  Application
        // $integrationsData = $this->DatabaseModel->fetchTableData('Integration', array('userId' => $this->user_id));
        // $integrations_CSV[0] = array('Username', 'Email', 'App Name', 'Created');
        // if (!empty($integrationsData)) {
        //     $i = 1;
        //     foreach ($integrationsData as $integrationsGet) {

        //         $integrations_CSV[$i] = array($integrationsGet->name, $integrationsGet->created);
        //         $i++;
        //     }
        //     $fp = fopen(FCPATH . 'assets/media/' . $this->user_id . '/download_data/integration_application.csv', 'w');
        //     foreach ($integrations_CSV as $line) {
        //         fputcsv($fp, $line, ',');
        //     }
        //     fclose($fp);

        // }

        $check = $this->zip_the_file('assets/media/' . $this->user_id . '/download_data', 'assets/media/' . $this->user_id . '/download_data/user_data_bizbookpay.zip');

        if ($check == true) {
            $this->adi->_response(array('status' => true, 'file' => $base_url . 'assets/media/' . $this->user_id . '/download_data/user_data_bizbookpay.zip'), $this->user_id);

        } else {
            print_r('Files could not be generated. Try again');
        }

    }

    public function zip_the_file($source, $destination)
    {
        if (!extension_loaded('zip') || !file_exists($source)) {
            return false;
        }
        $zip = new ZipArchive();
        if (!$zip->open($destination, ZIPARCHIVE::CREATE)) {
            return false;
        }
        $source = str_replace('\\', '/', realpath($source));
        if (is_dir($source) === true) {
            $files = new RecursiveIteratorIterator(new RecursiveDirectoryIterator($source), RecursiveIteratorIterator::SELF_FIRST);
            foreach ($files as $file) {
                $file = str_replace('\\', '/', $file);
                // Ignore "." and ".." folders
                if (in_array(substr($file, strrpos($file, '/') + 1), array('.', '..'))) {
                    continue;
                }

                $file = realpath($file);
                if (is_dir($file) === true) {
                    $zip->addEmptyDir(str_replace($source . '/', '', $file . '/'));
                } else if (is_file($file) === true) {
                    $zip->addFromString(str_replace($source . '/', '', $file), file_get_contents($file));
                }
            }
        } else if (is_file($source) === true) {
            $zip->addFromString(basename($source), file_get_contents($source));
        }
        return $zip->close();
    }

    public function reseller()
    {

        $response = array('status' => false, 'message' => 'Invalid jason');
        $json_data = file_get_contents("php://input");

        if ($post_data = $this->adi->isValidJSON($json_data)) {
            $user_id = $post_data->user_id;
            $allowed_clients = 50;
            $no_of_clients = $this->DatabaseModel->countTableData('users', array('parent' => $user_id, 'is_reseller_account' => 1, 'deleted' => 0));

            if ($no_of_clients >= $allowed_clients) {
                $response['message'] = 'You are allowed to create upto 50 accounts';
                $this->adi->_response($response, $this->user_id);

            }

            if ($this->DatabaseModel->exists('users', array('email' => $post_data->email))) {
                $response['message'] = 'This email is already exists.';
                $this->adi->_response($response, $this->user_id);

            }

            $password = password_hash($post_data->password, PASSWORD_DEFAULT);
            $data = array(
                'name' => $post_data->name,
                'parent' => $this->user_id,
                'email' => $post_data->email,
                'image' => site_url('assets/images/profiles/default.png'),
                'membership' => '',
                'password' => $password,
                'registered_by' => $this->user_id,
                'status' => 1,
                'is_reseller_account' => 1,
            );

            if ($this->DatabaseModel->insertData('users', $data)) {
                $d = array('username' => $post_data->email, 'password' => $password);
                $body = $this->load->view('welcome_mail', $d, true);
                $this->adi->_mail($post_data->email, '[IMPORTANT] Your ', ' Account Details.', $body);
                $response = array(
                    'status' => true,
                    'message' => 'Reseller account created successfully.',
                );
            }
        }

        $this->adi->_response($response, $this->user_id);

    }

    public function deleteRowsResellerAccount()
    {
        $response = array('status' => false, 'message' => 'Invalid jason');
        $json_data = file_get_contents("php://input");

        if ($post_data = $this->adi->isValidJSON($json_data)) {
            if (!isset($post_data->id) || empty($post_data->id)) {
                $response['message'] = 'id is missing or empty';
            } else {
                $this->DatabaseModel->updateTable('users', array('deleted' => 1), array('id' => $post_data->id, 'parent' => $this->user_id));
                $response = array(
                    'status' => true,
                    'message' => 'Account deleted successfully.',
                );
            }
        }

        $this->adi->_response($response, $this->user_id);

    }

    public function deleteAccount()
    {
        $dl = $this->DatabaseModel->updateTable('users', array('deleted' => 1), array('id' => $this->user_id));

        $this->DatabaseModel->updateTable('tokens', array('deleted' => 0), array('user_id' => $this->user_id));
        $this->adi->_response(array('status' => true, 'message' => 'Account deleted successfully'), $this->user_id);

    }

    public function deleteClient()
    {
        $response = array('status' => false, 'message' => 'Invalid json');
        $json_data = file_get_contents("php://input");
        if ($post_data = $this->adi->isValidJson($json_data)) {

            $this->DatabaseModel->updateTable('users', array('deleted' => 1), array('id' => $post_data->client_id));
            $response = array('status' => true, 'message' => 'Account deleted successfully');
        }
        $this->adi->_response($response);

    }

    public function fetchResellerAccounts()
    {
        $user_id = $this->input->post('user_id');
        $accounts = $this->DatabaseModel->fetchTableData('users', array('parent' => $user_id, 'is_client_account' => 0, 'is_virtual_account' => 0, 'deleted' => 0));
        foreach ($accounts as $key => $account) {
            unset($accounts[0]->password);
        }
        $response = array('status' => true, 'accounts' => $accounts);
        $this->adi->_response($response, $this->user_id);

    }

    public function editReseller()
    {
        $response = array('status' => false, 'message' => 'Invalid jason');
        $json_data = file_get_contents("php://input");

        if ($post_data = $this->adi->isValidJSON($json_data)) {
            /** change name */
            if (!isset($post_data->id) || empty($post_data->id)) {
                $response['message'] = 'missing id parameter';
                $this->adi->_response($response, $this->user_id);

            }
            if (isset($post_data->name)) {
                $data = array(
                    'name' => $post_data->name,
                );

                if ($this->DatabaseModel->updateTable('users', $data, array('id' => $post_data->id, 'parent' => $this->user_id))) {
                    $response = array(
                        'status' => true,
                        'message' => 'Profile updated successfully.',
                    );
                } else {
                    $response = array(
                        'status' => false,
                        'message' => 'Id not exist, Please use Other name.',
                    );

                }
            }
            /** change password */
            if (isset($post_data->password) and !empty($post_data->password)) {

                $old_password = $this->DatabaseModel->getField('password', 'users', 'id', $this->user_id);

                $verify_pass = password_verify($post_data->password, $old_password);

                if ($verify_pass) {
                    $hashed_password = password_hash($post_data->new_password, PASSWORD_DEFAULT);

                    if ($this->DatabaseModel->updateTable('users', array('password' => $hashed_password), array('id' => $this->user_id))) {
                        $response = array(
                            'status' => true,
                            'code' => 200,
                            'message' => 'Password updated successfully.',
                        );

                    }
                } else {
                    $response = array(
                        'status' => false,
                        'message' => 'Your password is invalid.',
                    );
                }

            } elseif (isset($post_data->email)) {
                if ($this->DatabaseModel->exists('users', array('email' => $post_data->email))) {
                    $response['message'] = 'This email is already exists.';
                    $this->adi->_response($response, $this->user_id);

                }
                $this->DatabaseModel->updateTable('users', array('email' => $post_data->email),
                    array('id' => $post_data->id, 'parent' => $this->user_id));
                $response = array('status' => true, 'message' => 'email updated successfully.');
            }
        }
        $this->adi->_response($response, $this->user_id);

    }

    public function WLRebranding()
    {
        $response = array('status' => false, 'message' => 'Invalid json');
        if ($this->input->server('REQUEST_METHOD') == 'POST') {
            $post_data = $this->input->post();
            if (!isset($post_data['name'])) {
                $response['message'] = 'Please give a brand name.';
            } else {
                $config['upload_path'] = 'assets/media/' . $this->user_id . '/images/';
                $config['allowed_types'] = 'png|jpg|jpeg';
                $config['max_size'] = 5000;
                $config['file_name'] = time() . '_' . str_shuffle(time()) . '_' . $this->user_id;
                if (!is_dir($config['upload_path'])) {
                    mkdir($config['upload_path'], 0777, true);
                }
                $this->load->library('upload', $config);
                $this->upload->initialize($config);

                if ($this->upload->do_upload('logo')) {
                    $upload_data = $this->upload->data();
                    $url = str_replace(FCPATH, site_url(), $upload_data['full_path']);

                    $data = array(
                        'name' => $post_data['name'],
                        'logo' => $url,
                    );

                    if (isset($post_data['id']) && !empty($post_data['id'])) {
                        $this->DatabaseModel->updateTable('wl_rebranding', $data, array('id' => $post_data['id'], 'userId' => $this->user_id));
                        $response = array(
                            'status' => true,
                            'message' => 'You have successfully updated your branding details.',
                        );
                    } else {
                        $data['userId'] = $this->user_id;
                        $this->DatabaseModel->insertData('wl_rebranding', $data);
                        $response = array(
                            'status' => true,
                            'message' => 'Your have successfully saved your branding details.',
                        );
                    }
                } else {
                    $response['message'] = strip_tags($this->upload->display_errors());
                }
            }
            $this->adi->_response($response, $this->user_id);

        }
    }

    public function deleteWL()
    {
        $response = array('status' => false, 'message' => 'Invalid json');
        $json_data = file_get_contents("php://input");
        if ($post_data = $this->adi->isValidJSON($json_data)) {
            if (!isset($post_data->id) || empty($post_data->id)) {
                $response['message'] = "required parameter id is missing";
            } else {
                $this->DatabaseModel->updateTable('wl_rebranding', array('deleted' => 1), array('userId' => $this->user_id));
                $response = array(
                    'status' => true,
                    'message' => 'Your branding details deleted successfully.',
                );
            }
        }
        $this->adi->_response($response, $this->user_id);

    }

    public function fetchWLRebranding()
    {
        $user = $this->DatabaseModel->fetchTableData('users', array('id' => $this->user_id, 'deleted' => 0), 'desc');
        if ($user[0]->is_client_account == 1 || $user[0]->is_virtual_account == 1) {
            $wl = $this->DatabaseModel->fetchTableData('wl_rebranding', array('userId' => $user[0]->registered_by, 'deleted' => 0), 'desc');
            if (!empty($wl)) {
                $response = array(
                    'status' => true,
                    'data' => $wl[0],
                );
            } else {
                $response = array(
                    'status' => false,
                    'message' => "You don't have any rebranding yet.",
                );
            }
            $this->adi->_response($response, $this->user_id);

        } elseif (is_numeric($user[0]->registered_by) && !empty($user[0]->registered_by)) {
            $wl = $this->DatabaseModel->fetchTableData('wl_rebranding', array('userId' => $user[0]->registered_by, 'deleted' => 0), 'desc');
            if (!empty($wl)) {
                $response = array(
                    'status' => true,
                    'data' => $wl[0],
                );
            } else {
                $response = array(
                    'status' => false,
                    'message' => "You don't have any rebranding yet.
                    ",
                );
            }
            $this->adi->_response($response, $this->user_id);
        } else {
            $wl = $this->DatabaseModel->fetchTableData('wl_rebranding', array('userId' => $this->user_id, 'deleted' => 0), 'desc');
            if (!empty($wl)) {
                $response = array(
                    'status' => true,
                    'data' => $wl[0],
                );
            } else {
                $response = array(
                    'status' => false,
                    'message' => "you don't have any rebranding yet",
                );
            }
            $this->adi->_response($response, $this->user_id);

        }

    }
}
