<?php

use TBETool\PasswordGenerator;

/**
 * @property DatabaseModel DatabaseModel
 * @property Passwordencryption passwordencryption
 * @property CI_Email email
 */

class SuperAdminController extends CI_Controller
{

    private $secret_key = '(H+MbQeShVmYq3t6';
    public function __construct()
    {
        parent::__construct();
        $this->load->model('DatabaseModel');
        $this->load->library('passwordencryption');
        $this->load->library('encryption');

    }

    public function fetchUsers()
    {
        $json_data = file_get_contents("php://input");
        if (isset($json_data) and !empty($json_data)) {

            $check_response = $this->isValidJson($json_data);
            if ($check_response != false) {

                $get_key = $check_response->secret_key;

                if (!empty($get_key)) {

                    if ($this->secret_key == $get_key) {

                        $totalUsers = $this->DatabaseModel->fetchTableData('users');
                        $activeUsers = $this->DatabaseModel->fetchTableData('users');
                        $disableUsers = $this->DatabaseModel->fetchTableData('users', array('status' => 0));
                         $clientUsers = $this->DatabaseModel->fetchTableData('users', array('is_client_account' => 1));
                        $teamUsers = $this->DatabaseModel->fetchTableData('users', array('is_virtual_account' => 1));
                        $totalIntegrations = $this->DatabaseModel->fetchTableData('integration', array('status' => 1));

                         $total_products = $this->DatabaseModel->fetchTableData('business', array('status' => 1));
                        $total_bussiness= $this->DatabaseModel->fetchTableData('product', array('productStatus' => 1));
                       

                        $membership_levels = $this->DatabaseModel->fetchTableData('membership_levels');
                        
                        if (!empty($membership_levels)) {
                            $membershiparr = array();
                            foreach ($membership_levels as $key => $level) {
                                $dataArr = array(
                                    'id' => $level->id,
                                    'title' => $level->title,
                                    'name' => $level->name,
                                );

                                $membershiparr[] = $dataArr;
                            }
                        }

                        if (!empty($totalUsers)) {
                            $responseArray = array();
                            foreach ($totalUsers as $key => $users) {
                                // dd($users);
                                $profile = 'https://webstoriesbackend.storyreel.io/assets/images/profile.png';
                                if ($users->image != null and
                                    file_exists(FCPATH . 'assets/images/profiles/' . $users->id . '/' . $users->image)) {
                                    $profile = 'https://webstoriesbackend.storyreel.io/assets/images/profiles/' . $users->id . '/' . $users->image;

                                }
                                $user_type = 2;
                                if ($users->is_client_account == 1) {
                                    $user_type = 4;
                                } elseif ($users->is_virtual_account == 1) {
                                    $user_type = 3;
                                } elseif ($users->is_super_admin == 1) {
                                    $user_type = 1;
                                }

                                $data = array(
                                    'name' => $users->name,
                                    'email' => $users->email,
                                    'profile_image' => $profile,
                                    'register_by' => $users->registered_by,
                                    'type' => $users->membership,
                                    'is_client_account' => $users->is_client_account,
                                    'is_virtual_account' => $users->is_virtual_account,
                                    'status' => $users->status,
                                    'is_admin' => $users->is_super_admin,
                                    // 'is_trial' => $users->is_trial,
                                    'deleted' => $users->deleted,
                                    'created' => $users->created,
                                    'parent' => 0,
                                    'modified' => $users->created,
                                    'user_id' => $users->id,
                                    'user_type' => $user_type,
                                );
                                
                                $responseArray[] = $data;
                                // dd($data);
                            }
                           
                            $response['status'] = true;
                            $response['data']['users'] = $responseArray;
                            
                            $response['data']['total_users'] = count($totalUsers);
                            $response['data']['active_users'] = count($activeUsers);
                            $response['data']['disabled_users'] = count($disableUsers);
                            $response['data']['client_users'] = count($clientUsers);
                            $response['data']['team_users'] = count($teamUsers);
                           
                            $response['data']['total_products'] = count($total_products);
                            $response['data']['total_bussiness'] = count($total_bussiness);
                            
                             $response['data']['integrations'] = count($totalIntegrations);
                            $response['data']['membership_levels'] = array_reverse($membership_levels);
                        
                        } else {
                            $response['status'] = false;
                            $response['message'] = 'No Users data found';
                        }

                    } else {
                        $response['status'] = false;
                        $response['message'] = 'Invalid secret key';
                    }

                } else {
                    $response['status'] = false;
                    $response['message'] = 'Empty Secret Key';
                }

            } else {
                $response['status'] = false;
                $response['message'] = 'Invalid JSON Data';
            }

        } else {
            $response['status'] = false;
            $response['message'] = 'Empty JSON Data';
        }
        $this->adi->_response($response, $this->user_id);die;
    }

    public function addUser()
    {
        $json_data = file_get_contents("php://input");

        if (isset($json_data) and !empty($json_data)) {

            $check_response = $this->isValidJson($json_data);
            if ($check_response != false) {

                $name = $check_response->name;
                $email = $check_response->email;
                $password = $check_response->password;
                $user_type = $check_response->user_type;
                $get_keys = $check_response->secret_key;
     
                if (!empty($name) and !empty($email) and !empty($password) and !empty($get_keys)) {
                    

                    if ($this->secret_key == $get_keys) {
                       
                        /**
                         * Check user is disable or deleted
                         */
                        $checkuserisdelete = $this->DatabaseModel->exists('users', array('email' => $email, 'deleted' => 1));
                        if ($checkuserisdelete) {
                            $data['status'] = false;
                            $data['message'] = 'Requested user already exists and marked as deleted';
                            echo json_encode($data);
                            die();
                        }

                        $checkuserisdisable = $this->DatabaseModel->exists('users', array('email' => $email, 'status' => 0));
                        

                        if ($checkuserisdisable) {
                            $data['status'] = false;
                            $data['message'] = 'Requested user already exists and marked as disable';
                            echo json_encode($data);
                            die();
                        }

                        $Password_hash = password_hash($password, PASSWORD_DEFAULT);
                      
                        /**
                         * Check User exists or not
                         */
                        if (!$this->DatabaseModel->exists('users', array('email' => $email))) {
                           
                            $data_arr = array(
                                'name' => $name,
                                'email' => $email,
                                'password' => $Password_hash,
                                'status' => 1,
                                'image' => 'https://webstoriesbackend.storyreel.io/assets/images/profile.png',
                                'registered_by' => 'Super Admin',
                            );
 
                            /** Check user account type */
                            if ($user_type == 1) {
                                $data_arr['is_super_admin'] = 1;
                            } elseif ($user_type == 3) {
                                $data_arr['is_virtual_account'] = 1;
                            } elseif ($user_type == 4) {
                                $data_arr['is_client_account'] = 1;
                            }
                            // dd($check_response);

                            /** Add users membership levels */
                            $type = $check_response->membership; //  get json data membership
                            
                            if (('bundle' == $type)) {
                                
                                $data_arr['membership'] = "premium__unlimited__unlimitedlite__professional__professionallite__dfy__business__playerneos__koincart__bundle";

                            } else {
                                if ((count($type)) == 1) {
                                    $account_type = $type[0];
                                    $data_arr['membership'] = $account_type;
                                } else {
                                    $account_type = implode("__", $type);
                                    $data_arr['membership'] = $account_type;
                                }
                            }
                           
                            if ($id = $this->DatabaseModel->insertData('users', $data_arr)) {
                            
                                /* Send Email for register user
                                 */

                                if ($check_response->email == true) {
                                    $d = array('username' => $check_response->email, 'password' => $check_response->password);
                                    $body = $this->load->view('welcome_mail', $d, true);
                                    $this->mailer->send_mail($email, 'Ragistered', $body);
                                }

                                /**
                                 * Add Email to GR
                                 */
                                if ($check_response->email == true) {
                                    $this->curl_post_request($name, $email);
                                }

                                /** Return Users Data in Response */
                                $totalUsers = $this->DatabaseModel->fetchTableData('users');
                                $active_users = $this->DatabaseModel->fetchTableData('users', array('status' => 1));
                                $disable_users = $this->DatabaseModel->fetchTableData('users', array('status' => 0));
                                 
                                if (!empty($totalUsers)) {

                                    $responseArray = array();
                                    foreach ($totalUsers as $user) {
                                        // dd($user);
                                        $tmp_arr = array(
                                            'name' => $user->name,
                                            'email' => $user->email,
                                            'image' => $user->image,
                                            'register_by' => $user->registered_by,
                                            'account_tag' => $user->account_tag,
                                            'type' => $user->membership,
                                            'is_client_account' => $user->is_client_account,
                                            'is_virtual_account' => $user->is_virtual_account,
                                            'status' => $user->status,
                                            'is_admin' => $user->is_super_admin,
                                            'is_trial' => '',
                                            'deleted' => $user->deleted,
                                            'created' => $user->created,
                                            'user_id' => $user->id,
                                        );

                                        $tmp_arr['user_type'] = 2;
                                        if ($user->is_client_account == 1) {
                                            $tmp_arr['user_type'] = 4;
                                        } elseif ($user->is_virtual_account == 1) {
                                            $tmp_arr['user_type'] = 3;
                                        } elseif ($user->is_super_admin == 1) {
                                            $tmp_arr['user_type'] = 1;
                                        }

                                        $responseArray[] = $tmp_arr;
                                    }

                                    $data['status'] = true;
                                    $data['data']['users'] = $responseArray;
                                    $data['data']['total_users'] = count($totalUsers);
                                    $data['data']['active_users'] = $active_users;
                                    $data['data']['disabled_users'] = $disable_users;
                                    $data['message'] = 'Requested user created successfully';

                                } else {
                                    $data['status'] = false;
                                    $data['message'] = 'No records found!';
                                }

                            } else {
                                $data['status'] = false;
                                $data['message'] = 'Something went wrong, Please try again';
                            }

                        } else {
                            $data['status'] = false;
                            $data['message'] = 'User Already Exists';
                        }

                    } else {
                        $data['status'] = false;
                        $data['message'] = 'Invalid Secret Key';
                    }

                } else {
                    $data['status'] = false;
                    $data['message'] = 'Missing Required Parameters';
                }

            } else {
                $data['status'] = false;
                $data['message'] = 'Invalid JSON Data';
            }

        } else {
            $data['status'] = false;
            $data['message'] = 'Empty JSON Data';
        }

        $this->adi->_response($data);die;

    }

    public function fetchUser()
    {
        $json_data = file_get_contents("php://input");

        if (isset($json_data) and !empty($json_data)) {

            $check_response = $this->isValidJson($json_data);
            if ($check_response != false) {
                $user_id = $check_response->id;
                $get_key = $check_response->secret_key;

                if (!empty($user_id) and !empty($get_key)) {

                    if ($this->secret_key == $get_key) {

                        $user = $this->DatabaseModel->fetchTableData('users', array('id' => $user_id));
                        // dd($user);
                        if (!empty($user)) {

                            $responseArray = array();
                            foreach ($user as $value) {
                                // dd($value);
                                $tmp_arr = array(
                                    'name' => $value->name,
                                    'email' => $value->email,
                                    'image' => $value->image,
                                    'register_by' => $value->registered_by,
                                    'account_tag' => '',
                                    'account_type' => $value->membership,
                                    'is_client_account' => $value->is_client_account,
                                    'is_virtual_account' => $value->is_virtual_account,
                                    'status' => $value->status,
                                    'is_trial' => '',
                                    'deleted' => $value->deleted,
                                    'created' => $value->created,
                                    'user_id' => $value->id,
                                    'parent' => $this->DatabaseModel->fetchTableData('users', $value->parent),
                                    'login-logs' => $this->DatabaseModel->fetchTableData('user_logs', array('id' => $user_id)),
                                    'user-activities' => $this->DatabaseModel->fetchTableData('user_activities', array('user_id' => $user_id)),
                                );

                                $tmp_arr['account_tag'] = 2;
                                // dd($tmp_arr);
                                if ($value->is_client_account == 1) {
                                    $tmp_arr['account_tag'] = 4;
                                } elseif ($value->is_virtual_account == 1) {
                                    $tmp_arr['account_tag'] = 3;
                                } elseif ($value->is_super_admin == 1) {
                                    $tmp_arr['account_tag'] = 1;
                                }

                                $responseArray[] = $tmp_arr;
                            }

                            $data['status'] = true;
                            $data['data'] = $responseArray;

                        } else {
                            $data['status'] = false;
                            $data['message'] = 'No records found';
                        }

                    } else {
                        $data['status'] = false;
                        $data['message'] = 'Invalid Secret Key';
                    }

                } else {
                    $data['status'] = false;
                    $data['message'] = 'Missing Required Parameters';
                }

            } else {
                $data['status'] = false;
                $data['message'] = 'Invalid JSON Data';
            }

        } else {
            $data['status'] = false;
            $data['message'] = 'Empty JSON Data';
        }

        $this->adi->_response($data);die;
    }

  public function deleteUser()
    {
        $json_data = file_get_contents("php://input");

        if (isset($json_data) and !empty($json_data)) {

            $check_response = $this->isValidJson($json_data);
            if ($check_response != false) {

                $user_id = $check_response->id;
                $get_key = $check_response->secret_key;
                $deleted = $check_response->deleted;

                if (!empty($user_id) and !empty($get_key)) {

                    if ($this->secret_key == $get_key) {

                        if ($this->DatabaseModel->updateTable('users', array('deleted' => $deleted), array('id' => $user_id))) {

                            $data['status'] = true;
                            $data['message'] = 'Account Deleted Successfully';

                            if ($deleted == 0) {
                                $data['message'] = 'Account Activated Successfully';
                            } else {

                                /** Delete Token */
                                $this->DatabaseModel->updateTable('tokens', array('deleted' => 1), array('id' => $user_id));
                            }

                        } else {
                            $data['status'] = false;
                            $data['message'] = 'Something went wrong, Please try again';
                        }

                    } else {
                        $data['status'] = false;
                        $data['message'] = 'Invalid Secret Key';
                    }

                } else {
                    $data['status'] = false;
                    $data['message'] = 'Missing Required Parameters';
                }

            } else {
                $data['status'] = false;
                $data['message'] = 'Invalid JSON Data';
            }

        } else {
            $data['status'] = false;
            $data['message'] = 'Empty JSON Data';
        }

        $this->adi->_response($data);die;

    }

    public function disableUser()
    {
        $json_data = file_get_contents("php://input");

        if (isset($json_data) and !empty($json_data)) {

            $check_response = $this->isValidJson($json_data);
            if ($check_response != false) {

                $user_id = $check_response->id;
                $get_key = $check_response->secret_key;
                $status = $check_response->status;

                if (!empty($user_id) and !empty($get_key)) {

                    if ($this->secret_key == $get_key) {

                        if ($this->DatabaseModel->updateTable('users', array('status' => $status), array('id' => $user_id))) {

                            $data['status'] = true;
                            $data['message'] = 'Account Enable Successfully';

                            if ($status == 0) {
                                $data['message'] = 'Account Disable Successfully';

                                /** Disable Token */
                                $this->DatabaseModel->updateTable('tokens', array('deleted' => 1), array('id' => $user_id));
                            }

                        } else {
                            $data['status'] = false;
                            $data['message'] = 'Something went wrong, Please try again';
                        }

                    } else {
                        $data['status'] = false;
                        $data['message'] = 'Invalid Secret Key';
                    }

                } else {
                    $data['status'] = false;
                    $data['message'] = 'Missing Required Parameters';
                }

            } else {
                $data['status'] = false;
                $data['message'] = 'Invalid JSON Data';
            }

        } else {
            $data['status'] = false;
            $data['message'] = 'Empty JSON Data';
        }

        $this->adi->_response($data);die;

    }

    public function updatePassword()
    {
        $json_data = file_get_contents("php://input");

        if (isset($json_data) and !empty($json_data)) {

            $check_response = $this->isValidJson($json_data);
            if ($check_response != false) {

                $user_id = $check_response->id;
                $password = $check_response->password;
                $confirm_password = $check_response->confirm_password;
                $get_key = $check_response->secret_key;

                if (!empty($password) and !empty($confirm_password) and !empty($get_key) and !empty($user_id)) {

                    if ($this->secret_key == $get_key) {

                        if ($password == $confirm_password) {

                            $data_arr = array(
                                'password' => password_hash($password, PASSWORD_DEFAULT),
                            );

                            if ($this->DatabaseModel->updateTable('users', $data_arr, array('id' => $user_id))) {

                                $data['status'] = true;
                                $data['message'] = 'Password updated Successfully';

                            } else {
                                $data['status'] = false;
                                $data['message'] = 'Something went wrong, Please try again';
                            }

                        } else {
                            $data['status'] = false;
                            $data['message'] = 'Password did not matched';
                        }

                    } else {
                        $data['status'] = false;
                        $data['message'] = 'Invalid Secret Key';
                    }

                } else {
                    $data['status'] = false;
                    $data['message'] = 'Missing Required Parameters';
                }

            } else {
                $data['status'] = false;
                $data['message'] = 'Invalid JSON Data';
            }

        } else {
            $data['status'] = false;
            $data['message'] = 'Empty JSON Data';
        }

        $this->adi->_response($data);die;

    }

    public function updateEmail()
    {
        $json_data = file_get_contents("php://input");

        if (isset($json_data) and !empty($json_data)) {

            $check_response = $this->isValidJson($json_data);
            if ($check_response != false) {

                $user_id = $check_response->id;
                $email = $check_response->email;
                $get_key = $check_response->secret_key;

                if (!empty($user_id) and !empty($email) and !empty($get_key)) {

                    if ($this->secret_key == $get_key) {

                        if (!$this->DatabaseModel->fetchTableData('users', array('email' => $email))) {

                            if ($this->DatabaseModel->updateTable('users', array('email' => $email), array('id' => $user_id))) {

                                $data['status'] = true;
                                $data['data'] = $email;
                                $data['message'] = 'Email Updated Successfully';

                            } else {
                                $data['status'] = false;
                                $data['message'] = 'Something went wrong, Please try again';
                            }

                        } else {
                            $data['status'] = false;
                            $data['message'] = 'Email Already Exists';
                        }

                    } else {
                        $data['status'] = false;
                        $data['message'] = 'Invalid Secret Key';
                    }

                } else {
                    $data['status'] = false;
                    $data['message'] = 'Missing Required Parameters';
                }

            } else {
                $data['status'] = false;
                $data['message'] = 'Invalid JSON Data';
            }

        } else {
            $data['status'] = false;
            $data['message'] = 'Empty JSON Data';
        }
        $this->adi->_response($data);die;

    }

    public function checkUser()
    {
        $json_data = file_get_contents("php://input");

        if (isset($json_data) and !empty($json_data)) {

            $check_response = $this->isValidJson($json_data);
            if ($check_response != false) {

                $email = $check_response->email;
                $secret_key = $check_response->secret_key;

                if (!empty($email) and !empty($secret_key)) {

                    /**
                     * Check user is disable or deleted
                     */
                    $checkuserisdelete = $this->DatabaseModel->fetchTableData('users', array('email' => $email, 'deleted' => 1));
                    // dd($checkuserisdelete);
                    if ($checkuserisdelete) {
                        $data['status'] = false;
                        $data['message'] = 'Requested user already exists and marked as deleted';
                        echo json_encode($data);
                        die();
                    }

                    $checkuserisdisable = $this->DatabaseModel->fetchTableData('users', array('email' => $email, 'status' => 0));
                    // dd($checkuserisdisable);
                    if ($checkuserisdisable) {
                        $data['status'] = false;
                        $data['message'] = 'Requested user already exists and marked as disable';
                        echo json_encode($data);
                        die();
                    }

                    /**
                     * Check User Exists
                     */
                    $checkUser = $this->DatabaseModel->fetchTableData('users', array('email' => $email));
                    if (!empty($checkUser)) {

                        $responseArray = array();
                        foreach ($checkUser as $value) {
                            // dd($value);
                            $tmp_arr = array(
                                'name' => $value->name,
                                'email' => $value->email,
                                'image' => $value->image,
                                'register_by' => $value->registered_by,
                                'account_tag' => '',
                                'type' => $value->membership,
                                'is_client_account' => $value->is_client_account,
                                'is_virtual_account' => $value->is_virtual_account,
                                'status' => $value->status,
                                'is_trial' => '',
                                'deleted' => $value->deleted,
                                'created' => $value->created,
                                'user_id' => $value->id,
                            );

                            $responseArray[] = $tmp_arr;
                        }

                        $data['status'] = true;
                        $data['message'] = 'Requested user exists';
                        $data['data'] = $responseArray;

                    } else {
                        $data['status'] = false;
                        $data['message'] = 'Requested user not exists';
                    }

                } else {
                    $data['status'] = false;
                    $data['message'] = 'Missing Required Parameter';
                }

            } else {
                $data['status'] = false;
                $data['message'] = 'Invalid JSON Data';
            }

        } else {
            $data['status'] = false;
            $data['message'] = 'Empty JSON Data';
        }

        $this->adi->_response($data);die;
    }

    public function updateTableUserDetails()
    {
        $json_data = file_get_contents("php://input");
       
        if (isset($json_data) and !empty($json_data)) {

            $check_response = $this->isValidJson($json_data);
            if ($check_response != false) {

                $passwordGenerator = new PasswordGenerator();
                $password = $passwordGenerator->generate();
                 $user_id = $check_response->id;
                $type = $check_response->membership;
                $user_type = $check_response->user_type;
                  
                if (!empty($user_id) && !empty($type)) {
                    
                    /** Check User Exists or Not */
                    if ($this->DatabaseModel->exists('users', array('id' => $user_id))) {
                        
                        if (in_array('bundle', $type)) {
                            
                            $data_arr['membership'] = "premium__unlimited__unlimitedlite__professional__professionallite__agency__bundle__playerneos__sonority__videoreel";

                        } else {
                            if ((count($type)) == 1) {
                                $account_type = $type[0];
                                $data_arr['membership'] = $account_type;
                            } else {
                                $data_arr['membership'] = implode("__", $type);
                            }
                        }

                        $data_arr['name'] = $check_response->name;

                        /** Check user account type */
                        if ($user_type == 1) {
                            $data_arr['is_super_admin'] = 1;
                            $data_arr['is_virtual_account'] = 0;
                            $data_arr['is_client_account'] = 0;
                        } elseif ($user_type == 3) {
                            $data_arr['is_super_admin'] = 0;
                            $data_arr['is_virtual_account'] = 1;
                            $data_arr['is_client_account'] = 0;
                        } elseif ($user_type == 4) {
                            $data_arr['is_super_admin'] = 0;
                            $data_arr['is_virtual_account'] = 0;
                            $data_arr['is_client_account'] = 1;
                        } elseif ($user_type == 2) {
                            $data_arr['is_super_admin'] = 0;
                            $data_arr['is_virtual_account'] = 0;
                            $data_arr['is_client_account'] = 0;
                        }

                        if ($this->DatabaseModel->updateTable('users', $data_arr, array('id' => $user_id))) {

                            $data['id'] = $user_id;
                            $data['status'] = true;
                            $data['message'] = 'User details updateTabled successfully';

                        } else {
                            $data['status'] = false;
                            $data['message'] = 'Something went wrong, Please try again';
                        }

                    } else {
                        $data['status'] = false;
                        $data['message'] = 'Requested User not Exists';
                    }

                } else {
                    $data['status'] = false;
                    $data['message'] = 'Missing Required Parameters';
                }

            } else {
                $data['status'] = false;
                $data['message'] = 'Invalid JSON Data';
            }

        } else {
            $data['status'] = false;
            $data['message'] = 'Empty JSON Data';
        }

        $this->adi->_response($data);die;

    }

    public function curl_post_request($name, $email)
    {
        $url = 'https://api.getresponse.com/v3/contacts';

        $get_response['name'] = $name;
        $get_response['email'] = $email;
        $get_response['dayOfCycle'] = '10';
        $get_response['campaign']['campaignId'] = 'MotMQ';

        $post = json_encode($get_response);

        $ch = curl_init();
        curl_setopt_array($ch, array(
            CURLOPT_URL => $url,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_POST => true,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 30,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => "POST",
            CURLOPT_POSTFIELDS => $post,
            CURLOPT_HTTPHEADER => array(
                'Content-Type: application/json',
                'X-Auth-Token: api-key de9227f28c5208001f5c2a9a34e7c984',
            ),
        ));
        curl_exec($ch);
        curl_close($ch);
    }

    public function isValidJson($str)
    {
        if (json_decode($str) !== null && strlen($str) > 0) {
            return json_decode($str);
        } else {
            return false;
        }
    }

 }