<?php
require_once 'vendor/autoload.php';

class StripeController extends CI_Controller
{
    private $user_id;
    public function __construct()
    {
        parent::__construct();
        $token = $this->jwt_verify->verify_token_2();
        if ($token['status'] != false) {
            $this->user_id = $token['data']['user_id'];
        } else {
            $this->adi->_response($token);
            die();

        }

        define('CURRENCY_CODE', 'usd');

    }

    public function stripeAuth()
    {
        $jsonData = file_get_contents("php://input");
        if ($postData = $this->adi->isValidJSON($jsonData)) {
            \Stripe\Stripe::setApiKey("$postData->privateKey");

            $livePublicKey = $postData->livePublicKey ? $postData->livePublicKey : '';
            $livePrivateKey = $postData->livePrivateKey ? $postData->livePrivateKey : '';

            try {
                $account = \Stripe\Account::retrieve();

                $insert['userId'] = $this->user_id;
                $insert['accountId'] = $account->id;
                $insert['bid'] = $postData->bid;
                $insert['name'] = 'stripe';
                $insert['type'] = 'stripe';
                $insert['type'] = $postData->type;
                $access['publicKey'] = $postData->publicKey;
                $access['user_name'] = $postData->name;
                $access['privateKey'] = $postData->privateKey;
                $access['livePublicKey'] = $livePublicKey;
                $access['livePrivateKey'] = $livePrivateKey;
                $insert['status'] = 1;
                $insert['data'] = json_encode($access);

                $res = $this->DatabaseModel->fetchTableData('integration', array('accountId' => $account->id, 'userId' => $this->user_id));
                if (!empty($res)) {
                    $response = array('status' => true, 'message' => 'Successfully  connected.');

                } else {
                    $res = $this->DatabaseModel->insertData('integration', $insert);
                    if ($res) {
                        $response = array('status' => true, 'message' => 'Successfully  connected.');

                    } else {
                        $response = array('status' => false, 'message' => 'Not connected.');

                    }

                }

            } catch (Exception $e) {
                $response = array('status' => false, 'message' => 'Invalid API Key provided.');

            }

        } else {
            $response = array('status' => false, 'message' => 'Invalid json.');
        }
        $this->adi->_response($response);
    }

    public function orderPay()
    {
        $jsonData = file_get_contents("php://input");
        if ($postData = $this->adi->isValidJson($jsonData)) {
            $userId = $this->user_id;
            $name = $postData->name;
            $email = $postData->email;
            $amount = $postData->amount;

            if (empty($name) && empty($email) && empty($amount)) {
                $response = array('Some fields are missing.');
            } else {

                $api = $this->getAPI($userId);

                if (!empty($api)) {
                    $key = json_decode($api[0]->data);
                    if ($api[0]->type === 'sandbox') {
                        $PrivateKey = $key->privateKey;
                    } else {
                        $PrivateKey = $key->livePrivateKey;
                    }

                    $stripe = new \Stripe\StripeClient($PrivateKey);
                    $data = $stripe->checkout->sessions->create(
                        [
                            'line_items' => [
                                [
                                    'price_data' => [
                                        'currency' => 'inr',
                                        'product_data' => ['name' => $name],
                                        'unit_amount' => $amount * 100,
                                    ],
                                    'quantity' => 1,

                                ],
                            ],
                            'mode' => 'payment',
                            'customer_email' => $email,
                            'success_url' => 'http://localhost:4242/success.html',
                            'cancel_url' => 'http://localhost:4242/cancel.html',
                        ]
                    );

                    $response = array('status' => true, 'data' => $data);

                } else {

                    $response = array('status' => false, 'Integration not connected.');

                }

                // $response = array('status' => true, 'public key' => $PublicKey, 'private key' => $PrivateKey);

            }

        } else {
            $response = array('status' => false, 'message' => 'Invalid json');
        }
        $this->adi->_response($response);
    }

    private function getAPI($userId)
    {
        $res = $this->DatabaseModel->fetchTableData('integration', array('userId' => $userId));
        if ($res) {
            return $res;
        } else {
            return false;
        }
    }

    // private function get_curl_handle($email, $password, $secretKey)
    // {
    //     $curl = curl_init();
    //     curl_setopt_array($curl, array(
    //         CURLOPT_URL => "https://api.stripe.com/v1/customers",
    //         CURLOPT_RETURNTRANSFER => true,
    //         CURLOPT_ENCODING => "",
    //         CURLOPT_MAXREDIRS => 10,
    //         CURLOPT_TIMEOUT => 30,
    //         CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
    //         CURLOPT_CUSTOMREQUEST => "POST",
    //         CURLOPT_POSTFIELDS => "email=$email",
    //         CURLOPT_HTTPHEADER => array(
    //             "Authorization: Bearer $secretKey",
    //             "Content-Type: application/x-www-form-urlencoded",
    //         ),
    //     ));

    //     $response = curl_exec($curl);
    //     $res = json_decode($response);
    //     curl_close($curl);
    //     if ($res->id) {
    //         $curl = curl_init();

    //         curl_setopt_array($curl, array(
    //             CURLOPT_URL => "https://api.stripe.com/v1/tokens",
    //             CURLOPT_RETURNTRANSFER => true,
    //             CURLOPT_ENCODING => "",
    //             CURLOPT_MAXREDIRS => 10,
    //             CURLOPT_TIMEOUT => 30,
    //             CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
    //             CURLOPT_CUSTOMREQUEST => "POST",
    //             CURLOPT_POSTFIELDS => "customer=" . $res->id,
    //             CURLOPT_HTTPHEADER => array(
    //                 "Authorization: Bearer $secretKey",
    //                 "Content-Type: application/x-www-form-urlencoded",
    //             ),
    //         ));

    //         $response = curl_exec($curl);
    //         $err = curl_error($curl);
    //         curl_close($curl);
    //         dd($response);

    //     }
    // }

}
