<?php
class StaffController extends CI_Controller
{
    private $user_id;
    public function __construct()
    {
        parent::__construct();
        $verify_token = $this->jwt_verify->verify_token_2();
        if ($verify_token['status'] != false) {
            $this->user_id = $verify_token['data']['user_id'];
        } else {
            $this->adi->_response($verify_token);
            die();
        }

    }

    public function createStaff()
    {
        $json_data = file_get_contents("php://input");

        if ($post_data = $this->adi->isValidJson($json_data)) {

            $bid = $post_data->bid;
            $pid = $post_data->pid;

            if ($this->DatabaseModel->exists('users', array('email' => $post_data->email))) {
                $response['message'] = 'This email is already exists.';
                $this->adi->_response($response, $this->user_id);

            }

            if ($post_data->password != $post_data->confirmPassword) {
                $response = array('status' => false, 'message' => 'Password not matched.');
            } else {
                $password = password_hash($post_data->password, PASSWORD_DEFAULT);

                $data = array(
                    'name' => $post_data->name,
                    'parent' => $this->user_id,
                    'email' => $post_data->email,
                    'image' => site_url('assets/images/profile.png'),
                    'membership' => '',
                    'password' => $password,
                    'registered_by' => $this->user_id,
                    'status' => $post_data->status,
                    'is_staff' => 1,
                );

                if ($res = $this->DatabaseModel->insertData('users', $data)) {

                    $insert = array(
                        'userId' => $this->user_id,
                        'staffId' => $res,
                        'bid' => $bid,
                        'pid' => $pid,
                        'isDeleted' => 0,
                        'status' => 1,
                        'created' => date('Y-m-d H:i:s'),
                    );

                    $result = $this->DatabaseModel->insertData('staff_assign', $insert);
                    if ($result) {
                        $response = array(
                            'status' => true,
                            'data' => $res,
                            'message' => 'Staff created successfully.',
                        );

                    } else {
                        $response = array(
                            'status' => false,
                            'message' => 'Staff not created',
                        );

                    }

                }
            }
        } else {
            $response = array('status' => false, 'message' => 'Invalid json.');
        }

        $this->adi->_response($response);

    }
    public function updateStaff()
    {
        $json_data = file_get_contents("php://input");

        if ($post_data = $this->adi->isValidJson($json_data)) {

            $staffId = $post_data->staffId;
            $bid = $post_data->bid;
            $pid = $post_data->pid;

            $data = array(
                'name' => $post_data->name,
                'email' => $post_data->email,
                'status' => $post_data->status,
                'modified' => date('Y-m-d H:i:s'),
            );

            if ($res = $this->DatabaseModel->updateTable('users', $data, array('id' => $staffId))) {

                $update = array(
                    'bid' => $bid,
                    'pid' => $pid,
                    'modified' => date('Y-m-d H:i:s'),
                );

                // dd($update);
                $result = $this->DatabaseModel->updateTable('staff_assign', $update, array('staffId' => $staffId));
                if ($result) {
                    $response = array(
                        'status' => true,
                        'data' => $res,
                        'message' => 'Staff updated successfully.',
                    );

                } else {
                    $response = array(
                        'status' => false,
                        'message' => 'Staff not update.',
                    );

                }

            }
        } else {
            $response = array('status' => false, 'message' => 'Invalid json.');
        }

        $this->adi->_response($response);

    }
    public function fetchStaffAccount()
    {
        $jsonData = file_get_contents("php://input");
        if ($postData = $this->adi->isValidJson($jsonData)) {
            $id = $postData->id;
            $accounts = $this->DatabaseModel->fetchTableData('users', array('id' => $id, 'is_client_account' => 0, 'is_staff' => 1, 'is_virtual_account' => 0, 'deleted' => 0));
            $staffData = $this->DatabaseModel->fetchTableData('staff_assign', array('staffId' => $accounts[0]->id));
            $accounts[0]->bid = $staffData ? $staffData[0]->bid : '';
            $accounts[0]->pid = $staffData ? $staffData[0]->pid : '';
            if (!empty($accounts)) {
                unset($accounts[0]->password);
                $data = $accounts;
                $response = array('status' => true, 'data' => $data);
            } else {
                $response = array('status' => false, 'message' => 'Data not found.');
            }

        } else {
            $response = array('status' => false, 'message' => 'Invalid json.');

        }

        $this->adi->_response($response);

    }
    public function fetchListStaff()
    {

        $accounts = $this->DatabaseModel->fetchTableData('users', array('is_client_account' => 0, 'is_staff' => 1, 'is_virtual_account' => 0, 'deleted' => 0, 'parent' => $this->user_id));
        if (!empty($accounts)) {
            unset($accounts[0]->password);
            $data = $accounts;
            $response = array('status' => true, 'data' => $data);
        } else {
            $response = array('status' => false, 'message' => 'Data not found.');
        }

        $this->adi->_response($response);

    }

    public function deleteStaff()
    {
        $jsonData = file_get_contents("php://input");
        if ($postData = $this->adi->isValidJson($jsonData)) {
            $id = $postData->id;
            $res = $this->DatabaseModel->updateTable('users', array('deleted' => 1), array('id' => $id));
            if ($res) {
                $response = array('status' => true, 'message' => 'Deleted successfully.');
            } else {
                $response = array('status' => true, 'message' => 'Not deleted.');

            }
        } else {
            $response = array('status' => false, 'message' => 'Invalid json');
        }
        $this->adi->_response($response);
    }

}
