<?php
class RemainderController extends CI_Controller
{
    private $user_id;
    public function __construct()
    {
        parent::__construct();
        $verify_token = $this->jwt_verify->verify_token_2();
        if ($verify_token['status'] != false) {
            $this->user_id = $verify_token['data']['user_id'];
        } else {
            $this->adi->_response($verify_token);
            die();
        }

    }

    public function createRemainder()
    {
        $jsonData = file_get_contents("php://input");
        if ($postData = $this->adi->isValidJson($jsonData)) {
            $insert['userId'] = $this->user_id;
            $insert['bid'] = $postData->bid;
            $insert['cid'] = $postData->cid;
            $insert['name'] = $postData->name;
            $insert['pid'] = $postData->pid;
            $insert['type'] = $postData->type;
            $insert['data'] = $postData->data;
            $insert['status'] = 1;
            $insert['created'] = date('Y-m-d H:i:s');
            $res = $this->DatabaseModel->insertData('reminder', $insert);
            if ($res) {
                $response = array('status' => true, 'message' => 'Reminder created successfully.');
            } else {
                $response = array('status' => false, 'message' => 'Not created.');
            }

        } else {
            $response = array('status' => false, 'message' => 'Invalid json.');
        }
        $this->adi->_response($response);
    }

    public function updateRemainder()
    {
        $jsonData = file_get_contents("php://input");
        if ($postData = $this->adi->isValidJson($jsonData)) {
            $id = $postData->id;
            $update['bid'] = $postData->bid;
            $update['cid'] = $postData->cid;
            $update['pid'] = $postData->pid;
            $update['name'] = $postData->name;
            $update['type'] = $postData->type;
            $update['data'] = $postData->data;
            $update['modified'] = date('Y-m-d H:i:s');

            $res = $this->DatabaseModel->updateTable('reminder', $update, array('id' => $id));

            if ($res) {
                $response = array('status' => true, 'message' => 'Reminder update successfully.');
            } else {
                $response = array('status' => false, 'message' => 'Not update.');
            }

        } else {
            $response = array('status' => false, 'message' => 'Invalid json.');
        }
        $this->adi->_response($response);
    }
    public function deleteRemainder()
    {
        $jsonData = file_get_contents("php://input");
        if ($postData = $this->adi->isValidJson($jsonData)) {
            $id = $postData->id;
            $res = $this->DatabaseModel->updateTable('reminder', array('isDeleted' => 1), array('id' => $id));
            if ($res) {
                $response = array('status' => true, 'message' => 'Deleted successfully.');
            } else {
                $response = array('status' => false, 'Not deleted.');
            }

        } else {
            $response = array('status' => false, 'message' => 'Invalid json.');
        }
        $this->adi->_response($response);
    }

    public function viewRemainder()
    {
        $jsonData = file_get_contents("php://input");
        if ($postData = $this->adi->isValidJson($jsonData)) {
            $bid = $postData->bid;
            $res = $this->DatabaseModel->fetchTableData('reminder', array('bid' => $bid, 'userId' => $this->user_id, 'isDeleted' => 0));
            foreach ($res as $key => $value) {
                $productInfo = $this->DatabaseModel->fetchTableData('product', array('id' => $value->pid, 'isDeleted' => 0));
                $res[$key]->productInfo = $productInfo ? $productInfo : '';

                $customerInfo = $this->DatabaseModel->fetchTableData('customers', array('id' => $value->cid, 'isDeleted' => 0));
                $res[$key]->customerInfo = $customerInfo ? $customerInfo : '';

            }

            if ($res) {
                $response = array('status' => true, 'data' => $res);
            } else {
                $response = array('status' => false, 'message' => 'Data not found.');
            }
        } else {
            $response = array('status' => false, 'message' => 'Invalid  json.');
        }

        $this->adi->_response($response);
    }

    public function fetchRemainder()
    {
        $jsonData = file_get_contents("php://input");
        if ($postData = $this->adi->isValidJson($jsonData)) {
            $id = $postData->id;
            $res = $this->DatabaseModel->fetchTableData('reminder', array('id' => $id, 'userId' => $this->user_id, 'isDeleted' => 0));
            if ($res) {
                $response = array('status' => true, 'data' => $res);
            } else {
                $response = array('status' => false, 'message' => 'Data not found.');
            }
        } else {
            $response = array('status' => false, 'message' => 'Invalid  json.');
        }

        $this->adi->_response($response);
    }

    public function sendRemainder()
    {
        $jsonData = file_get_contents("php://input");
        if ($postData = $this->adi->isValidJson($jsonData)) {
            $bid = $postData->bid;
            $pid = $postData->pid;
            $cid = $postData->cid;
            $rid = $postData->rid;
            $remainder_details = $this->DatabaseModel->fetchTableData('reminder', array('id' => $rid, 'bid' => $bid, 'pid' => $pid, 'cid' => $cid));

            if (!empty($remainder_details)) {
                if ($remainder_details[0]->type === 'email') {
                    if (!empty($remainder_details)) {
                        $customer_details = $this->DatabaseModel->fetchTableData('customers', array('id' => $cid));
                        // dd($customer_details);
                        $this->adi->_mail($customer_details[0]->email, 'Reminder', $remainder_details[0]->data);

                        $response = array('status' => true, 'message' => 'Reminder send successfully.');

                    } else {
                        $response = array('status' => false, 'message' => 'Reminder not found.');
                    }

                } else {

                    // send sms write code here
                }
            } else {
                $response = array('status' => false, 'message' => 'Reminder not found.');
            }

        } else {
            $response = array('status' => false, 'message' => 'Invalid json');
        }
        $this->adi->_response($response);
    }

    public function twilloAddFunction()
    {
        if (checkAuthentication()) {
            $userID = $this->session->userdata('user_id');

            $memberShipUser = allmemberShip($userID);

            if (in_array("Advanced", $memberShipUser) && count($memberShipUser) == 1) {
                $limitAccount = $this->SuperAdminModel->getData('twillo_details', array('user_id' => $userID));
                if (count($limitAccount) >= ADVENCED_LIMIT) {
                    $alimit = ADVENCED_LIMIT;
                    echo json_encode(array('status' => 0, 'msg' => 'Olny for maximum ' . $alimit . ' twilio account connection allow', 'url' => ''));
                    die();
                }

            } elseif (in_array("Platinum Lite", $memberShipUser) && !in_array("Platinum", $memberShipUser)) {
                $limitAccount = $this->SuperAdminModel->getData('twillo_details', array('user_id' => $userID));
                if (count($limitAccount) >= UNLIMITED_LITE_LIMIT) {
                    $alimit = UNLIMITED_LITE_LIMIT;
                    echo json_encode(array('status' => 0, 'msg' => 'Olny for maximum ' . $alimit . ' twilio account connection allow', 'url' => ''));
                    die();
                }
            } else {
                $limitAccount = $this->SuperAdminModel->getData('twillo_details', array('user_id' => $userID));
                if (count($limitAccount) >= UNLIMITED_LIMIT) {

                    $alimit = UNLIMITED_LIMIT;
                    echo json_encode(array('status' => 0, 'msg' => 'Olny for maximum ' . $alimit . ' twilio account connection allow', 'url' => ''));
                    die();
                }
            }
            $date = date('Y-m-d H:i:s');
            if (isset($_POST['sid'])) {
                /** check if user already SMTP */
                if ($this->SuperAdminModel->exists('twillo_details', array('user_id' => $userID, 'sid' => $_POST['sid']))) {

                    $sid = $_POST['sid'];
                    $authtoken = $_POST['authtoken'];
                    $number = $_POST['number'];
                    $to_number = $_POST['to_number'];
                    //$resGet = $this->curlRequest($sid, $authtoken, $number);
                    $twilio = new Client($sid, $authtoken);
                    try
                    {
                        $message = $twilio->messages->create("+$to_number", // to 918800227501
                            ["body" => "Hi there", "from" => "+$number"]
                        );
                    } catch (Exception $e) { //on error push userId in to error array
                        if ($e->getStatusCode() == 400) {
                            echo json_encode(array('status' => 0, 'msg' => 'The given parameter is not valid', 'url' => ''));die();
                        }

                    }
                    //$resGet = $this->curlRequest($sid, $authtoken, $number);
                    if (!empty($message->sid)) {
                        $where = array('user_id' => $userID, 'sid' => $_POST['sid']);
                        $result = $this->Common_DML->get_data(TBL_TWILLO_DETAILS, $where);
                        if ($this->session->userdata('is_reseller')) {
                            $data = array(
                                'user_id' => $userID,
                                'sid' => $_POST['sid'],
                                'authtoken' => $_POST['authtoken'],
                                'number' => $_POST['number'],
                                'to_number' => $_POST['to_number'],
                                'created' => $date,
                                'modified' => $date,
                                'status' => 0,
                                'reseller_status' => 1,
                            );
                        } else {
                            $data = array(
                                'user_id' => $userID,
                                'sid' => $_POST['sid'],
                                'authtoken' => $_POST['authtoken'],
                                'number' => $_POST['number'],
                                'to_number' => $_POST['to_number'],
                                'created' => $date,
                                'modified' => $date,
                                'status' => 1,
                            );
                        }
                        $tw_where = array('user_id' => $userID, 'sid' => $_POST['sid'], 'id' => $result[0]['id']);
                        $this->Common_DML->set_data(TBL_TWILLO_DETAILS, $data, $tw_where);
                        echo json_encode(array('status' => 1, 'msg' => 'Twilio Detail Added Successfully!', 'url' => ''));

                    } else {
                        echo json_encode(array('status' => 0, 'msg' => 'Something went wrong, Please try again!', 'url' => ''));
                    }

                } else {
                    $sid = $_POST['sid'];
                    $authtoken = $_POST['authtoken'];
                    $number = $_POST['number'];
                    $to_number = $_POST['to_number'];
                    $twilio = new Client($sid, $authtoken);
                    try
                    {
                        $message = $twilio->messages->create("+$to_number", // to
                            ["body" => "Hi there", "from" => "+$number"]
                        );

                    } catch (Exception $e) { //on error push userId in to error array
                        if ($e->getStatusCode() == 400) {
                            echo json_encode(array('status' => 0, 'msg' => 'The given parameter is not valid', 'url' => ''));die();
                        }

                    }
                    //$resGet = $this->curlRequest($sid, $authtoken, $number);

                    if (!empty($message->sid)) {
                        $d = array(
                            'user_id' => $userID,
                            'sid' => $_POST['sid'],
                            'authtoken' => $_POST['authtoken'],
                            'number' => $_POST['number'],
                            'to_number' => $_POST['to_number'],
                            'created' => $date,
                            'modified' => $date,
                            'status' => 1,
                        );
                        $res = $this->Common_DML->put_data('twillo_details', $d);

                        if (!empty($res)) {
                            echo json_encode(array('status' => 1, 'msg' => 'Twilio Detail Added Successfully!', 'url' => ''));
                        } else {
                            echo json_encode(array('status' => 0, 'msg' => 'Something went wrong, Please try again!', 'url' => ''));
                        }
                    } else {
                        echo json_encode(array('status' => 0, 'msg' => 'Something went wrong, Please try again!', 'url' => ''));
                    }
                }

            } else {
                echo json_encode(array('status' => 0, 'msg' => 'Something went wrong, Please try again!', 'url' => ''));
            }
        }
        die();
    }

}
