<?php
class RazorpayController extends CI_Controller
{
    private $user_id;
    public function __construct()
    {
        parent::__construct();
        $verify_token = $this->jwt_verify->verify_token_2();
        if ($verify_token['status']) {
            $this->user_id = $verify_token['data']['user_id'];
        } else {
            $this->adi->_response($verify_token);
            die();
        }

    }

    public function authRazorpay()
    {
        $jsonData = file_get_contents("php://input");
        if ($postData = $this->adi->isValidJson($jsonData)) {
            $bid = $postData->bid;
            $name = $postData->name;
            $publicKey = $postData->publicKey;
            $privateKey = $postData->privateKey;
            $livePublicKey = $postData->livePublicKey;
            $livePrivateKey = $postData->livePrivateKey;
            if ($publicKey != '' && $privateKey != '' && $name != '') {

                $insert['userId'] = $this->user_id;
                $insert['bid'] = $bid;
                $insert['name'] = 'razorpay';
                $insert['type'] = 'razorpay';
                $access['publicKey'] = $publicKey;
                $access['user_name'] = $name;
                $access['privateKey'] = $privateKey;
                $insert['network_key'] = $privateKey;
                $access['livePublicKey'] = $livePublicKey ? $livePublicKey : '';
                $access['livePrivateKey'] = $livePrivateKey ? $livePrivateKey : '';
                $insert['status'] = 1;
                $insert['data'] = json_encode($access);

                $res = $this->DatabaseModel->fetchTableData('integration', array('network_key' => $privateKey, 'userId' => $this->user_id));
                if (!empty($res)) {
                    $response = array('status' => true, 'message' => 'Successfully  connected..');

                } else {

                    $res = $this->DatabaseModel->insertData('integration', $insert);
                    if ($res) {
                        $response = array('status' => true, 'message' => 'Successfully connected.');

                    } else {
                        $response = array('status' => false, 'message' => 'Not connected.');

                    }
                }
            } else {
                $response = array('status' => false, 'message' => 'Missing required parameter');

            }

        } else {
            $response = array('status' => false, 'message' => 'Invalid json.');

        }
        $this->adi->_response($response);

    }

    public function payment_confirmation()
    {
        $user_id = $this->input->get('id');
        $returned_payment_id = $this->input->post('razorpay_payment_id');
        $returned_order_id = $this->input->post('razorpay_order_id');
        $returned_signature = $this->input->post('razorpay_signature');
        if (isset($this->session->userdata['order_id'])) {
            $order_id = $this->session->userdata['order_id'];
            $generated_signature = hash_hmac('sha256', $order_id . "|" . $returned_payment_id, SECRET);
            if ($generated_signature == $returned_signature) {
                $user_details = fetch_user_details($user_id);

                // fetch the items from the cart

            } else {
                $data['message'] = 'Your payment cannot be processed. Please contact your bank';
                $data['status'] = false;
            }
        } else {
            $data['message'] = 'Illegal method';
            $data['status'] = false;
        }
        $this->adi->_response($response);
    }

}
