<?php
class ProductController extends CI_Controller
{
    private $user_id;
    public function __construct()
    {
        parent::__construct();
        $verify_token = $this->jwt_verify->verify_token_2();
        if ($verify_token['status']) {
            $this->user_id = $verify_token['data']['user_id'];
        } else {
            $this->adi->_response($verify_token);
            die();
        }

    }
    public function createProduct()
    {
        $jsonData = file_get_contents("php://input");
        if ($postData = $this->adi->isValidJson($jsonData)) {
            $name = $postData->name;
            $bid = $postData->bid;
            $slug = $postData->slug;

            if (!empty($bid)) {
                $slug = url_title($slug, 'dash', true);
                $insert['userId'] = $this->user_id;
                $insert['name'] = $name;
                $insert['bid'] = $bid;
                $insert['description'] = $postData->description;
                $insert['logo'] = base_url() . 'assets/images/business.png';
                $insert['isDeleted'] = 0;
                $insert['slug'] = $slug;
                $insert['url'] = $postData->url.'/'.$slug;
                $insert['isSameAsBusiness'] = 1;
                $insert['created'] = date('Y-m-d H:i:s');

                $res = $this->DatabaseModel->insertData('product', $insert);
                if ($res) {
                    $response = array('status' => true, 'data' => $res, 'message' => 'Product created successfully.');

                } else {
                    $response = array('status' => false, 'message' => 'Product not created.');
                }

            } else {
                $response = array('status' => false, 'message' => 'Business Id  is missing.');
            }

        } else {
            $response = array('status' => false, 'message' => 'Invalid json.');
        }
        $this->adi->_response($response);
    }

    public function updateProduct()
    {

        $jsonData = file_get_contents("php://input");
        if ($postData = $this->adi->isValidJson($jsonData)) {
            
            $id = $postData->id;
            $url = $postData->slug;
            $update['name'] = $postData->name;
            $update['bid'] = $postData->bid;
            $update['description'] = $postData->description;
            $update['price'] = $postData->price;
            $update['frequency'] = $postData->frequency;
            $update['period'] = $postData->period;
            $update['numberOfPayment'] = $postData->numberOfPayment;
            $update['isPhone'] = $postData->isPhone;
            $update['autoresponder'] = $postData->autoresponder;
            $update['paymentProcess'] = json_encode($postData->paymentProcess);
            $update['isSameAsBusiness'] = $postData->isSameAsBusiness;
            $update['tracking'] = $postData->tracking;
            $update['isAddress'] = $postData->isAddress;
            $update['legal'] = $postData->legal;
            $update['openingHours'] = $postData->openingHours;
            $update['productType'] = $postData->productType;
            $update['logo'] = $postData->logo;
            $update['design'] = json_encode($postData->design);
            $update['mode'] = $postData->mode;
            $update['isExist'] = $postData->isExist;
            $update['existData'] = json_encode($postData->existData);
            $update['thankuPage'] = $postData->thankuPage;
            $update['payment'] = $postData->payment;
            $update['slug'] = $url;
            $update['tag'] = $postData->tag;
            $update['staff'] =json_encode($postData->staff);
            $update['productStatus'] = $postData->productStatus;
            $update['modified'] = date('Y-m-d H:i:s');

            $res = $this->DatabaseModel->updateTable('product', $update, array('id' => $id));
            if ($res) {
                $response = array('status' => true, 'message' => 'Product updated successfully.');
            } else {
                $response = array('status' => false, 'message' => 'Product not updated.');
            }

        } else {
            $response = array('status' => false, 'message' => 'Invalid json');
        }
        $this->adi->_response($response);
    }

    public function deleteProduct()
    {
        $jsonData = file_get_contents("php://input");
        if ($postData = $this->adi->isValidJson($jsonData)) {
            $id = $postData->id;
            $res = $this->DatabaseModel->updateTable('product', array('isDeleted' => 1), array('id' => $id));
            if ($res) {
                $response = array('status' => true, 'message' => 'Product deleted successfully.');
            } else {
                $response = array('status' => false, 'message' => 'Product not deleted.');
            }
        } else {
            $response = array('status' => false, 'message' => 'Invalid json');
        }
        $this->adi->_response($response);
    }

    public function designProduct()
    {
        $jsonData = file_get_contents("php://input");
        if ($postData = $this->adi->isValidJson($jsonData)) {
            $pid = $postData->pid;
            $data = $postData->data;
            $res = $this->DatabaseModel->updateTable('product', array('design' => $data), array('id' => $pid));
            if ($res) {
                $response = array('status' => true, 'message' => 'Inserted successfully.');
            } else {
                $response = array('status' => false, 'message' => 'failed.');
            }
        } else {
            $response = array('status' => false, 'message' => 'Invalid json');
        }
        $this->adi->_response($response);
    }
    public function viewProduct()
    {
        $jsonData = file_get_contents("php://input");
        if ($postData = $this->adi->isValidJson($jsonData)) {
            $pid = $postData->id;
            $res = $this->DatabaseModel->fetchTableData('product', array('id' => $pid, 'isDeleted' => 0));
            if ($res) {
                $res[0]->design = $res ? json_decode($res[0]->design) : "";
                $response = array('status' => true, 'data' => $res);
            } else {
                $response = array('status' => false, 'message' => 'Data not found.');
            }
        } else {
            $response = array('status' => false, 'message' => 'Invalid  json.');
        }

        $this->adi->_response($response);
    }
    public function fetchListProduct()
    {

        $jsonData = file_get_contents("php://input");
        if ($postData = $this->adi->isValidJson($jsonData)) {
            if (isset($postData->bid)) {
                $res = $this->DatabaseModel->fetchTableData('product', array('bid' => $postData->bid, 'userId' => $this->user_id, 'isDeleted' => 0));
                if ($res) {
                    $response = array('status' => true, 'data' => $res);
                } else {
                    $response = array('status' => false, 'message' => 'Data not found.');
                }

            } else {
                $res = $this->DatabaseModel->fetchTableData('product', array('userId' => $this->user_id, 'isDeleted' => 0));
                if ($res) {
                    $response = array('status' => true, 'data' => $res);
                } else {
                    $response = array('status' => false, 'message' => 'Data not found.');
                }

            }

        } else {
            $response = array('status' => false, 'message' => 'Invalid  json.');

        }

        $this->adi->_response($response);
    }

    public function productDuplicate()
    {
        $response = array('status' => false, 'message' => 'Invalid json');
        $json_data = file_get_contents("php://input");
        if ($post_data = $this->adi->isValidJson($json_data)) {
            $date = date('Y-m-d H:i:s');
            $productId = $post_data->id;
            $userID = $this->user_id;
            if ($productId != '' && $userID != '') {
                $productData = $this->DatabaseModel->fetchTableData('product', array('id' => $productId, 'isDeleted' => 0, 'userId' => $userID));

                if (!empty($productData)) {
                    $productName = $productData[0]->name;
                    $slug = url_title($productName, 'dash', true);
                    $slugData = $this->DatabaseModel->fetchTableData('product', array('name' => $productName));
                    if ($slugData) {
                        $totalSlug = count($slugData);
                        if ($totalSlug > 1) {
                            $slugc = $totalSlug - 1;
                            $insert['slug'] = url_title($productName . ' ' . $slugc, 'dash', true);
                        } else {
                            $insert['slug'] = url_title($productName . ' ' . $totalSlug, 'dash', true);
                        }
                    } else {
                        $insert['slug'] = $slug;
                    }
                    $insert['userId'] = $productData[0]->userId;
                    $insert['name'] = $productData[0]->name;
                    $insert['description'] = $productData[0]->description;
                    $insert['bid'] = $productData[0]->bid;
                    $insert['price'] = $productData[0]->price;
                    $insert['currency'] = $productData[0]->currency;
                    $insert['frequency'] = $productData[0]->frequency;
                    $insert['remaining'] = $productData[0]->remaining;
                    $insert['period'] = $productData[0]->period;
                    $insert['numberOfPayment'] = $productData[0]->numberOfPayment;
                    $insert['isPhone'] = $productData[0]->isPhone;
                    $update['autoresponder'] = $productData[0]->autoresponder;
                    $update['isSameAsBusiness'] = $productData[0]->isSameAsBusiness;
                    $insert['isAddress'] = $productData[0]->isAddress;
                    $insert['isDeleted'] = $productData[0]->isDeleted;
                    $insert['design'] = $productData[0]->design;
                    $insert['Legal'] = $productData[0]->legal;
                    $insert['logo'] = $productData[0]->logo;
                    $insert['mode'] = $productData[0]->mode;
                    $insert['isExist'] = $productData[0]->isExist;
                    $insert['existData'] = $productData[0]->existData;
                    $insert['productType'] = $productData[0]->productType;
                    $insert['thankuPage'] = $productData[0]->thankuPage;
                    $insert['payment'] = $productData[0]->payment;
                    $insert['staff'] = $productData[0]->staff;

                    $insert['productStatus'] = $productData[0]->productStatus;

                    $insert['created'] = $date;
                    $insert['modified'] = $date;

                    $res = $this->DatabaseModel->insertData('product', $insert);
                    if ($res) {
                        $response = array('status' => true, 'message' => 'duplicated data successfully.');
                    } else {
                        $response = array('status' => false, 'message' => 'Not duplicate.');
                    }

                } else {
                    $response = array('status' => false, 'message' => 'Not Found!');
                }

            } else {
                $response = array('status' => false, 'message' => 'ProductId and userId are  missing');
            }

        } else {
            $response = array('status' => false, 'message' => 'Invalid json');
        }
        $this->adi->_response($response);
    }

}
