<?php
defined('BASEPATH') or exit('No direct script access allowed');

/**
 * @property  passwordencryption passwordencryption
 * @property CI_Upload upload
 */
class PaypalController extends CI_Controller
{

    private $user_id;
    public function __construct()
    {

        parent::__construct();
        $verify_token = $this->jwt_verify->verify_token_2();
        if ($verify_token['status'] != false) {
            $this->user_id = $verify_token['data']['user_id'];
        } else {
            $this->adi->_response($verify_token);
            die();
        }

        define('PAYPAL_ID', 'Insert_PayPal_Business_Email');
        define('PAYPAL_SANDBOX', true); //TRUE or FALSE
        define('PAYPAL_RETURN_URL', base_url() . 'order-success');
        define('PAYPAL_CANCEL_URL', base_url() . 'order-cancel');
        define('PAYPAL_NOTIFY_URL', base_url() . 'paypal-ipn');
        define('PAYPAL_CURRENCY', 'USD');
        define('PAYPAL_URL', (PAYPAL_SANDBOX == true) ? "https://www.sandbox.paypal.com/cgi-bin/webscr" : "https://www.paypal.com/cgi-bin/webscr");
    }

    public function auth()
    {
        $response = array('status' => false, 'message' => 'Invalid json');
        $json_data = file_get_contents("php://input");
        if ($post_data = $this->adi->isValidJson($json_data)) {
            if ($post_data->publicKey != '' && $post_data->privateKey && $post_data->name != '') {
                $date = date('Y-m-d H:i:s');
                if (!empty($post_data->livePublicKey) && !empty($post_data->livePrivateKey)) {
                    //curl request for aouth  sandbox
                    $url = 'https://www.sandbox.paypal.com/v1/oauth2/token';
                    $res = $this->curlRequest($url, $post_data->publicKey, $post_data->privateKey);

                    if (!empty($res) && isset($res->scope)) {
                        //curl request for aouth  live
                        $url = 'https: //www.paypal.com/v1/oauth2/token';
                        $reslive = $this->curlRequest($url, $post_data->livePublicKey, $post_data->livePrivateKey);

                        if (!empty($reslive) && isset($reslive->scope)) {
                            $check = array(
                                'user_id' => $this->user_id,
                                'name' => 'paypal',
                                'accountId' => $res->app_id,

                            );
                            $insert['bid'] = $post_data->bid;
                            $insert['type'] = $post_data->type;
                            $access['client_id'] = $post_data->publicKey;
                            $access['secret_id'] = $post_data->privateKey;
                            $access['access_token'] = $res->access_token;
                            $access['live_client_id'] = $post_data->livePublicKey;
                            $access['live_secret_id'] = $post_data->livePrivateKey;
                            $access['live_access_token'] = $reslive->access_token;
                            $access['user_name'] = $post_data->name;
                            $insert['userId'] = $this->user_id;
                            $insert['name'] = 'paypal';
                            $access['scope'] = $res->scope;
                            $access['token_type'] = $res->token_type;
                            $access['app_id'] = $res->app_id;
                            $access['expires_in'] = $res->expires_in;
                            $access['live_scope'] = $reslive->scope;
                            $access['live_app_id'] = $reslive->app_id;
                            $access['expires_in'] = $reslive->expires_in;
                            $insert['data'] = json_encode($access);
                            $insert['created'] = $date;
                            $insert['status'] = 1;

                            if ($this->DatabaseModel->exists('integration', $check)) {
                                $paypal = $this->DatabaseModel->fetchTableData('paypal', $check);

                                $access['access_token'] = $res->access_token;
                                $access['live_access_token'] = $res->access_token;
                                $update['name'] = 'paypal';
                                $update['type'] = $post_data->type;
                                $access['expires_in'] = $res->expires_in;
                                $access['live_expires_in'] = $res->expires_in;
                                $update['data'] = json_encode($access);
                                $update['modified'] = $date;
                                $update['status'] = 1;

                                $this->DataBaseModel->updateTable('integration', $update, array('id' => $paypal[0]->id));
                            } else {
                                $this->DatabaseModel->insertData('integration', $insert);
                            }
                            $response = array('status' => true, 'message' => 'Successfully connected');
                        } else {
                            $message = json_decode($response)->error_description;
                            $response = array('status' => false, 'message' => 'Live ' . $message);
                        }
                    } else {
                        $message = json_decode($response)->error_description;
                        $response = array('status' => false, 'message' => 'Sendbox ' . $message);
                    }
                } else {
                    //curl request for aouth sandbox
                    $url = 'https://www.sandbox.paypal.com/v1/oauth2/token';
                    $res = $this->curlRequest($url, $post_data->publicKey, $post_data->privateKey);

                    if (!empty($res) && isset($res->scope)) {

                        $check = array(
                            'userId' => $this->user_id,
                            'name' => 'paypal',
                            'accountId' => $res->app_id,
                        );
                        $insert['bid'] = $post_data->bid;
                        $insert['type'] = $post_data->type;
                        $access['client_id'] = $post_data->publicKey;
                        $access['secret_id'] = $post_data->privateKey;
                        $access['access_token'] = $res->access_token;
                        $access['live_client_id'] = $post_data->livePublicKey;
                        $access['live_secret_id'] = $post_data->livePrivateKey;
                        $access['live_access_token'] = $res->access_token;
                        $access['user_name'] = $post_data->name;
                        $insert['userId'] = $this->user_id;
                        $insert['name'] = 'paypal';
                        $access['scope'] = $res->scope;
                        $access['token_type'] = $res->token_type;
                        $insert['accountId'] = $res->app_id;
                        $access['expires_in'] = $res->expires_in;
                        $access['live_scope'] = $res->scope;
                        $access['live_app_id'] = $res->app_id;
                        $insert['data'] = json_encode($access);
                        $insert['created'] = $date;
                        $insert['status'] = 1;

                        if ($this->DatabaseModel->exists('integration', $check)) {
                            $paypal = $this->DatabaseModel->fetchTableData('integration', $check);

                            $access['access_token'] = $res->access_token;
                            $access['live_access_token'] = $res->access_token;
                            $update['name'] = 'paypal';
                            $update['type'] = $post_data->type;
                            $access['expires_in'] = $res->expires_in;
                            $access['live_expires_in'] = $res->expires_in;
                            $update['data'] = json_encode($access);
                            $update['modified'] = $date;
                            $update['status'] = 1;

                            $this->DatabaseModel->updateTable('integration', $update, array('id' => $paypal[0]->id));
                        } else {
                            $this->DatabaseModel->insertData('integration', $insert);
                        }
                        $response = array('status' => true, 'message' => 'Successfully connected');
                    } else {

                        $response = array('status' => false, 'message' => 'Provided information invalid');
                    }
                }

            } else {
                $response = array('status' => false, 'message' => 'Missing required parameter');
            }

        } else {
            $response = array('status' => false, 'message' => 'Invalid json');
        }
        $this->adi->_response($response);
    }

    private function curlRequest($url, $publicKey, $privateKey)
    {
        $curl = curl_init();

        curl_setopt_array($curl, array(
            CURLOPT_URL => $url,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_USERPWD => $publicKey . ":" . $privateKey,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'POST',
            CURLOPT_POSTFIELDS => 'grant_type=client_credentials',
            CURLOPT_HTTPHEADER => array(
                'Content-Type: application/x-www-form-urlencoded',

            ),
        ));

        $response = curl_exec($curl);
        curl_close($curl);
        // print_r($response);exit;
        return $res = json_decode($response);

    }
    public function refundCreate()
    {
        $response = array('status' => false, 'message' => 'Invalid json');
        $json_data = file_get_contents("php://input");
        if ($post_data = $this->adi->isValidJson($json_data)) {
            if ($post_data->id != '' && $post_data->reason != '') {
                $orderInfo = $this->DatabaseModel->fetchTableData('product_order', array('id' => $post_data->id));
                if ($orderInfo) {
                    $orderId = $orderInfo[0]->uniqe_order_id;
                    $paymentId = $orderInfo[0]->integration_id;
                    $priceAmount = $orderInfo[0]->price_amount;
                    $paymentMode = $orderInfo[0]->payment_mode;
                    $paymentAddress = $orderInfo[0]->payment_address;
                    $paymentMode = $orderInfo[0]->payment_mode;
                    $buyerEmail = $orderInfo[0]->buyer_email;
                    $price_currency = $orderInfo[0]->price_currency;
                    $integartionData = $this->DatabaseModel->fetchTableData('paypal', array('id' => $paymentId));
                    if ($paymentMode === 'sandbox') {
                        $url = 'https://www.sandbox.paypal.com/v2/payments/captures/' . $orderId . '/refund';
                        $client_id = $integartionData[0]->client_id;
                        $secret_id = $integartionData[0]->secret_id;
                    } else {
                        $url = 'https://www.paypal.com/v2/payments/captures/' . $orderId . '/refund';
                        $client_id = $integartionData[0]->live_client_id;
                        $secret_id = $integartionData[0]->live_secret_id;
                    }

                    $date = date('Y-m-d H:i:s');
                    $timeInvoice = time();
                    $curl = curl_init();

                    curl_setopt_array($curl, array(
                        CURLOPT_URL => $url,
                        CURLOPT_RETURNTRANSFER => true,
                        CURLOPT_USERPWD => $client_id . ":" . $secret_id,
                        CURLOPT_ENCODING => '',
                        CURLOPT_MAXREDIRS => 10,
                        CURLOPT_TIMEOUT => 0,
                        CURLOPT_FOLLOWLOCATION => true,
                        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                        CURLOPT_CUSTOMREQUEST => 'POST',
                        CURLOPT_POSTFIELDS => '{
                            "amount": {
                                "value": "' . $priceAmount . '",
                                "currency_code": "' . $price_currency . '"
                            },
                            "invoice_id": "' . $timeInvoice . '",
                            "note_to_payer": "' . $post_data->reason . '"
                        }',
                        CURLOPT_HTTPHEADER => array(
                            'Content-Type: application/json',
                        ),
                    ));

                    $response = curl_exec($curl);

                    curl_close($curl);
                    $res = json_decode($response);
                    if ($res) {
                        if (isset($res->debug_id)) {
                            $response = array('status' => false, 'message' => $res->message);
                        } else {
                            $update['refund_id'] = $res->id;
                            $update['request_amount'] = $priceAmount;
                            $update['refund_amount'] = $priceAmount;
                            $update['status'] = $res->status;
                            $update['is_status'] = 9;
                            $update['updated'] = $date;
                            $resData = $this->DatabaseModel->updateTable('product_order', $update, array('id' => $orderInfo[0]->id));
                            if ($resData) {
                                $insert['order_id'] = $orderInfo[0]->id;
                                $insert['reason'] = $post_data->reason;
                                $insert['refund_id'] = $res->id;
                                $insert['request_amount'] = $priceAmount;
                                $insert['refund_amount'] = $priceAmount;
                                $insert['created'] = $date;
                                $insert['updated'] = $date;
                                $insert['status'] = 1;
                                $this->DatabaseModel->insertData('order_refund', $insert);
                                $response = array('status' => true, 'message' => 'Successfully request send refund');
                            } else {
                                $response = array('status' => false, 'message' => 'Something went wrong');
                            }
                        }
                    } else {
                        $response = array('status' => false, 'message' => 'Not Found');
                    }

                } else {
                    $response = array('status' => false, 'message' => 'Not Found');
                }

            } else {
                $response = array('status' => false, 'message' => 'Messing required parameter');
            }

        } else {
            $response = array('status' => false, 'message' => 'Invalid json');
        }
        $this->adi->_response($response);

    }
    //check for user's project status inqueue update in database
    public function createOrder()
    {
        $response = array('status' => false, 'message' => 'Invalid json');
        $json_data = file_get_contents("php://input");
        if ($post_data = $this->adi->isValidJson($json_data)) {
            $date = date('Y-m-d H:i:s');
            $unique_id = abs(crc32(uniqid()));
            $postUrl = PAYPAL_URL;
            $productId = $post_data->productId;
            $name = $post_data->name;
            $email = $post_data->email;
            $priceAmount = $post_data->price_amount;
            $priceCurrency = $post_data->price_currency;
            $title = $post_data->title;
            $description = $post_data->description;
            $integration_id = $post_data->integration_id;
            $paypalInfo = $this->DatabaseModel->fetchTableData('paypal', array('id' => $integration_id));
            if (!empty($paypalInfo)) {
                $clientID = $paypalInfo[0]->client_id;
                $secretId = $paypalInfo[0]->secret_id;
                $curl = curl_init();

                curl_setopt_array($curl, array(
                    CURLOPT_URL => 'https://www.sandbox.paypal.com/v2/checkout/orders',
                    CURLOPT_RETURNTRANSFER => true,
                    CURLOPT_USERPWD => $clientID . ":" . $secretId,
                    CURLOPT_ENCODING => '',
                    CURLOPT_MAXREDIRS => 10,
                    CURLOPT_TIMEOUT => 0,
                    CURLOPT_FOLLOWLOCATION => true,
                    CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                    CURLOPT_CUSTOMREQUEST => 'POST',
                    CURLOPT_POSTFIELDS => '{
                    "intent": "CAPTURE",
                    "purchase_units": [
                        {
                            "items": [
                                {
                                    "name": "' . $title . '",
                                    "description": "' . $description . '",
                                    "quantity": "1",
                                    "unit_amount": {
                                        "currency_code": "' . $priceCurrency . '",
                                        "value": "' . $priceAmount . '"
                                    }
                                }
                            ],
                            "amount": {
                                "currency_code": "' . $priceCurrency . '",
                                "value": "' . $priceAmount . '",
                                "breakdown": {
                                    "item_total": {
                                        "currency_code": "' . $priceCurrency . '",
                                        "value": "' . $priceAmount . '"
                                    }
                                }
                            }
                        }
                    ],
                    "application_context": {
                        "return_url": "https://localhost/koincart-backend/order-success",
                        "cancel_url": "https://localhost/koincart-backend/order-cancel"
                    }
                }',
                    CURLOPT_HTTPHEADER => array(
                        'Content-Type: application/json',
                        'Cookie: LANG=en_US%3BUS; enforce_policy=ccpa; ts=vreXpYrS%3D1752230441%26vteXpYrS%3D1657537841%26vr%3Dec8baa841810a6022c95375cfa28502b%26vt%3Decd841381810a602060bf5f9fa22a520%26vtyp%3Dreturn; ts_c=vr%3Dec8baa841810a6022c95375cfa28502b%26vt%3Decd841381810a602060bf5f9fa22a520; tsrce=shoppingcartnodeweb; x-cdn=fastly:DEL; x-csrf-jwt=eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJ0b2tlbiI6IjhObDVwQWV1RWphREJnX05BUHEzN3ZtdFlnZ3M1VGl3YnROVTFheEtQNkR3U1o4NFhxR3daTERGaE9sZldVUktZRzVMeU9fajZ1NE8yQXRaNFhIOTZFOHpsYnp0Q1Raa2RPdVJkbHBOVHBuaVhPb3o0emtITjVNSmswYklZUWplcjJIbFp2dHR6OFBmeEFVZFFVc05LbFQ2VG5QTXhSVXNuaGhRQVNQMWtJb2FYSFUzQ0tzVHI5cndoYXUiLCJpYXQiOjE2NTc1MzA5OTksImV4cCI6MTY1NzUzNDU5OX0.ekEHOWvZx1S2R0QX_l2OKUivNnd9GEx3MYkP0TzB1v4; x-pp-s=eyJ0IjoiMTY1NzUzMDk5OTI0OCIsImwiOiIwIiwibSI6IjAifQ; nsid=s%3Am0U0aUX_Kx3QxLQfE8_KbiVpXLkfcQaI.Zao%2FL1aEXqLmE0r2tGY5ubih1sOT%2BDEGl9ry7I7keG8',
                    ),
                ));

                $response = curl_exec($curl);

                curl_close($curl);
                $res = json_decode($response);
                if (!empty($res) && isset($res->id)) {
                    $insert['integration_id'] = $integration_id;
                    $insert['uniqe_order_id'] = $res->id;
                    $insert['payment_method'] = 'Paypal';
                    $insert['product_id'] = $productId;
                    $insert['user_id'] = $this->user_id;
                    $insert['buyer_email'] = $email;
                    $insert['buyer_name'] = $name;
                    $insert['title'] = $title;
                    $insert['description'] = $description;
                    $insert['price_currency'] = $priceCurrency;
                    $insert['price_amount'] = $priceAmount;
                    $insert['payment_url'] = $res->links[1]->href;
                    $insert['created'] = $date;
                    $insert['updated'] = $date;
                    $insert['status'] = $res->status;
                    if ($res->status == 'CREATED') {
                        $insert['is_status'] = 1;
                    }
                    $insert['deleted'] = 0;
                    $resinset = $this->DatabaseModel->inserData('product_order', $insert);
                    if ($resinset > 0) {
                        $orderArr = array(
                            "id" => $resinset,
                            "product_id" => $productId,
                            "order_id" => $res->id,
                            "order_token" => '',
                            "payment_url" => $res->links[1]->href,
                        );
                        $response = array('status' => true, 'message' => 'Successfully create order', 'data' => $orderArr);
                    } else {
                        $response = array('status' => false, 'message' => 'Something went wrong! try again');
                    }
                } else {
                    $message = json_decode($response)->error_description;
                    $response = array('status' => false, 'message' => $message);
                }

            } else {
                $response = array('status' => false, 'message' => 'Something went wrong!');
            }

        } else {
            $response = array('status' => false, 'message' => 'Invalid json');
        }
        $this->adi->_response($response);

    }

    public function orderSuccess()
    {
        $response = array('status' => false, 'message' => 'Invalid json');
        $json_data = file_get_contents("php://input");
        print_r($json_data);exit;
        if ($post_data = $this->adi->isValidJson($json_data)) {
            $date = date('Y-m-d H:i:s');

        } else {
            $response = array('status' => false, 'message' => 'Invalid json');
        }
        $this->adi->_response($response);

    }
    public function deleteConnection()
    {
        $response = array('status' => false, 'message' => 'Invalid json');
        $json_data = file_get_contents("php://input");
        if ($post_data = $this->adi->isValidJson($json_data)) {
            $type = $post_data->type;
            $id = $post_data->id;
            $userID = $this->user_id;
            if ($userID != '' && $type != '' && $id != '') {
                $delete = $this->DatabaseModel->deleteRows('integration', array('id' => $id, 'userId' => $userID));
                if ($delete) {
                    $response = array('status' => true, 'message' => 'Successfully disconnected');
                } else {
                    $response = array('status' => false, 'message' => 'Something went wrong!');
                }

            } else {
                $response = array('status' => false, 'message' => 'Required parameter missing');
            }

        } else {
            $response = array('status' => false, 'message' => 'Invalid json');
        }
        $this->adi->_response($response);
    }

}
