<?php

/**
 * @property  passwordencryption passwordencryption
 * @property CI_Upload upload
 */

class MediaController extends CI_Controller
{
    private $user_id;
    public function __construct()
    {
        parent::__construct();
        $this->load->library('Media');
        $verify_token = $this->jwt_verify->verify_token_2();
        if ($verify_token['status'] != false) {
            $this->user_id = $verify_token['data']['user_id'];
        } else {
            $this->adi->_response($verify_token);
            die();
        }

    }

    /**
     * @param $base64_string - base64 of a file to generate media file
     * @param $format - extension of the file to generate
     * @return string - output file
     */

/**
 * Function: deleteUploadFile
 * This function will delete user's media file for given id
 *
 * Returns:
 * json object
 */
    public function deleteUploadFile()
    {
        $response = array(
            'status' => false,
            'message' => 'You are not authorize to access this location',
        );
        if ($this->input->server('REQUEST_METHOD') == 'POST') {
            $data['id'] = $this->input->post('id');
            $data['user_id'] = $this->user_id;
            $res = $this->DatabaseModel->exists('user_library', $data);
            if ($res) {
                $library = $this->DatabaseModel->fetchTableData('user_library', $data);
                if ($this->DatabaseModel->deleteRows('user_library', $data)) {

                    if (file_exists(FCPATH . $library[0]->file)) {
                        unlink(FCPATH . $library[0]->file);
                    }
                    $response = array('message' => 'File deleted successfully', 'status' => true);

                }
            } else {
                $response = array('message' => 'Unable to delete this file', 'status' => false);
            }
        }
        $this->adi->_response($response, $this->user_id);die();
    }

}