<?php
require 'vendor/setasign/fpdf/fpdf.php';

defined('BASEPATH') or exit('No direct script access allowed');

class InvoiceController extends CI_Controller
{
    public function __construct()
    {
        parent::__construct();
        $verify_token = $this->jwt_verify->verify_token_2();
        if ($verify_token['status'] != false) {
            $this->user_id = $verify_token['data']['user_id'];
        } else {
            $this->adi->_response($verify_token);
            die();
        }

    }

    public function generateInvoice()
    {
        $jsonData = file_get_contents("php://input");
        if ($postData = $this->adi->isValidJson($jsonData)) {
            $bid = $postData->bid;
            $pid = $postData->pid;
            $cid = $postData->cid;
            if ($bid != '' && $pid != '' && $cid != '') {
                $bd = $this->DatabaseModel->fetchTableData('business', array('id' => $bid, 'userId' => $this->user_id));
                $pd = $this->DatabaseModel->fetchTableData('product', array('id' => $pid, 'bid' => $bid, 'userId' => $this->user_id));
                $cd = $this->DatabaseModel->fetchTableData('customers', array('id' => $cid, 'userId' => $this->user_id));

                $insertData = array(
                    'userId' => $this->user_id,
                    'name' => $cd ? $cd[0]->name : '',
                    'email' => $cd ? $cd[0]->email : '',
                    'isPhone' => $cd ? $cd[0]->isPhone : '',
                    'bid' => $bid,
                    'pid' => $pid,
                    'productName' => $pd ? $pd[0]->name : "",
                    'isDeleted' => 0,
                    'paidby' => 'Pending',
                    'status' => 1,
                    'paymentStatus' => 'Non Paid',
                    'created' => date('Y-m-d H:i:s'),
                );
                $res = $this->DatabaseModel->insertData('customers', $insertData);
                $pdf = new FPDF();
                $pdf->AddPage();

                $pdf->SetFont('Arial', 'B', 14);
                $pdf->Cell(50, 10, $bd[0]->name, 0, 1);
                $pdf->SetFont('Arial', '', 14);
                $pdf->Cell(50, 7, $bd[0]->email, 0, 1);
                $pdf->Cell(50, 7, $bd[0]->phone, 0, 1);
                $pdf->Cell(50, 7, $bd[0]->address, 0, 1);

                //Display INVOICE text
                $pdf->SetY(15);
                $pdf->SetX(-40);
                $pdf->SetFont('Arial', 'B', 18);
                $pdf->Cell(50, 10, "INVOICE", 0, 1);

                //Display Horizontal line
                $pdf->Line(0, 48, 210, 48);
                //Billing Details
                $pdf->SetY(55);
                $pdf->SetX(10);
                $pdf->SetFont('Arial', 'B', 12);
                $pdf->Cell(50, 10, "Bill To: ", 0, 1);
                $pdf->SetFont('Arial', '', 12);
                $pdf->Cell(50, 7, $cd[0]->name, 0, 1);
                $pdf->Cell(50, 7, $cd[0]->address, 0, 1);
                $pdf->Cell(50, 7, $cd[0]->email, 0, 1);

                //   $pdf->Image($bd[0]->logo,100,7,50,50,"png");

                //Display Invoice no
                $pdf->SetY(55);
                $pdf->SetX(-60);
                $pdf->Cell(50, 7, "Invoice No : 1");

                //Display Invoice date
                $pdf->SetY(63);
                $pdf->SetX(-60);
                $pdf->Cell(50, 7, "Invoice Date : " . date('Y-m-d'));

                //Display Table headings
                $pdf->SetY(95);
                $pdf->SetX(10);
                $pdf->SetFont('Arial', 'B', 12);
                $pdf->Cell(80, 9, "PRODUCT NAME", 1, 0);
                $pdf->Cell(40, 9, "PRICE", 1, 0, "C");
                $pdf->Cell(30, 9, "QTY", 1, 0, "C");
                $pdf->Cell(40, 9, "TOTAL", 1, 1, "C");
                $pdf->SetFont('Arial', '', 12);

                //Display table product rows

                $pdf->Cell(80, 9, $pd[0]->name, "LR", 0);
                $pdf->Cell(40, 9, $pd[0]->price, "R", 0, "R");
                $pdf->Cell(30, 9, 1, "R", 0, "C");
                $pdf->Cell(40, 9, $pd[0]->price, "R", 1, "R");

                //Display table empty rows
                for ($i = 0; $i < 6; $i++) {
                    $pdf->Cell(80, 9, "", "LR", 0);
                    $pdf->Cell(40, 9, "", "R", 0, "R");
                    $pdf->Cell(30, 9, "", "R", 0, "C");
                    $pdf->Cell(40, 9, "", "R", 1, "R");
                }
                //Display table total row
                $pdf->SetFont('Arial', 'B', 12);
                $pdf->Cell(150, 9, "TOTAL", 1, 0, "R");
                $pdf->Cell(40, 9, $pd[0]->price, 1, 1, "R");

                $pdf->SetY(-50);
                $pdf->SetFont('Arial', 'B', 12);
                $pdf->Cell(0, 10, $bd[0]->name, 0, 1, "R");
                $pdf->Ln(5);
                //Display Footer Text
                $pdf->SetFont('Arial', '', 10);
                $pdf->Cell(0, 10, "This is a computer generated invoice", 0, 1, "C");

                $pdf->Output('F', 'uploads/pdf/invoice.pdf');
                $file = base_url() . 'uploads/pdf/invoice.pdf';
                $body = 'Attached is your invoice. Please click the link to pay your invoice';
                $this->_mail($cd[0]->email, 'INVOICE', $body, $file);

                $response = array('status' => true, 'message' => 'Invoice generated successfully.');

            } else {
                $response = array('status' => false, 'message' => 'Require parameter missing.');
            }
        } else {
            $response = array('status' => false, 'message' => "Invalid Json.");
        }
        $this->adi->_response($response);
    }
    public function _mail($to, $subject, $body, $attachment)
    {

        $res = $this->DatabaseModel->fetchTableData('smtp');
        $config = array(

            'protocol' => $res[0]->protocol,
            'smtp_host' => $res[0]->smtp_host,
            'smtp_port' => $res[0]->smtp_port,
            'smtp_user' => $res[0]->smtp_user,
            'smtp_pass' => $res[0]->smtp_pass,
            'smtp_crypto' => $res[0]->smtp_crypto,
            'smtp_timeout' => $res[0]->smtp_timeout,
            'mailtype' => $res[0]->mailtype,
            'charset' => $res[0]->charset,
        );

        $this->load->library('email', $config);
        $this->email->set_newline("\r\n");
        $this->email->from('abhi@abhineos.com', APP_NAME);
        $this->email->to($to); // replace it with receiver mail id
        $this->email->subject($subject); // replace it with relevant subject
        $this->email->message($body);
        $this->email->attach($attachment);
        $this->email->send();

    }
}
