<?php

/**
 * @property DatabaseModel DatabaseModel
 * @property CI_User_agent agent
 */

defined('BASEPATH') or exit('No direct script access allowed');

class Home extends CI_Controller
{

    public function __construct()
    {
        parent::__construct();
    }
    public function index()
    {
        echo "welcome";

        // $currentPageUrl = $_SERVER["HTTP_HOST"] . $_SERVER["REQUEST_URI"];
        // $url = explode('.', $currentPageUrl);
        // if ($url[2] === 'io/product/') {
        //     $this->load->view('web_publishing/404page/index.php');
        // } else if ($url[2] === 'io/product') {
        //     $this->load->view('web_publishing/404page/index.php');
        // } else if ($url[2] === 'io/') { 
        //     $data['data'] = $this->DatabaseModel->fetchTableData('business', array('businessUrl' => $url[0], 'isDeleted' => 0));
        //     $data['product'] = $this->DatabaseModel->fetchTableData('product', array('bid' => $data[data][0]->id, 'isDeleted' => 0));
        //     $data['baseCurrency'] = $this->DatabaseModel->getField('symbol','users','id',$data['product'][0]->userId);
        //     if ($data) {
        //         $this->load->view('web_publishing/business/index.php', $data);
        //     } else {
        //         $this->load->view('web_publishing/404page/index.php');
        //     }
        // } else if ($url[2]) {
        //     $slug = explode('/', $url[2]);
        //     if (!empty($slug[2])) {
        //         $data['pro'] = $this->DatabaseModel->fetchTableData('product', array('slug' => $slug[2], 'isDeleted' => 0));
        //          if (!empty($data['pro'])) {
        //             $productBid = $data['pro'][0]->bid;
        //             $data['baseCurrency'] = $this->DatabaseModel->getField('symbol','users','id',$data['pro'][0]->userId);
        //             $data['data'] = $this->DatabaseModel->fetchTableData('business', array('id' => $productBid, 'isDeleted' => 0));
        //             $this->load->view('web_publishing/product_page/index.php', $data);
        //         } else {
        //             $this->load->view('web_publishing/404page/index.php');
        //         }

        //     } else {
        //         $this->load->view('web_publishing/404page/index.php');
        //     }
        // }

    }

    public function logout()
    {
        $verify_token = $this->jwt_verify->verify_token_2();
        // dd($verify_token);
        if ($verify_token['status'] != false) {
            $user_id = $verify_token['data']['user_id'];
            $token = $verify_token['token'];

        } else {
            echo json_encode($verify_token);
            // $this->adi->_response($verify_token);
            die();
        }

        $result = $this->DatabaseModel->fetchTableData('user_logs', array('userid' => $user_id));
        $log = current($result);
        $this->DatabaseModel->updateTable('user_logs', array('logout_at' => date("Y-m-d h:i:s")), array('id' => $log->id));
        $this->DatabaseModel->updateTable('tokens', array('deleted' => 1), array('token' => $token));

        $response = array(
            'status' => true,
            'message' => 'User logged out successfully',
        );
        $this->adi->_response($response, $user_id);
    }

    public function not_found()
    {
        die('404 Not found');
    }

    public function masterLogin()
    {
        $response = array(
            'status' => false,
            'message' => 'Unauthorized access',
        );

        $json_data = file_get_contents("php://input");
        if ($json_data = $this->adi->isValidJSON($json_data)) {
            $data = array(
                'email' => str_replace(' ', '', $json_data->email),
                'deleted' => 0,
                'is_super_admin' => 1,
                'status' => 1,
            );

            $check = $this->DatabaseModel->fetchTableData('users', $data);
            if (!empty($check)) {
                if (($check[0]->status == 1)) {
                    $dataNew = array(
                        'email' => str_replace(' ', '', $json_data->useremail),
                        'deleted' => 0,
                    );
                    $user = $this->DatabaseModel->fetchTableData('users', $dataNew);
                    if ($user) {
                        if ($user[0]->status == 1) {

                            $user_id = $user[0]->id;
                            $this->adi->_loginLogs($user[0]->email);
                            $response['data'] = $this->_token($user[0]);

                        } else {
                            $response['message'] = 'user status is 0';

                        }
                        $response['message'] = 'Your account is not activated';
                    } else {
                        $response['message'] = 'User email is not exist';
                    }

                } else {
                    $response['message'] = 'Email or Password is incorrect Super admin';

                }
            } else {
                $response['message'] = 'Super admin Not Exist';

            }
        } else {
            $response['message'] = 'invalid json data';
        }

        $this->adi->_response($response, $check[0]->id);die();
    }

    private function _token($user)
    {
        unset($user->password);
        $ip = $this->input->ip_address();
        if (!isset($user->id)) {
            $response = array(
                'status' => false,
                'code' => 210,
                'error' => array(
                    'errors' => array(
                        'message' => 'Invalid username or password',
                    ),
                ),
                '_serialize' => array(
                    'status', 'code', 'error',
                ));
        } else {
            if ($user->is_virtual_account) {
                $parent = $this->DatabaseModel->fetchTableData('users', array('id' => $user->parent_id));
                $token = $this->jwt_client->create_token($parent[0]->id, $parent[0]->email, $ip);
                $response = array(
                    'status' => true,
                    'code' => 200,
                    'data' => array(
                        'token_type' => 'Authorization',
                        'token' => $token['token'],
                        'user' => $user,
                    ),
                );
            } else {
                $token = $this->jwt_client->create_token($user->id, $user->email, $ip);
                $response = array(
                    'status' => true,
                    'code' => 200,
                    'data' => array(
                        'token_type' => 'Authorization',
                        'token' => $token['token'],
                        'user' => $user,
                    ),
                );
            }
        }
        echo json_encode($response);
        die;
    }

    public function validate_login()
    {
        $json_params = file_get_contents("php://input");
        if (isset($json_params)) {
            $check_response = $this->adi->isValidJSON($json_params);
            if ($check_response != false) {
                $email = trim($check_response->email);
                $password = trim($check_response->password);
                if ($email && $password) {
                    $validate = $this->DatabaseModel->validateLogin($email, $password);
                    if (!empty($validate['status'])) {

                        $ip = $this->input->ip_address();
                        $token_check = $this->jwt_client->create_token($validate['data']->id, $email, $ip);
                        if ($token_check['token_type'] == 'Authorization') {
                            $user = $this->DatabaseModel->fetchTableData('users', array('id' => $validate['data']->id));

                            if (!empty($user[0]->membership)) {
                                $user = $user;
                            } else {
                                $parent_user = $this->DatabaseModel->fetchTableData('users', array('id' => $user[0]->parent));

                                $user[0]->membership = $parent_user[0]->membership;
                                $user[0]->baseCurrency = $parent_user[0]->baseCurrency;

                            }

                            $user = $user[0];
                            unset($user->password);
                            unset($user->hash);
                            unset($user->password_token);

                            if ($validate['data']->is_client_account) {
                                $user_details['is_client_account'] = true;

                            }

                            /**
                             * Add Login Logs
                             */
                            $this->adi->_loginLogs($email);
                            $return = array('status' => true, 'data' => array(
                                'token_type' => $token_check['token_type'],
                                'token' => $token_check['token'],
                                'user' => $user,
                            ));

                        } else {
                            $return = array('status' => false, 'message' => $token_check['message']);
                        }
                    } else {
                        $return = array('status' => false, 'message' => $validate['message']);
                    }
                } else {
                    $return = array('status' => false, 'message' => 'Email or password is missing.');
                }
            } else {
                $return = array('status' => false, 'message' => 'Invalid json.');
            }
            $this->adi->_response($return);
        } else {
            redirect('not_found');
        }
    }

    /** Function: forgotPassword
     * This function will load the forgot password page and will ask user to enter
     * his/her email address to find his/her account. And send email with link
     * to reset password if email is valid.
     */

    public function forgotPassword()
    {
        $response = array(
            'status' => false,
            'message' => 'Request method not allowed',
        );

        $json_data = file_get_contents("php://input");

        if ($json_data = $this->adi->isValidJSON($json_data)) {
            $data = array(
                'email' => $json_data->email,
            );
            if ($this->DatabaseModel->exists('users', $data)) {
                $password = rand(999, 99999);
                $password_hash = md5($password);
                $email = $json_data->email;
                if ($this->DatabaseModel->exists('users', array('email' => $email))) {
                    $user = $this->DatabaseModel->fetchTableData('users', array('email' => $email));
                    $this->DatabaseModel->updateTable('users', array('hash' => $password_hash), array('id' => $user[0]->id));

                    $url = FE_URL . "reset-password?token=" . $password_hash;
                    $body = $this->load->view('password_reset_mail', array('url' => $url), true);
                    $this->adi->_mail($data['email'], 'Reset Password |' . APP_NAME, $body);
                }

                $response['status'] = true;
                $response['message'] = 'If an account exist with provided email you will receive an email. Please follow the instruction to reset your password.';

            } else {
                $response['status'] = false;
                $response['message'] = 'if an account exist with provided email you will receive an email. Please follow the instruction to reset your password.';
            }
        }
        $this->adi->_response($response);

    }

    public function resetPassword()
    {
        $json_params = file_get_contents("php://input");

        $data = array('status' => false);
        if (isset($json_params)) {
            $check_response = $this->adi->isValidJSON($json_params);

            if ($check_response != false) {
                $new_password = trim($check_response->password);
                $confirm_password = trim($check_response->confirm_password);
                // $hash_code = trim($check_response->password_token);

                $data = array('hash' => $check_response->password_token); // pass hash_code in token variable available in user table

                if ($new_password == $confirm_password) {

                    if ($this->DatabaseModel->exists('users', $data)) {
                        $password = rand(999, 99999);
                        $password_hash = md5($password);
                        $options = array('cost' => 13);
                        $hash = password_hash($new_password, PASSWORD_DEFAULT, $options);
                        $user = $this->DatabaseModel->fetchTableData('users', $data);
                        $update_data = array('hash' => $password_hash, 'password' => $hash);
                        if ($this->DatabaseModel->updateTable('users', $update_data, array('id' => $user[0]->id))) {
                            $this->DatabaseModel->updateTable('tokens', array('deleted' => 0), array('user_id' => $user[0]->id));
                            $data['status'] = true;
                            $data['message'] = 'Password changed successfully.';
                        }
                        if (!empty($user[0]->id)) {
                        }
                    } else {
                        $data['message'] = 'Sorry this url is expired.';
                    }
                } else {
                    $data['message'] = 'Your password did not match.';
                }
            } else {
                $data['message'] = 'Invalid json data';
            }
        } else {
            $data['message'] = 'Unauthorized access';
        }

        $this->adi->_response($data);

    }

    
    public function delete_uploads_older_than_7_days()
    {
        $path = realpath('uploads/');
        $now   = time(); // now time
        //$allowed_extension_to_delete = ['mp4', 'webm'];

        $objects = new RecursiveIteratorIterator(new RecursiveDirectoryIterator($path));
        $i = 1;
        $deleted = false;
        foreach($objects as $name => $object){
            if (!is_file($name)) {
                continue;
            }

            // get extension
            // $file_extension = end(explode('.', $name));
            // // continue if file is not in allowed extension to delete
            // if (!in_array($file_extension, $allowed_extension_to_delete)) {
            //     continue;
            // }

            // check file info and delete
            if (is_file($name)) {
                if(strpos($name,'profile') === false && strpos($name,'user-big.png') === false)
                {
                    if ($now - filemtime($name) >= 60 * 60 * 24 * 7) {  // files older than 7 day
                        // delete file now
                        unlink($name);

                        $deleted = true;
                        echo 'deleted ------->' . $name . "<br />";
                    }
                }
            }

        }

        if ($deleted) {
            echo '<br/>All scheduled files deleted<br/>';
        } else {
            echo '<br/>No files deleted, maybe there is no file older than 7 day<br/>';
        }
    }

}
