<?php
class CustomerController extends CI_Controller
{

    private $user_id;
    public function __construct()
    {
        parent::__construct();
        $verify_token = $this->jwt_verify->verify_token_2();
        if ($verify_token['status'] != false) {
            $this->user_id = $verify_token['data']['user_id'];
        } else {
            $this->adi->_response($verify_token);
            die();
        }

    }
    public function createCustomer()
    {
        $jsonData = file_get_contents("php://input");
        if ($postData = $this->adi->isValidJson($jsonData)) {

            $userId = $this->user_id;
            $name = $postData->name;
            $email = $postData->email;
            $phone = $postData->phone;
            $bid = $postData->bid;
            $pid = $postData->pid;
            $productName = $this->DatabaseModel->fetchTableData('product', array('id' => $pid));

            $insertData = array(
                'userId' => $userId,
                'name' => $name,
                'email' => $email,
                'isPhone' => $phone,
                'bid' => $bid,
                'pid' => $pid,
                'productName' => $productName ? $productName[0]->name : "",
                'isDeleted' => 0,
                'status' => 1,
                'created' => date('Y-m-d H:i:s'),

            );

            $res = $this->DatabaseModel->insertData('customers', $insertData);
            if ($res) {
                $response = array('status' => true, 'message' => 'Client created successfully.');
            } else {
                $response = array('status' => false, 'message' => 'Not created.');
            }
            date_default_timezone_set('Asia/Calcutta');

        } else {
            $response = array('status' => false, 'message' => 'Invalid json');
        }
        $this->adi->_response($response);
    }

    public function updateCustomer()
    {
        $jsonData = file_get_contents("php://input");
        if ($postData = $this->adi->isValidJson($jsonData)) {
            $id = $postData->id;
            $userId = $this->user_id;
            $name = $postData->name;
            $email = $postData->email;
            $phone = $postData->phone;
            $bid = $postData->bid;
            $pid = $postData->pid;

            $productName = $this->DatabaseModel->fetchTableData('product', array('id' => $pid));

            $updateData = array(
                'name' => $name,
                'email' => $email,
                'isPhone' => $phone,
                'bid' => $bid,
                'pid' => $pid,
                'productName' => $productName ? $productName[0]->name : '',
                'modified' => date('Y-m-d H:i:s'),

            );

            $res = $this->DatabaseModel->updateTable('customers', $updateData, array('id' => $id, 'userId' => $userId));
            if ($res) {
                $response = array('status' => true, 'message' => 'Client updated successfully.');
            } else {
                $response = array('status' => false, 'message' => 'Client not update.');
            }

        } else {
            $response = array('status' => false, 'message' => 'Invalid json');
        }
        $this->adi->_response($response);

    }

    public function deleteCustomer()
    {
        $jsonData = file_get_contents("php://input");
        if ($postData = $this->adi->isValidJson($jsonData)) {
            $id = $postData->id;
            $res = $this->DatabaseModel->updateTable('customers', array('isDeleted' => 1), array('id' => $id, 'userId' => $this->user_id));
            if ($res) {
                $response = array('status' => true, 'message' => 'Deleted successfully.');
            } else {
                $response = array('status' => false, 'message' => 'Not deleted.');
            }

        } else {
            $response = array('status' => false, 'message' => 'Invalid json.');
        }

        $this->adi->_response($response);
    }

    public function viewCustomer()
    {
        $jsonData = file_get_contents("php://input");
        if ($postData = $this->adi->isValidJson($jsonData)) {
            $id = $postData->id;
            $res = $this->DatabaseModel->fetchTableData('customers', array('id' => $id, 'userId' => $this->user_id, 'isDeleted' => 0));
            if ($res) {
                $response = array('status' => true, 'data' => $res);
            } else {
                $response = array('status' => false, 'message' => 'Data not found.');
            }
        } else {
            $response = array('status' => false, 'message' => 'Invalid  json.');
        }

        $this->adi->_response($response);
    }

    public function countCustomer()
    {
        $customer = $this->DatabaseModel->fetchTableData('customers', array('userId' => $this->user_id, 'isDeleted' => 0, 'status' => 1, 'bid' => 0, 'pid' => 0));
        $totalCount = count($customer);
        $sum = 0;
        if (!empty($customer)) {
            foreach ($customer as $key => $value) {
                $product = $this->DatabaseModel->fetchTableData('product', array('id' => $value->pid, 'isDeleted' => 0));
                foreach ($product as $key => $val) {
                    $sum += $val->price;

                }

            }

        }
        $data = array(
            'totalCustomer' => $totalCount,
            'totalRevenue' => $sum,
        );
        $response = array('status' => true, 'data' => $data);
        $this->adi->_response($response);

    }

    public function customerList()
    {
        $jsonData = file_get_contents("php://input");
        if ($postData = $this->adi->isValidJson($jsonData)) {
            if (isset($postData->bid)) {
                $bid = $postData->bid;

            }

            if (!empty($bid)) {
                $res = $this->DatabaseModel->fetchTableData('customers', array('bid' => $bid, 'userId' => $this->user_id, 'isDeleted' => 0));
                if ($res) {
                    foreach ($res as $key => $val) {

                        $productDetails = $this->DatabaseModel->fetchTableData('product', array('id' => $val->pid, 'userId' => $this->user_id, 'isDeleted' => 0));

                        $res[$key]->productinfo = $productDetails;
                    }
                    $response = array('status' => true, 'data' => $res);
                } else {
                    $response = array('status' => false, 'message' => "Data Not Found");
                }

            } else {
                $res = $this->DatabaseModel->fetchTableData('customers', array('bid' => 0, 'userId' => $this->user_id, 'isDeleted' => 0));
                if ($res) {
                    foreach ($res as $key => $val) {

                        $productDetails = $this->DatabaseModel->fetchTableData('product', array('id' => $val->pid, 'userId' => $this->user_id, 'isDeleted' => 0));

                        $res[$key]->productinfo = $productDetails;
                    }
                    $response = array('status' => true, 'data' => $res);
                } else {
                    $response = array('status' => false, 'message' => "Data Not Found");
                }

            }

        } else {
            $response = array('status' => false, 'message' => 'Invalid  json.');
        }

        $this->adi->_response($response);

    }

}
