<?php
class CouponController extends CI_Controller
{
    private $user_id;
    public function __construct()
    {
        parent::__construct();
        $verify_token = $this->jwt_verify->verify_token_2();
        if ($verify_token['status'] != false) {
            $this->user_id = $verify_token['data']['user_id'];
        } else {
            $this->adi->_response($verify_token);
            die();
        }

    }

    public function createCoupon()
    {
        $jsonData = file_get_contents("php://input");
        if ($postData = $this->adi->isValidJson($jsonData)) {
            $insert['userId'] = $this->user_id;
            $insert['couponStart'] = $postData->couponStart;
            $insert['couponTo'] = $postData->couponTo;
            $insert['couponType'] = $postData->couponType;
            $insert['couponAmount'] = $postData->couponAmount;
            $insert['couponCode'] = $postData->couponCode;
            $insert['couponDescription'] = $postData->couponDescription;
            $insert['isDeleted'] = 0;
            $insert['status'] = $postData->status; // Deactive 1,  active 0
            $insert['created'] = date('Y-m-d H:i:s');
            $check_coupon_code = $this->DatabaseModel->fetchTableData('coupon', array('userId' => $this->user_id));
            if ($check_coupon_code[0]->couponCode != $postData->couponCode) {
                $res = $this->DatabaseModel->insertData('coupon', $insert);
                if ($res) {
                    $response = array('status' => true, 'message' => 'Coupon created successfully.');

                } else {
                    $response = array('status' => false, 'message' => 'Coupon not created.');
                }
            } else {
                $response = array('status' => false, 'message' => 'Coupon already exist.');
            }

        } else {
            $response = array('status' => false, 'message' => 'Invalid json.');
        }
        $this->adi->_response($response);
    }

    public function updateCoupon()
    {
        $jsonData = file_get_contents("php://input");
        if ($postData = $this->adi->isValidJson($jsonData)) {
            $id = $postData->id;
            $insertData = array(
                'couponStart' => $postData->couponStart,
                'couponTo' => $postData->couponTo,
                'couponType' => $postData->couponType,
                'couponAmount' => $postData->couponAmount,
                'couponCode' => $postData->couponCode,
                'couponDescription' => $postData->couponDescription,
                'status' => $postData->status,

                'updated' => date('Y-m-d H:i:s'),
            );
            $res = $this->DatabaseModel->updateTable('coupon', $insertData, array('id' => $id));
            if ($res) {
                $response = array('status' => true, 'message' => 'Coupon updated successfully.');
            } else {
                $response = array('status' => false, 'message' => 'Coupon not updated.');
            }

        } else {
            $response = array('status' => false, 'message' => 'Invalid json');
        }
        $this->adi->_response($response);
    }

    public function deleteCoupon()
    {
        $jsonData = file_get_contents("php://input");
        if ($postData = $this->adi->isValidJson($jsonData)) {
            $id = $postData->id;
            $res = $this->DatabaseModel->updateTable('coupon', array('isDeleted' => 1), array('id' => $id));
            if ($res) {
                $response = array('status' => true, 'message' => 'Coupon deleted successfully.');
            } else {
                $response = array('status' => false, 'message' => 'Coupon not deleted.');
            }
        } else {
            $response = array('status' => false, 'message' => 'Invalid json');
        }
        $this->adi->_response($response);
    }

    public function assignCoupon()
    {
        $jsonData = file_get_contents("php://input");
        if ($postData = $this->adi->isValidJson($jsonData)) {
            $cid = $postData->cid;
            $pid = $postData->pid;
            $bid = $postData->bid;
            $insert['userId'] = $this->user_id;
            $insert['cid'] = $cid;
            $insert['pid'] = $pid;
            $insert['bid'] = $pid;
            $insert['status'] = 1;
            $insert['created'] = date('Y-m-d H:i:s');
            $this->DatabaseModel->updateTable('coupon', array('status' => 1), array('id' => $cid));
            $res = $this->DatabaseModel->insertData('coupon_product_assign', $insert);
            if ($res) {
                $response = array('status' => true, 'message' => 'Coupon applied successfully.');
            } else {
                $response = array('status' => false, 'message' => 'Coupon is not applied.');
            }

        } else {
            $response = array('status' => false, 'message' => 'Invalid json.');
        }
        $this->adi->_response($response);
    }

    public function verifyCoupon()
    {
        $jsonData = file_get_contents("php://input");
        if ($postData = $this->adi->isValidJson($jsonData)) {
            $couponCode = $postData->couponCode;
            $productId = $postData->productId;

            if (isset($couponCode) && !empty($productId)) {

                $productsDetails = $this->DatabaseModel->fetchTableData('coupon_product_assign', array('pid' => $productId));

                if (!empty($productsDetails)) {
                    $couponID = $productsDetails[0]->cid;
                    $couponDetails = $this->DatabaseModel->fetchTableData('coupon', array('id' => $couponID, 'couponCode' => $couponCode));
                    if (!empty($couponDetails)) {
                        $couponStart = $couponDetails[0]->couponStart;
                        $couponTo = $couponDetails[0]->couponTo;
                        $couponAmount = $couponDetails[0]->couponAmount;
                        $couponType = $couponDetails[0]->couponType;
                        $coupopnId = $couponDetails[0]->id;
                        $cid = $productsDetails[0]->cid;
                        if ($coupopnId == $cid) {
                            $currentDate = date('Y-m-d H:i:s');
                            if (strtotime($couponStart) <= strtotime($currentDate)) {
                                if (strtotime($couponTo) >= strtotime($currentDate)) {
                                    $dataArr = array(
                                        "discountAmount" => $couponAmount,
                                        "discountType" => $couponType,
                                    );
                                    $response = array('status' => true, 'message' => 'Successfully apply coupon', 'data' => $dataArr);
                                    echo json_encode($response);die();
                                } else {
                                    $response = array('status' => false, 'message' => 'This Coupon is expired');
                                    echo json_encode($response);die();
                                }

                            } else {
                                $response = array('status' => false, 'message' => 'Invalid Coupon');
                                echo json_encode($response);die();
                            }

                        } else {
                            $response = array('status' => false, 'message' => 'Invalid Coupon');
                            echo json_encode($response);die();
                        }
                    } else {
                        $response = array('status' => false, 'message' => 'Invalid Coupon');
                        echo json_encode($response);die();
                    }

                } else {
                    $response = array('status' => false, 'message' => 'Invalid Coupon');
                    echo json_encode($response);die();
                }

            } else {
                $response = array('status' => false, 'message' => 'Please enter coupon code');
                echo json_encode($response);die();
            }
        }

    }

    public function listCoupon()
    {
        $res = $this->DatabaseModel->fetchTableData('coupon', array('userId' => $this->user_id, 'isDeleted' => 0));
        if ($res) {
            $response = array('status' => true, 'data' => $res);
        } else {
            $response = array('status' => false, 'message' => 'Coupon not found.');
        }
        $this->adi->_response($response);
    }

    public function viewCoupon()
    {
        $jsonData = file_get_contents("php://input");
        if ($postData = $this->adi->isValidJson($jsonData)) {
            $id = $postData->id;
            $res = $this->DatabaseModel->fetchTableData('coupon', array('userId' => $this->user_id, 'isDeleted' => 0, 'id' => $id));
            if ($res) {
                $response = array('status' => true, 'data' => $res);
            } else {
                $response = array('status' => false, 'message' => 'Coupon not found.');
            }

        } else {
            $response = array('status' => false, 'message' => 'Invalid json');
        }

        $this->adi->_response($response);
    }
}
