<?php
class BusinessController extends CI_Controller
{
    private $user_id;
    public function __construct()
    {
        parent::__construct();
        $verify_token = $this->jwt_verify->verify_token_2();
        if ($verify_token['status'] != false) {
            $this->user_id = $verify_token['data']['user_id'];
        } else {
            $this->adi->_response($verify_token);
            die();
        }

    }

    private function createSubdomain($storeName)
    {
            if ($storeName != '') {
                $subdomain = str_replace(' ', '-', $storeName);
                $subdomain = str_replace('.', '-', $subdomain);
                $subdomain = str_replace('&', '-', $subdomain);
                $subdomain = str_replace("'", '', $subdomain);

                // your cPanel username
                $cpanel_user = USER_NAME_CPANEL;

                // your cPanel password
                $cpanel_pass = USER_PASS_CPANEL;

                // your cPanel domain
                $cpanel_host = CPANEL_HOST;

                // subdomain name
                //$subdomain = $domain;

                // directory - defaults to public_html/subdomain_name
                $dir = 'yourstartup.business';

                // create the subdomain

                $sock = fsockopen($cpanel_host, 2082);
                if (!$sock) {
                    $response = array('status' => true, 'message' => 'Socket error!');
                    //print('Socket error');
                    exit();
                }

                $pass = base64_encode("$cpanel_user:$cpanel_pass");

                $buildRequest = "http://yourstartup.business:2082/cpsess5838930081/json-api/cpanel?cpanel_jsonapi_user=$cpanel_user&cpanel_jsonapi_apiversion=2&cpanel_jsonapi_module=SubDomain&cpanel_jsonapi_func=addsubdomain&rootdomain=yourstartup.business&canoff=1&disallowdot=0&domain=$subdomain&subdomain=$subdomain&dir=$dir";

                // Make the API call
                $curl = curl_init();
                curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, 0);
                curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, 0);
                curl_setopt($curl, CURLOPT_HEADER, 0);
                curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
                $header[0] = "Authorization: Basic " . base64_encode($cpanel_user . ":" . $cpanel_pass) . "\n\r";
                curl_setopt($curl, CURLOPT_HTTPHEADER, $header);
                curl_setopt($curl, CURLOPT_URL, $buildRequest);
                $result = curl_exec($curl);

                // Check the result
                if ($result == false) {
                    error_log("curl_exec threw error \"" . curl_error($curl) . "\" for $buildRequest");
                }
                curl_close($curl);
                $var = json_decode($result);
               
                $res = $var->cpanelresult->data[0]->reason;
                if (strpos($res, "has been added.")) {
                    $response = array('status' => true, 'message' => 'subdomain created');

                } else {
                    $response = array('status' => false, 'message' => 'Already added');
                }

            } else {
                $response = array('status' => false, 'message' => 'Required parameter missing');
            }
            return $response;
    }

    public function createBusiness()
    {
        $jsonData = file_get_contents("php://input");
        if ($postData = $this->adi->isValidJson($jsonData)) {
            $userId = $this->user_id;
            $name = $postData->name;
            $description = $postData->description;
            $check = $this->createSubdomain($postData->businessUrl);
            if($check['status'])
            {
                $insertData = array(
                    'userId' => $userId,
                    'name' => $name,
                    'socialMedia' => '',
                    'description' => $description,
                    'businessUrl' => $postData->businessUrl,
                    'url' => $postData->businessUrl.'.bizbookpay.com',
                    'logo' => base_url() . 'assets/images/business.png',
                    'status' => 1,
                    'created' => date('Y-m-d H:i:s'),

                );
                $res = $this->DatabaseModel->insertData('business', $insertData);
                if ($res) {
                    $response = array('status' => true, 'data' => $res, 'message' => 'Business created successfully.');
                } else {
                    $response = array('status' => false, 'message' => 'Business not created.');
                }
            }
            else{
                $response = array('status' => false, 'message' => $check['message']);
            }
        } else {
            $response = array('status' => false, 'message' => 'Invalid json');
        }
        $this->adi->_response($response);
    }

    public function duplicateBusiness()
    {
        $jsonData = file_get_contents("php://input");
        if ($postData = $this->adi->isValidJson($jsonData)) {
            $id = $postData->id;
            $res = $this->DatabaseModel->fetchTableData('business', array('id' => $id));
            date_default_timezone_set('Asia/Calcutta');
            $insert = array(
                'name' => $res[0]->name,
                'userId' => $res[0]->userId,
                'email' => $res[0]->email,
                'description' => $res[0]->description,
                'socialMedia' => $res[0]->socialMedia,
                'phone' => $res[0]->phone,
                'address' => $res[0]->address,
                'timezone' => $res[0]->timezone,
                'timeFormat' => $res[0]->timeFormat,
                'openingHour' => $res[0]->openingHour,
                'design' => $res[0]->design,
                'businessUrl' => '',
                'localDefault' => $res[0]->localDefault,
                'mode' => $res[0]->mode,
                'logo' => $res[0]->logo,
                'isDeleted' => $res[0]->isDeleted,
                'status' => $res[0]->status,
                'created' => date('Y-m-d H:i:s'),
            );

            $res = $this->DatabaseModel->insertData('business', $insert);
            if ($res) {
                $response = array('status' => true, 'message' => 'Duplicate business created.');
            } else {
                $response = array('status' => false, 'message' => 'Business not duplicated.');
            }

        } else {
            $response = array('status' => false, 'message' => 'Invalid json');
        }
        $this->adi->_response($response);
    }

    public function updateBusiness()
    {
        $jsonData = file_get_contents("php://input");
        if ($postData = $this->adi->isValidJson($jsonData)) {
            $userId = $this->user_id;
            $id = $postData->id;
            $name = $postData->name;
            $email = $postData->email;
            $address = $postData->address;
            $socialMedia = json_encode($postData->socialMedia);
            $description = $postData->description;
            $phone = $postData->phone;
            $mode = $postData->mode;
            $design = json_encode($postData->design);
            $timezone = $postData->timezone;
            $localDefault = $postData->localDefault;
            //$businessUrl = $postData->businessUrl;
            //$domain = $postData->domain;
            $timeFormat = $postData->timeFormat;
            $openingHour = $postData->openingHour;
            $logo = $postData->logo;
            date_default_timezone_set('Asia/Calcutta');

            $updateData = array(
                'name' => $name,
                'email' => $email,
                'description' => $description,
                'phone' => $phone,
                'address' => $address,
                'socialMedia' => $socialMedia,
                'timezone' => $timezone,
                'timeFormat' => $timeFormat,
                'openingHour' => $openingHour,
                //'businessUrl' => $businessUrl,
                'localDefault' => $localDefault,
                'design' => $design,
                'mode' => $mode,
                'logo' => $logo,
                'modified' => date('Y-m-d H:i:s'),
            );

//            $addon_update = array(
//                'name' => $domain,
//                'status' => 1,
//                'modified' => date('Y-m-d H:i:s'),
//            );

            $res = $this->DatabaseModel->updateTable('business', $updateData, array('id' => $id, 'userId' => $userId));
            //$this->DatabaseModel->updateTable('addon_domain', $addon_update, array('bid' => $id, 'userId' => $userId));

            if ($res) {
                $response = array('status' => true, 'message' => 'Business updated successfully.');
            } else {
                $response = array('status' => false, 'message' => 'Business not updated.');
            }

        } else {
            $response = array('status' => false, 'message' => 'Invalid json');
        }
        $this->adi->_response($response);

    }

    public function deleteBusiness()
    {
        $jsonData = file_get_contents("php://input");
        if ($postData = $this->adi->isValidJson($jsonData)) {
            $id = $postData->id;
            $res = $this->DatabaseModel->updateTable('business', array('isDeleted' => 1), array('id' => $id, 'userId' => $this->user_id));
            if ($res) {
                $response = array('status' => true, 'message' => 'Business deleted successfully.');
            } else {
                $response = array('status' => false, 'message' => 'Business not deleted.');
            }

        } else {
            $response = array('status' => false, 'message' => 'Invalid json.');
        }

        $this->adi->_response($response);
    }

    public function designBusiness()
    {
        $jsonData = file_get_contents("php://input");
        if ($postData = $this->adi->isValidJson($jsonData)) {
            $id = $postData->data;
            $data = $postData->data;
            $updateData = $this->DatabaseModel->updateTable('business', array('design' => $data), array('id' => $id));
            if ($updateData) {
                $response = array('status' => true, 'message' => 'Business design saved successfully.');
            } else {
                $response = array('status' => false, 'message' => 'Business design not saved.');
            }
        } else {
            $response = array('status' => false, 'message' => 'Invalid  json.');
        }
        $this->adi->_response($response);
    }
    public function viewBusiness()
    {
        $jsonData = file_get_contents("php://input");
        if ($postData = $this->adi->isValidJson($jsonData)) {
            $id = $postData->id;
            $res = $this->DatabaseModel->fetchTableData('business', array('id' => $id, 'isDeleted' => 0));

            if ($res) {
                $res[0]->design = $res[0]->design ? json_decode($res[0]->design) : "";
                $res[0]->socialMedia = $res ? json_decode($res[0]->socialMedia) : "";
                $res[0]->logo = $res ? $res[0]->logo : "";
                $domain = $this->DatabaseModel->fetchTableData('addon_domain', array('bid' => $id, 'isDeleted' => 0));
                $res[0]->domain = $domain ? $domain[0]->name : '';
                $response = array('status' => true, 'data' => $res);
            } else {
                $response = array('status' => false, 'message' => 'Data not found.');
            }
        } else {
            $response = array('status' => false, 'message' => 'Invalid  json.');
        }

        $this->adi->_response($response);
    }
    public function listBusiness()
    {
        $res = $this->DatabaseModel->fetchTableData('business', array('userId' => $this->user_id, 'isDeleted' => 0));
        foreach ($res as $key => $value) {

            $product = $this->DatabaseModel->fetchTableData('product', array('userId' => $this->user_id, 'isDeleted' => 0, 'bid' => $value->id));
            $count_product = count($product);
            $res[$key]->product = $count_product;

        }

        if ($res) {

            $response = array('status' => true, 'data' => $res);
        } else {
            $response = array('status' => false, 'message' => 'Data not found.');
        }

        $this->adi->_response($response);
    }
}
