<?php
class AutoresponderController extends CI_Controller
{
    private $user_id;

    public function __construct()
    {

        parent::__construct();
        $verify_token = $this->jwt_verify->verify_token_2();
        if ($verify_token['status'] != false) {
            $this->user_id = $verify_token['data']['user_id'];
        } else {
            $this->adi->_response($verify_token);
            die();
        }

    }

    public function authUrlGet()
    {

        $response = array('status' => false, 'message' => 'Invalid json');
        $json_data = file_get_contents("php://input");
        if ($post_data = $this->adi->isValidJson($json_data)) {
            if ($post_data->type != '') {
                if ($post_data->type == 'gr') {
                    $bid = $post_data->bid;
                    $type = $post_data->type;
                    $randomKey = $post_data->key;
                    $client_id_gr = 'f49c29ce-9baa-11ed-b7cf-00163e45cec4';
                    $state_gr = '1997eef5e8dfd06eb64c8ba932abeb9fa_' . $this->user_id . '_' . $bid . '_' . $type . '_' . $randomKey;
                    $dataArr = array(

                        'outhUrl' => 'https://app.getresponse.com/oauth2_authorize.html?response_type=code&client_id=' . $client_id_gr . '&state=' . $state_gr,
                    );

                    $response = array('status' => true, 'message' => 'Get Responce', 'data' => $dataArr);

                } elseif ($post_data->type == 'mc') {
                    $client_id_mc = '960886110647';
                    $bid = $post_data->bid;
                    $type = $post_data->type;
                    $randomKey = $post_data->key;
                    $state = '1997eef5e8dfd06eb64c8ba932abeb9fr_' . $this->user_id . '_' . $bid . '_' . $type . '_' . $randomKey;

                    $dataArr = array(
                        // 'outhUrl' => base_url() . 'mc-connection-finel?id=' . $this->user_id,
                        'outhUrl' => 'https://login.mailchimp.com/oauth2/authorize?response_type=code&client_id=' . $client_id_mc . '&state=' . $state . '&redirect_uri=' . base_url() . 'mc-connection',
                    );
                    $response = array('status' => true, 'message' => 'Get Mailchimp', 'data' => $dataArr);

                } elseif ($post_data->type == 'aw') {
                    $bid = $post_data->bid;
                    $type = $post_data->type;
                    $randomKey = $post_data->key;

                    $client_id_aw = 'q7C5Ea6Lo5g5lcVRMFpkIvmUFdU2ZfCg';
                    $state_aw = '1997eef5e8dfd06eb64c8ba932abeb9f_' . $this->user_id . '_' . $randomKey;
                    $scopes_aw = 'account.read list.read subscriber.write email.read';
                    $dataArr = array(
                        'outhUrl' => 'https://auth.aweber.com/oauth2/authorize?response_type=code&state=' . $state_aw . '&client_id=' . $client_id_aw . '&redirect_uri=' . base_url() . 'aweber-redirect',
                    );
                    $response = array('status' => true, 'message' => 'Get Aweber', 'data' => $dataArr);

                } elseif ($post_data->type == 'sg') {
                    $base_url_sg = 'https://api.sendgrid.com/v3/';
                    $api_key = $post_data->api_key;
                    if ($api_key != '') {
                        $personal_information = $this->curl_file_get_contents($base_url_sg . 'user/profile', $api_key);
                        if (isset($personal_information->userid)) {
                            $email_information = $this->curl_file_get_contents($base_url_sg . 'user/email', $api_key);
                            if (isset($email_information->email)) {
                                $insert['userId'] = $this->user_id;
                                $insert['accountId'] = $personal_information->userid;
                                $insert['name'] = $personal_information->first_name . ' ' . $personal_information->last_name;
                                $access_data['email'] = $email_information->email;
                                $access_data['api_key'] = $api_key;
                                $insert['api_key'] = $api_key;
                                $insert['data'] = json_encode($access_data);
                                $getData = $this->DatabaseModel->fetchTableData('integration', array('api_key' => $api_key, 'user_id' => $this->user_id));
                                if (empty($getData)) {
                                    $check = $this->DatabaseModel->insertData('integration', $insert);
                                } else {
                                    $update['account_id'] = $personal_information->userid;
                                    $update['name'] = $personal_information->first_name . ' ' . $personal_information->last_name;
                                    $update['email'] = $email_information->email;
                                    $access_data['api_key'] = $api_key;
                                    $update['api_key'] = $api_key;
                                    $update['data'] = json_encode($access_data);
                                    $check = $this->DatabaseModel->updateTable('integration', $insert, array('id' => $getData[0]['id'], 'user_id' => $this->user_id));
                                }

                                if ($check != 0) {
                                    $response = array('status' => true, 'message' => 'Your Send grid account connected successfully');
                                } else {
                                    $response = array('status' => false, 'message' => 'Something went wrong. Please try again.');
                                }
                            } else {
                                $response = array('status' => false, 'message' => 'Your api key is not authorized to access your email address');
                            }
                        } else {
                            $response = array('status' => false, 'message' => 'Either your Api key is incorrect or your api key might not have the authorization to access your account');

                        }
                    } else {
                        $response = array('status' => false, 'message' => 'Required paramiter messing');
                    }

                } elseif ($post_data->type == 'si') {
                    $token = $post_data->token;
                    $bid = $post_data->bid;
                    $secret = $post_data->secret;
                    $name = $post_data->name;
                    $date = date('Y-m-d H:i:s');
                    if ($token != '' && $secret != '' && $name != '') {
                        $curl = curl_init();

                        curl_setopt_array($curl, array(
                            CURLOPT_URL => 'https://sendiio.com/api/v1/auth/check',
                            CURLOPT_RETURNTRANSFER => true,
                            CURLOPT_ENCODING => '',
                            CURLOPT_MAXREDIRS => 10,
                            CURLOPT_TIMEOUT => 0,
                            CURLOPT_FOLLOWLOCATION => true,
                            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                            CURLOPT_CUSTOMREQUEST => 'POST',
                            CURLOPT_POSTFIELDS => array('token' => $token, 'secret' => $secret),
                        ));

                        $response = curl_exec($curl);

                        curl_close($curl);
                        $rData = json_decode($response);
                        //echo $response;
                        if (!empty($rData) && $rData->error == 0 && !empty($rData->data)) {
                            // Api key and Hash key is fine, we can save it
                            $insert['userId'] = $this->user_id;
                            $insert['accountId'] = $rData->data->user_id;
                            $rData->data->user_name = $name;
                            $rData->data->secret = $secret;
                            $insert['network_key'] = $token;
                            $insert['name'] = 'si';
                            $insert['bid'] = $bid;
                            $insert['status'] = 1;
                            $insert['type'] = 'si';
                            $insert['created'] = $date;
                            $insert['modified'] = $date;
                            $insert['data'] = json_encode($rData->data);
                            $getData = $this->DatabaseModel->fetchTableData('integration', array('network_key' => $token, 'userId' => $this->user_id));
                            if (empty($getData)) {
                                $check = $this->DatabaseModel->insertData('integration', $insert);
                            } else {
                                $rData->data->user_name = $name;
                                $update['accountId'] = $rData->data->user_id;
                                $update['name'] = 'si';
                                $update['bid'] = $bid;
                                $rData->data->secret = $secret;
                                $update['type'] = 'si';
                                $update['status'] = 1;
                                $update['network_key'] = $token;
                                $update['created'] = $date;
                                $update['modified'] = $date;
                                $update['data'] = json_encode($rData->data);
                                $check = $this->DatabaseModel->updateTable('integration', $update, array('id' => $getData[0]->id, 'userId' => $this->user_id));

                            }
                            if ($check != 0) {
                                $response = array('status' => true, 'message' => 'Your Sendiio account connected successfully');
                            } else {
                                $response = array('status' => false, 'message' => 'Something went wrong. Please try again.');

                            }
                        } else {
                            $response = array('status' => false, 'message' => 'Either your keys is incorrect or you might not have any Lists in your account');

                        }
                    } else {
                        $response = array('status' => false, 'message' => 'Required parameter missing');
                    }
                } elseif ($post_data->type == 'mv') {
                    $token = $post_data->token;
                    $bid = $post_data->bid;
                    $name = $post_data->name;
                    $date = date('Y-m-d H:i:s');
                    if ($token != '' && $name != '') {
                        $curl = curl_init();

                        curl_setopt_array($curl, array(
                            CURLOPT_URL => 'https://apiv2.mailvio.com/campaign',
                            CURLOPT_RETURNTRANSFER => true,
                            CURLOPT_ENCODING => '',
                            CURLOPT_MAXREDIRS => 10,
                            CURLOPT_TIMEOUT => 0,
                            CURLOPT_FOLLOWLOCATION => true,
                            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                            CURLOPT_CUSTOMREQUEST => 'GET',
                            CURLOPT_HTTPHEADER => array(
                                'x-access-token: ' . $token,
                                'Cache-Control: no-cache',
                                'Content-Type: application/json',
                            ),
                        ));

                        $response = curl_exec($curl);
                        curl_close($curl);
                        $rData = json_decode($response);
                        if (isset($rData->error)) {
                            $response = array('status' => false, 'message' => $rData->error);
                        } else {
                            $insert['userId'] = $this->user_id;
                            $rData->user_name = $name;
                            $insert['bid'] = $bid;
                            $insert['name'] = 'mv';
                            $insert['network_key'] = $token;
                            $insert['created'] = $date;
                            $insert['type'] = 'mv';
                            $insert['status'] = 1;

                            $insert['modified'] = $date;
                            $insert['data'] = json_encode($rData);
                            $getData = $this->DatabaseModel->fetchTableData('integration', array('network_key' => $token, 'userId' => $this->user_id));
                            if (empty($getData)) {
                                $check = $this->DatabaseModel->insertData('integration', $insert);
                            } else {
                                $rData->user_name = $name;
                                $update['bid'] = $bid;
                                $rData->bid = $bid;
                                $update['name'] = 'mv';
                                $update['type'] = 'mv';
                                $update['status'] = 1;
                                $update['network_key'] = $token;
                                $update['created'] = $date;
                                $update['modified'] = $date;
                                $update['data'] = json_encode($rData);
                                $check = $this->DatabaseModel->updateTable('integration', $update, array('id' => $getData[0]->id, 'userId' => $this->user_id));

                            }
                            if ($check != 0) {
                                $response = array('status' => true, 'message' => 'Your Mailvio account connected successfully');
                            } else {
                                $response = array('status' => false, 'message' => 'Something went wrong. Please try again.');

                            }
                        }

                    } else {
                        $response = array('status' => false, 'message' => 'Required parameter missing');
                    }
                } else {
                    $response = array('status' => false, 'message' => 'Not match');
                }

            } else {
                $response = array('status' => false, 'message' => 'Messing required parameter');
            }

        } else {
            $response = array('status' => false, 'message' => 'Invalid json');
        }
        $this->adi->_response($response);
    }

    public function curl_post_request($url, $fields, $type = 'no', $headers = null)
    {
        if ($type == 'no') {
            $post = '';
            foreach ($fields as $key => $value) {$post .= $key . '=' . $value . '&';}
            $post = rtrim($post, '&');
        } else {
            $post = $fields;
        }
        $curl = curl_init();
        curl_setopt($curl, CURLOPT_URL, $url);
        if ($headers == null) {

        } else {
            curl_setopt($curl, CURLOPT_HTTPHEADER, $headers);
        }
        curl_setopt($curl, CURLOPT_POST, count($fields));
        curl_setopt($curl, CURLOPT_POSTFIELDS, $post);
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, true);
        $result = curl_exec($curl);
        curl_close($curl);

        $response = json_decode($result);
        return $response;
    }

    public function curl_file_get_contents($url, $access_token = null)
    {
        $curl = curl_init();
        $userAgent = 'Mozilla/6.0 (compatible; MSIE 6.0; Windows NT 5.1; .NET CLR 1.1.4322)';
        if (isset($access_token)) {
            curl_setopt($curl, CURLOPT_HTTPHEADER, array(
                'Content-Type: application/json',
                'Authorization: Bearer ' . $access_token,
            ));
        }
        curl_setopt($curl, CURLOPT_URL, $url); //The URL to fetch. This can also be set when initializing a session with curl_init().
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true); //TRUE to return the transfer as a string of the return value of curl_exec() instead of outputting it out directly.
        curl_setopt($curl, CURLOPT_CONNECTTIMEOUT, 5); //The number of seconds to wait while trying to connect.
        curl_setopt($curl, CURLOPT_IPRESOLVE, CURL_IPRESOLVE_V4);
        curl_setopt($curl, CURLOPT_USERAGENT, $userAgent); //The contents of the "User-Agent: " header to be used in a HTTP request.
        curl_setopt($curl, CURLOPT_FOLLOWLOCATION, true); //To follow any "Location: " header that the server sends as part of the HTTP header.
        curl_setopt($curl, CURLOPT_AUTOREFERER, true); //To automatically set the Referer: field in requests where it follows a Location: redirect.
        curl_setopt($curl, CURLOPT_TIMEOUT, 100); //The maximum number of seconds to allow cURL functions to execute.
        curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false); //To stop cURL from verifying the peer's certificate.
        $contents = curl_exec($curl);
        return json_decode($contents);
    }

    public function fetch_list_gr()
    {
        $response = array('status' => false, 'message' => 'Invalid json');
        $json_data = file_get_contents("php://input");
        if ($post_data = $this->adi->isValidJson($json_data)) {
            if ($post_data->id != '') {
                $id = $post_data->id;
                $base_url_gr = 'https://api.getresponse.com/v3/';
                $account_details = $this->DatabaseModel->fetchTableData('get_response', array('id' => $id));
                if (!empty($account_details)) {
                    $data_details = json_decode($account_details[0]['data']);
                    $access_token = $this->verify_access_token_gr($data_details->access_token, $id);
                    $list_url = $base_url_gr . 'campaigns';
                    $list_information = $this->curl_file_get_contents($list_url, $access_token);
                    if (isset($list_information) && is_array($list_information)) {
                        $response = array('status' => true, 'message' => '', 'data' => $list_information);
                    } else {
                        $response = array('status' => false, 'message' => 'Something went wrong. Please try again');

                    }
                } else {
                    $response = array('status' => false, 'message' => 'No Account with the Given Id');
                }
            } else {
                $response = array('status' => false, 'message' => 'Required paramiter messing');
            }
        } else {
            $response = array('status' => false, 'message' => 'Invalid json');
        }
        $this->adi->_response($response);
    }

    public function verify_access_token_gr($access_token, $id)
    {

        $client_id_gr = '66af130b-3ea7-11ea-8dc5-00163ec8ce26';
        $client_secret_gr = 'a9557d075ad4f1f1df652958b20b5d644d53444f';
        $redirect_url_gr = base_url() . 'gr-connection';
        $base_url_gr = 'https://api.getresponse.com/v3/';
        // Check if access token is valid or not
        $personal_information = $this->curl_file_get_contents($base_url_gr . 'accounts?fields=email,firstName,lastName', $access_token);
        if (!empty($personal_information->code) && $personal_information->code == '1014') {
            // Fetch Refresh Token
            $account_details = $this->DatabaseModel->fetchTableData('get_response', array('id' => $id));
            if (!empty($account_details)) {
                $refresh_token_url = $base_url_gr . 'token';
                $access_token_details = json_decode($account_details[0]['data']);
                $refresh_token_array = array(
                    'grant_type' => 'refresh_token',
                    'refresh_token' => $access_token_details->refresh_token,
                );
                $decoded_result = $this->curl_post_authentication_request($refresh_token_url, $client_id_gr, $client_secret_gr, $refresh_token_array);
                if (!empty($decoded_result->access_token)) {
                    $update['data'] = json_encode($decoded_result);
                    $update['modified'] = date('Y-m-d H:i:s');

                    $done = $this->DatabaseModel->updateTable('get_response', $update, array('id' => $id));
                    if ($done == $id) {
                        return $decoded_result->access_token;
                    } else {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                return false;
            }
        } else {
            // Token is valid
            return $access_token;
        }
    }

    private function verify_access_token_aw($access_token, $id)
    {
        $api_url_aw = 'https://api.aweber.com/1.0/';
        $client_id_aw = 'j4HHUTAVBhJ07fgjSJTi8NvKiVmoenXW';
        $client_secret_aw = '73iMBZx3IEYodGF9RqT8d1KDab0dQp8n';
        // Check if access token is valid or not
        $personal_information = $this->curl_file_get_contents($api_url_aw . 'accounts', $access_token);
        if (isset($personal_information->error) && $personal_information->error === 'invalid_token') {

            // Fetch Refresh Token
            $account_details = $this->DatabaseModel->fetchTableData('aweber', array('id' => $id));
            if ($account_details != 0) {
                $refresh_token_url = 'https://auth.aweber.com/oauth2/token';
                $access_token_details = json_decode($account_details[0]['data']);
                $refresh_token_array = array(
                    'client_id' => $client_id_aw,
                    'client_secret' => $client_secret_aw,
                    'grant_type' => 'refresh_token',
                    'refresh_token' => $access_token_details->refresh_token,
                );
                $decoded_result = $this->curl_post_authentication_request($refresh_token_url, $this->client_id, $this->client_secret, $refresh_token_array);

                if (isset($decoded_result->access_token)) {
                    $update['data'] = json_encode($decoded_result);
                    $update['modified'] = date('Y-m-d H:i:s');

                    $done = $this->DatabaseModel->updateTable('aweber', $update, array('id' => $id));

                    if ($done == $id) {
                        return $decoded_result->access_token;
                    } else {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                return false;
            }
        } else {
            // Token is valid
            return $access_token;
        }
    }
    public function curl_post_authentication_request($url, $username, $password, $fields)
    {
        $post = '';
        foreach ($fields as $key => $value) {$post .= $key . '=' . $value . '&';}
        $post = rtrim($post, '&');

        $curl = curl_init();
        curl_setopt($curl, CURLOPT_URL, $url);
        curl_setopt($curl, CURLOPT_USERPWD, $username . ":" . $password);
        curl_setopt($curl, CURLOPT_POST, count($fields));
        curl_setopt($curl, CURLOPT_POSTFIELDS, $post);
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, true);
        $result = curl_exec($curl);
        curl_close($curl);

        $response = json_decode($result);
        return $response;
    }

    public function autoResponderList()
    {

        $response = array('status' => false, 'message' => 'Invalid json');
        $json_data = file_get_contents("php://input");
        if ($post_data = $this->adi->isValidJson($json_data)) {
            $userID = $this->user_id;
            $bid = $post_data->bid;
            if ($userID != '') {
                $res = $this->DatabaseModel->fetchTableData('integration', array('userId' => $userID, 'bid' => $bid));
                $arr = array('paypal', 'stripe', 'gr', 'aw', 'mc', 'si', 'sg', 'mv', 'razorpay');
                $result = array(
                    'paypal' => [],
                    'stripe' => [],
                    'razorpay' => [],
                    'getresponse' => [],
                    'aweber' => [],
                    'mailchip' => [],
                    'sendiio' => [],
                    'Sendgrid' => [],
                    'Mailvio' => [],
                    'twillio' => []

                );
                // dd($result);
                foreach ($res as $key => $value) {
                    if ($value->name == 'paypal') {
                        $value->data = json_decode($value->data);
                        array_push($result['paypal'], $value);
                    } else if ($value->name == 'stripe') {
                        $value->data = json_decode($value->data);
                        array_push($result['stripe'], $value);

                    } else if ($value->name == 'gr') {
                        $value->data = json_decode($value->data);
                        array_push($result['getresponse'], $value);

                    } else if ($value->name == 'mc') {
                        $value->data = json_decode($value->data);
                        array_push($result['mailchip'], $value);

                    } else if ($value->name == 'aw') {
                        $value->data = json_decode($value->data);
                        array_push($result['aweber'], $value);

                    } else if ($value->name == 'si') {
                        $value->data = json_decode($value->data);
                        array_push($result['sendiio'], $value);

                    } else if ($value->name == 'si') {
                        $value->data = json_decode($value->data);
                        array_push($result['sendiio'], $value);

                    } else if ($value->name == 'sg') {
                        $value->data = json_decode($value->data);
                        array_push($result['Sendgrid'], $value);

                    } else if ($value->name == 'mv') {
                        $value->data = json_decode($value->data);
                        array_push($result['Mailvio'], $value);

                    } else if ($value->name == 'si') {
                        $value->data = json_decode($value->data);
                        array_push($result['sendiio'], $value);

                    } else if ($value->name == 'razorpay') {
                        $value->data = json_decode($value->data);
                        array_push($result['razorpay'], $value);

                    } else if ($value->name == 'twillio') {
                        $value->data = json_decode($value->data);
                        array_push($result['twillio'], $value);

                    }

                }
                $response = array('status' => true, 'data' => $result);

            } else {
                $response = array('status' => false, 'message' => 'Required parameter missing');
            }

        } else {
            $response = array('status' => false, 'message' => 'Invalid json');
        }
        $this->adi->_response($response);

    }

    public function autoresponderIntegratinList()
    {
        $response = array('status' => false, 'message' => 'Invalid json');
        $json_data = file_get_contents("php://input");
        if ($post_data = $this->adi->isValidJson($json_data)) {
            $userID = $this->user_id;
            $bid = $post_data->bid;
            if ($userID != '') {
                $res = $this->DatabaseModel->fetchTableData('integration', array('userId' => $userID, 'bid' => $bid));
                $payment = array('paypal', 'stripe', 'razorpay', 'payU');
                $result = array(
                    'payment' => [],
                    'autoresponder' => [],
                );

                foreach ($res as $key => $val) {
                    if (in_array($val->name, $payment)) {
                        $val->data = json_decode($val->data);
                        array_push($result['payment'], $val);
                    } else {
                        $val->data = json_decode($val->data);
                        array_push($result['autoresponder'], $val);

                    }
                }
                $response = array('status' => true, 'data' => $result);

            } else {
                $response = array('status' => false, 'message' => 'Required parameter missing');
            }

        } else {
            $response = array('status' => false, 'message' => 'Invalid json');
        }
        $this->adi->_response($response);

    }

    public function deleteConnection()
    {
        $response = array('status' => false, 'message' => 'Invalid json');
        $json_data = file_get_contents("php://input");
        if ($post_data = $this->adi->isValidJson($json_data)) {
            $type = $post_data->type;
            $id = $post_data->id;
            $userID = $this->user_id;
            if ($userID != '' && $type != '' && $id != '') {
                $delete = $this->CommonModel->delete($type, array('id' => $id, 'user_id' => $userID));
                if ($delete) {
                    $response = array('status' => true, 'message' => 'Successfully desconnected');
                } else {
                    $response = array('status' => false, 'message' => 'Something went wrong!');
                }

            } else {
                $response = array('status' => false, 'message' => 'Required parameter missing');
            }

        } else {
            $response = array('status' => false, 'message' => 'Invalid json');
        }
        $this->adi->_response($response);
    }

    public function checkNetworkStatus()
    {
        $response = array('status' => false, 'message' => 'Invalid json');
        $json_data = file_get_contents("php://input");
        if ($post_data = $this->adi->isValidJson($json_data)) {
            $key = $post_data->key;
            if ($key != '') {
                $check = $this->DatabaseModel->fetchTableData('integration', array('network_key' => $key));
                if ($check) {
                    $response = array('status' => true, 'message' => 'Successfully connected');
                } else {
                    $response = array('message' => 'Something went wrong!');
                }

            } else {
                $response = array('status' => false, 'message' => 'Required parameter missing');
            }

        } else {
            $response = array('status' => false, 'message' => 'Invalid json');
        }
        $this->adi->_response($response);
    }
    public function baseCurrency()
    {
        $cus = $this->DatabaseModel->fetchTableData('paypalcurrency');
        $response = array('status' => true, 'data' => $cus);
        $this->adi->_response($response);
    }

}
