<?php
class AddonController extends CI_Controller
{
    private $user_id;
    public function __construct()
    {
        parent::__construct();
        $verify_token = $this->jwt_verify->verify_token_2();
        if ($verify_token['status'] != false) {
            $this->user_id = $verify_token['data']['user_id'];
        } else {
            $this->adi->_response($verify_token);
            die();
        }

    }



    public function checkUrl()
    {
        $jsonData = file_get_contents("php://input");
        if ($postData = $this->adi->isValidJson($jsonData)) {
            $url = $postData->url;
            $type = $postData->type;
            if ($type === 'businessUrl') {
                $res = $this->DatabaseModel->fetchTableData('business', array('businessUrl' => $url));
                if (empty($res)) {
                    $response = array('status' => true, 'message' => 'valid business url.');
                } else {
                    $response = array('status' => false, 'message' => 'This Business URL is already taken. Please use a different URL');

                }
            } else {
                $dnsChecker = dns_get_record($url, DNS_A);
                if (!empty($dnsChecker) && $dnsChecker[0]['ip'] == '72.52.158.199') {
                    $res = $this->DatabaseModel->fetchTableData('addon_domain', array('name' => $url));
                    if (empty($res)) {
                        $response = array('status' => true, 'message' => 'valid domain url.');
                    } else {
                        $response = array('status' => false, 'message' => 'This url is already taken.');

                    }
                }
                else{
                    $response = array('status' => false, 'message' => 'Looks like the DNS of your domain is not pointed to our server.');
                }

            }

        } else {
            $response = array('status' => false, 'message' => 'Invalid json.');
        }

        $this->adi->_response($response);
    }

    public function deleteSubdomain()
    {
        $jsonData = file_get_contents("php://input");
        if ($postData = $this->adi->isValidJson()) {

            $domainName = $postData->domainName;
            $result = '';
            //  cpanel user  name
            $cpanel_user = USER_NAME_CPANEL;
            //  cpanel  user password
            $cpanel_pass = USER_PASS_CPANEL;
            //  cpanel  host name
            $cpanel_host = CPANEL_HOST;
            //  cpanel skin
            $cpanel_skin = CPANEL_SKIN;
            //  cpanel  dir
            $cpanel_dir = CPANEL_DIR;

            // create the subdomain
            $subdomain = explode('.', $domainName)[0];
            $pass = base64_encode("$cpanel_user:$cpanel_pass");

            $request = "frontend/.$cpanel_skin./addon/doadddomain.html?doamin=$domainName&subdomain=$subdomain&dir=$cpanel_dir\r\n";
            $sock = fsockopen($cpanel_host, 2082);
            $authstr = "$cpanel_user:$cpanel_pass";

            $in = "GET $request \r\n";
            $in .= "HTTP/1.0\r\n";
            $in .= "HOST:{$cpanel_host}\r\n";
            $in .= "Authorization: Basic $pass\r\n";
            $in .= "\r\n";
            fputs($sock, $in);
            while (!feof($sock)) {
                $result .= fgets($sock, 128);
            }
            fclose($sock);
            if (count(explode('has been successfully removed.', $result)) > 1) {
                $response = array('status' => true, 'message' => 'Deleted successfully.');

            } else {
                $response = array('status' => false, 'message' => 'Not deleted.');

            }

        } else {
            $response = array('status' => false, 'message' => 'Invalid json');
        }
    }

    public function addCurrency()
    {
        $json_data = file_get_contents("php://input");
        if ($post_data = $this->adi->isValidJson($json_data)) {
            $currency = $post_data->baseCurrency;
            $symbol = $post_data->symbol;

            $insert = array(
                'baseCurrency' => $currency,
                'symbol' => $symbol,
            );
            if (!empty($currency)) {
                $res = $this->DatabaseModel->updateTable('users', $insert, array('id' => $this->user_id));
                if (!empty($res)) {
                    $response = array('status' => true, 'message' => 'Your base currency added successfully.');

                } else {
                    $response = array('status' => false, 'message' => 'User information is not provided.');
                }

            } else {
                $response = array('status' => false, 'message' => 'Currency information is not provided.');
            }

        } else {
            $response = array('status' => false, 'message' => 'Invalid json');
        }
        $this->adi->_response($response);
    }
    public function addDomain()
    {
        $response = array('status' => false, 'message' => 'Invalid json');
        $json_data = file_get_contents("php://input");
        if ($post_data = $this->adi->isValidJson($json_data)) {
            $date = date('Y-m-d H:i:s');
            $domainName = $post_data->domainName;
            $userID = $this->user_id;
            $bid = $post_data->bid;

            if ($domainName != '') {
                $dnsChecker = dns_get_record($domainName, DNS_A);
                if (!empty($dnsChecker) && $dnsChecker[0]['ip'] == '72.52.158.199') {
                    $storeExist = $this->DatabaseModel->fetchTableData('addon_domain', array('name' => $domainName));
                    if (!empty($storeExist)) {
                        $response = array('status' => false, 'message' => 'This domain allready exist');
                        $this->adi->_response($response);
                    }
                    $result = '';
                    // your cPanel username
                    $cpanel_user = USER_NAME_CPANEL;

                    // your cPanel password
                    $cpanel_pass = USER_PASS_CPANEL;

                    $cpanel_host = CPANEL_HOST;

                    // directory - defaults to public_html/subdomain_name
                    $dir = CPANEL_DIR;

                    // create the subdomain

                    $sock = fsockopen($cpanel_host, 2082);
                    if (!$sock) {
                        $response = array('status' => true, 'message' => 'Socket error!');
                        //print('Socket error');
                        exit();
                    }

                    $sock = fsockopen($cpanel_host, 2082);

                    $pass = base64_encode("$cpanel_user:$cpanel_pass");

                    $buildRequest = "https://backend.fastpaid.io:2083/cpsess3820629714/json-api/cpanel?cpanel_jsonapi_user=$cpanel_user&cpanel_jsonapi_apiversion=2&cpanel_jsonapi_module=AddonDomain&cpanel_jsonapi_func=addaddondomain&newdomain=$domainName&subdomain=$domainName&dir=$dir";

                    // Make the API call
                    $curl = curl_init();
                    curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, 0);
                    curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, 0);
                    curl_setopt($curl, CURLOPT_HEADER, 0);
                    curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
                    $header[0] = "Authorization: Basic " . base64_encode($cpanel_user . ":" . $cpanel_pass) . "\n\r";
                    curl_setopt($curl, CURLOPT_HTTPHEADER, $header);
                    curl_setopt($curl, CURLOPT_URL, $buildRequest);
                    $result = curl_exec($curl);

                    // Check the result
                    if ($result == false) {
                        error_log("curl_exec threw error \"" . curl_error($curl) . "\" for $buildRequest");
                    }
                    curl_close($curl);
                    $var = json_decode($result);
                    $res = $var->cpanelresult->data[0]->reason;

                    if (strpos($res, "system successfully parked")) {

                        $insert['name'] = $domainName;
                        $insert['userId'] = $userID;
                        $insert['bid'] = $bid;
                        $insert['isDeleted'] = 0;
                        $insert['status'] = 1;
                        $insert['modified'] = $date;
                        $insert['created'] = $date;

                        $res = $this->DatabaseModel->insertData('addon_domain', $insert);
                        if ($res) {
                            $response = array('status' => true, 'message' => 'Business url generated successfully.');
                        } else {
                            $response = array('status' => false, 'message' => 'Business url not  generated');

                        }

                    } else if (strpos($res, "already exists")) {
                        $response = array('status' => false, 'message' => 'Already added');
                    } else if (strpos($res, "domain name must have a valid")) {
                        $response = array('status' => false, 'message' => 'domain name must have a valid');
                    }
                } else {
                    $response = array('status' => false, 'message' => 'Not vaild domain!');
                }

            } else {
                $response = array('status' => false, 'message' => 'Required parameter missing');
            }

        } else {
            $response = array('status' => false, 'message' => 'Invalid json');
        }
        $this->adi->_response($response);

    }

}
