<?php
defined('BASEPATH') or exit('No direct script access allowed');

/*
| -------------------------------------------------------------------------
| URI ROUTING
| -------------------------------------------------------------------------
| This file lets you re-map URI requests to specific controller functions.
|
| Typically there is a one-to-one relationship between a URL string
| and its corresponding controller class/method. The segments in a
| URL normally follow this pattern:
|
|    example.com/class/method/id/
|
| In some instances, however, you may want to remap this relationship
| so that a different class/function is called than the one
| corresponding to the URL.
|
| Please see the user guide for complete details:
|
|    https://codeigniter.com/user_guide/general/routing.html
|
| -------------------------------------------------------------------------
| RESERVED ROUTES
| -------------------------------------------------------------------------
|
| There are three reserved routes:
|
|    $route['default_controller'] = 'welcome';
|
| This route indicates which controller class should be loaded if the
| URI contains no data. In the above example, the "welcome" class
| would be loaded.
|
|    $route['404_override'] = 'errors/page_missing';
|
| This route will tell the Router which controller/method to use if those
| provided in the URL cannot be matched to a valid route.
|
|    $route['translate_uri_dashes'] = FALSE;
|
| This is not exactly a route, but allows you to automatically route
| controller and method names that contain dashes. '-' isn't a valid
| class or method name character, so it requires translation.
| When you set this option to TRUE, it will replace ALL dashes in the
| controller and method URI segments.
|
| Examples:    my-controller/index    -> my_controller/index
|        my-controller/my-method    -> my_controller/my_method
 */
$route['default_controller'] = 'Home'; //Testing Done
$route['404_override'] = 'Home/not_found'; //Testing Done

//testing new routes
$route['login'] = 'Home/validate_login'; // done
$route['product'] = 'Home/index'; // done
$route['product/(:any)'] = 'Home/index/$1'; // done

$route['logout'] = 'Home/logout'; // done
$route['forgot-password'] = 'Home/forgotPassword'; // done
$route['reset-password'] = 'Home/resetPassword'; // done
$route['master-login'] = 'Home/masterLogin'; // done

$route['delete_uploads_older_than_7_days'] = 'Home/delete_uploads_older_than_7_days'; // done

$route['fetch-user'] = 'UsersController/fetchUser'; // done
$route['profile'] = 'UsersController/profile'; //  done

$route['update-profile-image'] = 'UsersUpload/changeProfileImage'; // done
$route['upload-file'] = 'UsersUpload/file_upload'; // done
$route['upload-image'] = 'UsersUpload/uploadImage';
$route['fetch-images'] = 'UsersUpload/fetchAllImages';
$route['delete-user-image'] = 'UsersUpload/deleteImages';

$route['change-email'] = 'UsersController/changeEmail'; //done
$route['disable-account'] = 'UsersController/disableAccount'; //  done
$route['delete-account'] = 'UsersController/deleteAccount'; // done
$route['edit-client-account'] = 'UsersController/editClientAccount'; //  done
$route['create-client'] = 'UsersController/clientAccount'; // done
$route['fetch-clients'] = 'UsersController/fetchClientAccount'; // done
$route['delete-client'] = 'UsersController/deleteClient'; // done
$route['download-user-data'] = 'UsersController/downloadAllData'; // done
$route['add-reseller'] = 'UsersController/reseller'; // done
$route['delete-reseller'] = 'UsersController/deleteRowsResellerAccount'; //  done
$route['fetch-reseller'] = 'UsersController/fetchResellerAccounts'; // done
$route['update-reseller'] = 'UsersController/editReseller'; //  done
$route['wl-rebranding'] = 'UsersController/WLRebranding'; // done
$route['delete-wl'] = 'UsersController/deleteWL'; // done
$route['fetch-wl-rebranding'] = 'UsersController/fetchWLRebranding'; //done
$route['delete-rows-client'] = 'UsersController/deleteRowsClient'; // done

//  This is media controller routes

$route['generate-file'] = 'MediaController/generateFile'; //  done
$route['load-library-audio'] = 'MediaController/loadLibraryAudio'; // done
$route['load-library-images'] = 'MediaController/loadLibraryImage'; // done
$route['get-artists'] = 'MediaController/getArtist'; // done
$route['get-polly-languages'] = 'MediaController/getPollyLanguages'; // done
$route['generate-tts-new'] = 'MediaController/generateTTSNew'; //  done
$route['fetch-user-uploaded-file'] = 'MediaController/loadUserFile'; // done
$route['delete-media-file'] = 'MediaController/deleteUploadFile'; //done
$route['upload-wav'] = 'MediaController/uploadWav'; // d
$route['fetch-google-language'] = 'MediaController/fetch_google_Language'; // done
$route['translate'] = 'MediaController/translate'; // done

/**
 * Social Account (Testing Done)
 */

$route['delete-integration'] = 'SocialAccountController/deleteIntegration'; // done

/**
 * SuperAdmin Routes ( Testing Done )
 */
$route['api/fetch-users'] = 'SuperAdminController/fetchUsers'; //  done
$route['api/flagged_user'] = 'SuperAdminController/flagged_user'; //  done
$route['api/fetch-user'] = 'SuperAdminController/fetchUser'; // done
$route['api/add-user'] = 'SuperAdminController/addUser'; // done
$route['api/delete-user'] = 'SuperAdminController/deleteUser'; // done
$route['api/disable-user'] = 'SuperAdminController/disableUser'; // done
$route['api/update-password'] = 'SuperAdminController/updatePassword'; // done
$route['api/update-email'] = 'SuperAdminController/updateEmail'; //  done
$route['api/check-user'] = 'SuperAdminController/checkUser'; //done

// Autoresponder

$route['autoresponder-auth-url'] = 'AutoresponderController/authUrlGet';
$route['check-network-status'] = 'AutoresponderController/checkNetworkStatus';
$route['mc-connection-finel'] = 'AutoresponderWithoutAuthController/mcConnectionFinel';
$route['gr-connection'] = 'AutoresponderWithoutAuthController/grConnection';
$route['mc-connection'] = 'AutoresponderWithoutAuthController/mcConnection';
$route['mc-connection-finel'] = 'AutoresponderWithoutAuthController/mcConnectionFinel';
$route['aweber-redirect'] = 'AutoresponderWithoutAuthController/awConnection';
$route['autoresponder-list'] = 'AutoresponderController/autoResponderList';
$route['autoresponder-integration-list'] = 'AutoresponderController/autoresponderIntegratinList';
$route['delete-autoresponder-connection'] = 'AutoresponderController/deleteConnection';
$route['base-currency'] = 'AutoresponderController/baseCurrency';

/**
 *  Business Controller
 */

$route['create-business'] = 'BusinessController/createBusiness';
$route['update-business'] = 'BusinessController/updateBusiness';
$route['delete-business'] = 'BusinessController/deleteBusiness';
$route['duplicate-business'] = 'BusinessController/duplicateBusiness';
$route['business-design'] = 'BusinessController/designBusiness';
$route['view-business'] = 'BusinessController/viewBusiness'; //  id
$route['fetch-list-business'] = 'BusinessController/listBusiness'; // user id

/**
 *  Addon Controller
 */

$route['add-subdomain'] = 'AddonController/addonSubdomain'; //  create business url
$route['check-business-url'] = 'AddonController/checkUrl'; // user id
// $route['store-get'] = 'AddonController/getStore';
$route['currency-add'] = 'AddonController/addCurrency';
$route['add-addon-domain'] = 'AddonController/addDomain';

//Paypal
$route['paypal-auth'] = 'PaypalController/auth';
$route['order-success'] = 'OrderController/successPaypalPayment';
$route['order-cancel'] = 'OrderController/cancelPaypalPayment';
$route['paypal-refund-request'] = 'PaypalController/refundCreate';
$route['delete-connection'] = 'PaypalController/deleteConnection';

/**
 * stripe controller
 */
$route['stripe-integration'] = 'StripeController/stripeAuth';
$route['orderpay'] = 'StripeController/orderPay';

/**
 * Product controller
 */

$route['create-product'] = 'ProductController/createProduct';
$route['update-product'] = 'ProductController/updateProduct';
$route['delete-product'] = 'ProductController/deleteProduct';
$route['design-product'] = 'ProductController/designProduct';
$route['view-product'] = 'ProductController/viewProduct';
$route['fetch-list-product'] = 'ProductController/fetchListProduct';
$route['duplicate-product'] = 'ProductController/productDuplicate';

/**
 * Analytics controller
 */
$route['fetch-analytics'] = 'AnalyticsController/fetchAnalytics';


/**
 * Customers controller
 */
$route['create-customer'] = 'CustomerController/createCustomer';
$route['update-customer'] = 'CustomerController/updateCustomer';
$route['delete-customer'] = 'CustomerController/deleteCustomer';
// $route['fetch-customer'] = 'CustomerController/fetchCustomer';
$route['customer-list'] = 'CustomerController/customerList';
$route['view-customer'] = 'CustomerController/viewCustomer';
$route['upload-csv'] = 'UsersUpload/upload_csv';

/**
 * Coupon controller
 */

$route['create-coupon'] = 'CouponController/createCoupon';
$route['update-coupon'] = 'CouponController/updateCoupon';
$route['delete-coupon'] = 'CouponController/deleteCoupon';
$route['assign-coupon'] = 'CouponController/assignCoupon';
$route['verify-coupon'] = 'CouponController/verifyCoupon';
$route['list-coupon'] = 'CouponController/listCoupon';
$route['view-coupon'] = 'CouponController/viewCoupon';

/**
 * Remainder controller
 */

$route['create-remainder'] = 'RemainderController/createRemainder';
$route['update-remainder'] = 'RemainderController/updateRemainder';
$route['delete-remainder'] = 'RemainderController/deleteRemainder';
$route['view-remainder'] = 'RemainderController/viewRemainder';
$route['fetch-remainder'] = 'RemainderController/fetchRemainder';
$route['send-remainder'] = 'RemainderController/sendRemainder';

/**
 * Invoice controller
 */

$route['generate-invoice'] = 'InvoiceController/generateInvoice';

/**
 * Staff controller
 */

$route['create-staff'] = 'StaffController/createStaff';
$route['delete-staff'] = 'StaffController/deleteStaff';
$route['update-staff'] = 'StaffController/updateStaff';
$route['view-staff'] = 'StaffController/fetchStaffAccount';
$route['list-staff'] = 'StaffController/fetchListStaff';

/**
 *   controller
 */
$route['load-product'] = 'LoadController/product_page';
$route['load-business'] = 'LoadController/business_page';
$route['load-checkout'] = 'LoadController/checkout_page';
$route['total-client'] = 'CustomerController/countCustomer';



/**
 * home  controller in guest folder
 */
$route['verify-coupon-checkout'] = 'guest/HomeController/verifyCouponCheckOut';
$route['load-business/(:num)'] = 'guest/HomeController/loadBusiness/$1';
$route['load-product/(:num)'] = 'guest/HomeController/loadProduct/$1';
$route['order-create'] = 'guest/HomeController/orderCreate';
$route['paypal-success'] = 'guest/HomeController/paypalSuccess';
$route['paypal-error'] = 'guest/HomeController/paypalError';

/**
 * Razorpay  controller
 */

$route['razorpay-auth'] = 'RazorpayController/authRazorpay';

/**
 *  SMS integration
 */
$route['add-twillio'] = 'SmsController/addTwillio';
